/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ProfileChangeEvent;
import ca.sqlpower.architect.profile.ProfileChangeListener;
import ca.sqlpower.architect.profile.TestProfileBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TestProfileManagerListeners
extends TestProfileBase {
    int addedEvents = 0;
    int removedEvents = 0;

    public void testListeners() throws Exception {
        ProfileChangeListener listener = new ProfileChangeListener(){

            public void profileAdded(ProfileChangeEvent e) {
                ++TestProfileManagerListeners.this.addedEvents;
            }

            public void profileRemoved(ProfileChangeEvent e) {
                ++TestProfileManagerListeners.this.removedEvents;
            }
        };
        this.pm.addProfileChangeListener(listener);
        TestProfileManagerListeners.assertEquals((int)0, (int)this.addedEvents);
        TestProfileManagerListeners.assertEquals((int)0, (int)this.removedEvents);
        ArrayList<SQLTable> tableList = new ArrayList<SQLTable>();
        Connection conn = this.mydb.getConnection();
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate("DROP TABLE PROFILE_TEST5");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String cmd = "CREATE TABLE PROFILE_TEST5 (id integer)";
        stmt.executeUpdate(cmd);
        int i = 0;
        while (i < 10) {
            cmd = String.format("insert into PROFILE_TEST5 values(%d)", i);
            stmt.executeUpdate(cmd);
            ++i;
        }
        SQLTable t = this.mydb.getTableByName("PROFILE_TEST5");
        tableList.add(t);
        this.pm.createProfiles(tableList);
        TestProfileManagerListeners.assertEquals((String)"table and 1 column got added", (int)2, (int)this.addedEvents);
        TestProfileManagerListeners.assertEquals((int)0, (int)this.removedEvents);
        this.pm.remove(t.getColumn(0));
        TestProfileManagerListeners.assertEquals((int)2, (int)this.addedEvents);
        TestProfileManagerListeners.assertEquals((String)"Column Removal of single-col table removes col + table", (int)2, (int)this.removedEvents);
        this.pm.createProfiles(tableList);
        this.pm.remove(t);
        TestProfileManagerListeners.assertEquals((int)4, (int)this.addedEvents);
        TestProfileManagerListeners.assertEquals((String)"Table Removed", (int)4, (int)this.removedEvents);
    }
}

