/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.diff.SQLObjectComparator;
import ca.sqlpower.architect.diff.SQLRelationshipComparator;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLRelationshipComparatorTest
extends TestCase {
    SQLRelationshipComparator colComparator = new SQLRelationshipComparator();
    Comparator<SQLObject> comparator = new SQLObjectComparator();
    SQLTable table1L;
    SQLTable table2L;
    SQLRelationship left;

    protected void setUp() throws Exception {
        this.table1L = this.makeTable(1);
        this.table2L = this.makeTable(3);
        this.left = new SQLRelationship();
        this.table1L.getColumn(0).setPrimaryKeySeq(1);
        this.left.addMapping(this.table1L.getColumn(0), this.table2L.getColumn(1));
    }

    public void testCompareRelationShipWithOneNull() throws ArchitectException {
        SQLRelationshipComparatorTest.assertEquals((String)"The source is null, should be -1", (int)-1, (int)this.colComparator.compare(null, this.left));
        SQLRelationshipComparatorTest.assertEquals((String)"The source is null, should be 1", (int)1, (int)this.colComparator.compare(this.left, null));
    }

    public void testCompareSameRelationShip() throws ArchitectException {
        SQLTable table1R = this.makeTable(1);
        SQLTable table2R = this.makeTable(3);
        SQLRelationship right = new SQLRelationship();
        table1R.getColumn(0).setPrimaryKeySeq(1);
        right.addMapping(table1R.getColumn(0), table2R.getColumn(1));
        SQLRelationshipComparatorTest.assertEquals((String)"Should be same relationship", (int)0, (int)this.colComparator.compare(this.left, right));
    }

    public void testCompareWithDifferentMappings() throws ArchitectException {
        SQLTable table1R = this.makeTable(1);
        SQLTable table2R = this.makeTable(3);
        SQLRelationship right = new SQLRelationship();
        table1R.getColumn(0).setPrimaryKeySeq(1);
        right.addMapping(table1R.getColumn(0), table2R.getColumn(0));
        SQLRelationshipComparatorTest.assertNotSame((String)"Shouldn't be same relationship", (Object)0, (Object)this.colComparator.compare(this.left, right));
    }

    public void testCompareWithExtraMapping() throws ArchitectException {
        SQLTable table1R = this.makeTable(1);
        SQLTable table2R = this.makeTable(3);
        SQLRelationship right = new SQLRelationship();
        table1R.getColumn(0).setPrimaryKeySeq(1);
        right.addMapping(table1R.getColumn(0), table2R.getColumn(1));
        right.addMapping(table1R.getColumn(0), table2R.getColumn(2));
        SQLRelationshipComparatorTest.assertNotSame((String)"Shouldn't be same relationship", (Object)0, (Object)this.colComparator.compare(this.left, right));
    }

    public void testCompareColumn() throws ArchitectException {
        Set<SQLColumn> list1 = this.generateColumnList(3);
        Set<SQLColumn> list2 = this.generateColumnList(3);
        SQLRelationshipComparatorTest.assertEquals((int)0, (int)this.colComparator.compareColumns(list1, list2));
        list1.add(new SQLColumn());
        SQLRelationshipComparatorTest.assertEquals((int)1, (int)this.colComparator.compareColumns(list1, list2));
        SQLRelationshipComparatorTest.assertEquals((int)-1, (int)this.colComparator.compareColumns(list2, list1));
    }

    public Set<SQLColumn> generateColumnList(int num) throws ArchitectException {
        TreeSet<SQLObject> colList = new TreeSet<SQLObject>(this.comparator);
        int ii = 1;
        while (ii <= num) {
            colList.add(new SQLColumn(new SQLTable(), "col" + ii, 4, 3, 0));
            ++ii;
        }
        return colList;
    }

    private SQLTable makeTable(int i) throws ArchitectException {
        SQLTable t = new SQLTable(null, "table_" + i, "remark on this", "TABLE", true);
        int j = 0;
        while (j < i) {
            t.addColumn(new SQLColumn(t, "column_" + j, 4, 3, 0));
            ++j;
        }
        return t;
    }
}

