/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class OracleDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 1.23 $";
    private static final Logger logger = Logger.getLogger(OracleDDLGenerator.class);
    private static HashSet reservedWords = new HashSet();

    static {
        reservedWords.add("ACCESS");
        reservedWords.add("ADD");
        reservedWords.add("ALL");
        reservedWords.add("ALTER");
        reservedWords.add("AND");
        reservedWords.add("ANY");
        reservedWords.add("ARRAYLEN");
        reservedWords.add("AS");
        reservedWords.add("ASC");
        reservedWords.add("AUDIT");
        reservedWords.add("BETWEEN");
        reservedWords.add("BY");
        reservedWords.add("CHAR");
        reservedWords.add("CHECK");
        reservedWords.add("CLUSTER");
        reservedWords.add("COLUMN");
        reservedWords.add("COMMENT");
        reservedWords.add("COMPRESS");
        reservedWords.add("CONNECT");
        reservedWords.add("CREATE");
        reservedWords.add("CURRENT");
        reservedWords.add("DATE");
        reservedWords.add("DECIMAL");
        reservedWords.add("DEFAULT");
        reservedWords.add("DELETE");
        reservedWords.add("DESC");
        reservedWords.add("DISTINCT");
        reservedWords.add("DROP");
        reservedWords.add("ELSE");
        reservedWords.add("EXCLUSIVE");
        reservedWords.add("EXISTS");
        reservedWords.add("FILE");
        reservedWords.add("FLOAT");
        reservedWords.add("FOR");
        reservedWords.add("FROM");
        reservedWords.add("GRANT");
        reservedWords.add("GROUP");
        reservedWords.add("HAVING");
        reservedWords.add("IDENTIFIED");
        reservedWords.add("IMMEDIATE");
        reservedWords.add("IN");
        reservedWords.add("INCREMENT");
        reservedWords.add("INDEX");
        reservedWords.add("INITIAL");
        reservedWords.add("INSERT");
        reservedWords.add("INTEGER");
        reservedWords.add("INTERSECT");
        reservedWords.add("INTO");
        reservedWords.add("IS");
        reservedWords.add("LEVEL");
        reservedWords.add("LIKE");
        reservedWords.add("LOCK");
        reservedWords.add("LONG");
        reservedWords.add("MAXEXTENTS");
        reservedWords.add("MINUS");
        reservedWords.add("MODE");
        reservedWords.add("MODIFY");
        reservedWords.add("NOAUDIT");
        reservedWords.add("NOCOMPRESS");
        reservedWords.add("NOT");
        reservedWords.add("NOTFOUND");
        reservedWords.add("NOWAIT");
        reservedWords.add("NULL");
        reservedWords.add("NUMBER");
        reservedWords.add("OF");
        reservedWords.add("OFFLINE");
        reservedWords.add("ON");
        reservedWords.add("ONLINE");
        reservedWords.add("OPTION");
        reservedWords.add("OR");
        reservedWords.add("ORDER");
        reservedWords.add("PCTFREE");
        reservedWords.add("PRIOR");
        reservedWords.add("PRIVILEGES");
        reservedWords.add("PUBLIC");
        reservedWords.add("RAW");
        reservedWords.add("RENAME");
        reservedWords.add("RESOURCE");
        reservedWords.add("REVOKE");
        reservedWords.add("ROW");
        reservedWords.add("ROWID");
        reservedWords.add("ROWLABEL");
        reservedWords.add("ROWNUM");
        reservedWords.add("ROWS");
        reservedWords.add("START");
        reservedWords.add("SELECT");
        reservedWords.add("SESSION");
        reservedWords.add("SET");
        reservedWords.add("SHARE");
        reservedWords.add("SIZE");
        reservedWords.add("SMALLINT");
        reservedWords.add("SQLBUF");
        reservedWords.add("SUCCESSFUL");
        reservedWords.add("SYNONYM");
        reservedWords.add("SYSDATE");
        reservedWords.add("TABLE");
        reservedWords.add("THEN");
        reservedWords.add("TO");
        reservedWords.add("TRIGGER");
        reservedWords.add("UID");
        reservedWords.add("UNION");
        reservedWords.add("UNIQUE");
        reservedWords.add("UPDATE");
        reservedWords.add("USER");
        reservedWords.add("VALIDATE");
        reservedWords.add("VALUES");
        reservedWords.add("VARCHAR");
        reservedWords.add("VARCHAR2");
        reservedWords.add("VIEW");
        reservedWords.add("WHENEVER");
        reservedWords.add("WHERE");
        reservedWords.add("WITH");
    }

    public void writeHeader() {
        this.println("-- Created by SQLPower Oracle 8i/9i DDL Generator $Revision: 1.23 $ --");
    }

    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(new Integer(-5), new GenericTypeDescriptor("NUMBER", -5, 38L, null, null, 1, true, false));
        this.typeMap.put(new Integer(-2), new GenericTypeDescriptor("RAW", -2, 2000L, null, null, 1, true, false));
        this.typeMap.put(new Integer(-7), new GenericTypeDescriptor("NUMBER", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(new Integer(2004), new GenericTypeDescriptor("BLOB", 2004, 4000000000L, null, null, 1, true, false));
        this.typeMap.put(new Integer(1), new GenericTypeDescriptor("CHAR", 1, 2000L, "'", "'", 1, true, false));
        this.typeMap.put(new Integer(2005), new GenericTypeDescriptor("CLOB", 2005, 4000000000L, null, null, 1, true, false));
        this.typeMap.put(new Integer(91), new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(new Integer(3), new GenericTypeDescriptor("NUMBER", 3, 38L, null, null, 1, true, true));
        this.typeMap.put(new Integer(8), new GenericTypeDescriptor("NUMBER", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(new Integer(6), new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(new Integer(4), new GenericTypeDescriptor("NUMBER", 4, 38L, null, null, 1, true, false));
        this.typeMap.put(new Integer(-4), new GenericTypeDescriptor("LONG RAW", -4, 2000000000L, null, null, 1, true, false));
        this.typeMap.put(new Integer(-1), new GenericTypeDescriptor("VARCHAR2", -1, 4000L, "'", "'", 1, true, false));
        this.typeMap.put(new Integer(2), new GenericTypeDescriptor("NUMBER", 2, 38L, null, null, 1, true, true));
        this.typeMap.put(new Integer(7), new GenericTypeDescriptor("NUMBER", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(new Integer(5), new GenericTypeDescriptor("NUMBER", 5, 38L, null, null, 1, true, false));
        this.typeMap.put(new Integer(92), new GenericTypeDescriptor("DATE", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(new Integer(93), new GenericTypeDescriptor("DATE", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(new Integer(-6), new GenericTypeDescriptor("NUMBER", -6, 38L, null, null, 1, true, false));
        this.typeMap.put(new Integer(-1), new GenericTypeDescriptor("LONG", -1, 2000000000L, null, null, 1, true, false));
        this.typeMap.put(new Integer(-3), new GenericTypeDescriptor("LONG RAW", -3, 2000000000L, null, null, 1, true, false));
        this.typeMap.put(new Integer(12), new GenericTypeDescriptor("VARCHAR2", 12, 4000L, "'", "'", 1, true, false));
    }

    protected void createProfileFunctionMap() {
        this.profileFunctionMap = new HashMap();
        this.profileFunctionMap.put("BIT", new ProfileFunctionDescriptor("BIT", -7, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("CHAR", new ProfileFunctionDescriptor("CHAR", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("BINARY", new ProfileFunctionDescriptor("BINARY", -2, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("VARBINARY", new ProfileFunctionDescriptor("VARBINARY", -3, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("RAW", new ProfileFunctionDescriptor("VARBINARY", -3, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("VARCHAR", new ProfileFunctionDescriptor("VARCHAR", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("VARCHAR2", new ProfileFunctionDescriptor("VARCHAR", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("NVARCHAR2", new ProfileFunctionDescriptor("NVARCHAR", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("BLOB", new ProfileFunctionDescriptor("BLOB", 2004, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("CLOB", new ProfileFunctionDescriptor("CLOB", 2005, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("BIGINT", new ProfileFunctionDescriptor("BIGINT", -5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("DECIMAL", new ProfileFunctionDescriptor("DECIMAL", 3, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("DOUBLE", new ProfileFunctionDescriptor("DOUBLE", 8, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("FLOAT", new ProfileFunctionDescriptor("FLOAT", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("INTEGER", new ProfileFunctionDescriptor("INTEGER", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("NUMERIC", new ProfileFunctionDescriptor("NUMERIC", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("NUMBER", new ProfileFunctionDescriptor("NUMERIC", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("REAL", new ProfileFunctionDescriptor("REAL", 7, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("SMALLINT", new ProfileFunctionDescriptor("SMALLINT", 5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("TINYINT", new ProfileFunctionDescriptor("TINYINT", -6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("INTERVALDS", new ProfileFunctionDescriptor("TINYINT", -6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("INTERVALYM", new ProfileFunctionDescriptor("TINYINT", -6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("TIME", new ProfileFunctionDescriptor("TIME", 92, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("TIMESTAMP", new ProfileFunctionDescriptor("TIMESTAMP", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("TIMESTAMP WITH LOCAL TIME ZONE", new ProfileFunctionDescriptor("TIMESTAMP", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("TIMESTAMP WITH TIME ZONE", new ProfileFunctionDescriptor("TIMESTAMP", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("DATE", new ProfileFunctionDescriptor("DATE", 91, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("LONG", new ProfileFunctionDescriptor("LONGVARCHAR", -1, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("LONG RAW", new ProfileFunctionDescriptor("LONGVARBINARY", -4, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("STRUCT", new ProfileFunctionDescriptor("LONGVARBINARY", -4, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("ARRAY", new ProfileFunctionDescriptor("LONGVARBINARY", -4, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("REF", new ProfileFunctionDescriptor("LONGVARBINARY", -4, false, false, false, false, false, false, false, false));
    }

    private String toIdentifier(String logicalName, String physicalName) {
        if (logicalName == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getting physical name for: " + logicalName));
        }
        String ident = logicalName.replace(' ', '_').toUpperCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after replace of spaces: " + ident));
        }
        ident = ident.replaceAll("[^a-zA-Z0-9_]", "_");
        if (physicalName == null) {
            if (ident.length() < 31) {
                return ident;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("truncating identifier: " + ident));
            }
            String base = ident.substring(0, 27);
            int tiebreaker = (ident.hashCode() % 1000 + 1000) % 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new identifier: " + base + tiebreaker));
            }
            return String.valueOf(base) + tiebreaker;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("physical idenfier is not unique, regenerating: " + physicalName));
        }
        String base = ident;
        if (ident.length() > 27) {
            base = ident.substring(0, 27);
        }
        int tiebreaker = ((String.valueOf(ident) + physicalName).hashCode() % 1000 + 1000) % 1000;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("regenerated identifier is: " + base + tiebreaker));
        }
        return String.valueOf(base) + tiebreaker;
    }

    public boolean isReservedWord(String word) {
        return reservedWords.contains(word.toUpperCase());
    }

    public String toIdentifier(String name) {
        return this.toIdentifier(name, null);
    }

    public String getCatalogTerm() {
        return null;
    }

    public String getSchemaTerm() {
        return "Schema";
    }

    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "ALTER TABLE " + this.toQualifiedName(fkTable) + " DROP CONSTRAINT " + fkName;
    }

    public void modifyColumn(SQLColumn c) {
        HashMap colNameMap = new HashMap();
        SQLTable t = c.getParentTable();
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(t.getPhysicalName()));
        this.print(" MODIFY ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.MODIFY, c);
    }

    public void addColumn(SQLColumn c) {
        HashMap colNameMap = new HashMap();
        this.print("\n ALTER TABLE ");
        this.print(this.toQualifiedName(c.getParentTable()));
        this.print(" ADD ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.CREATE, c);
    }

    public String caseWhenNull(String expression, String then) {
        StringBuffer sql = new StringBuffer();
        sql.append("DECODE(");
        sql.append(expression);
        sql.append(",NULL,");
        sql.append(then);
        sql.append(")");
        return sql.toString();
    }
}

