/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLWarning;
import org.apache.log4j.Logger;

public class NameChangeWarning
implements DDLWarning {
    private static final Logger logger = Logger.getLogger(NameChangeWarning.class);
    protected SQLObject subject;
    protected String reason;
    protected String oldName;

    public NameChangeWarning(SQLObject subject, String reason, String oldName) {
        this.subject = subject;
        this.reason = reason;
        this.oldName = oldName;
    }

    public SQLObject getSubject() {
        return this.subject;
    }

    public String getReason() {
        return this.reason;
    }

    public Object getOldValue() {
        if (this.getSubject() instanceof SQLColumn) {
            SQLTable parent = ((SQLColumn)this.getSubject()).getParentTable();
            return String.valueOf(parent.getName()) + "." + this.oldName;
        }
        return this.oldName;
    }

    public Object getNewValue() {
        return this.subject.getPhysicalName();
    }

    public void setNewValue(Object newValue) {
        logger.debug((Object)("Setting logical name of " + this.subject + " to " + newValue));
        this.subject.setName(newValue == null ? null : newValue.toString());
        this.subject.setPhysicalName(null);
    }
}

