/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.CountingSQLObjectListener;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.SQLTestCase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TestSQLRelationship
extends SQLTestCase {
    private SQLTable parentTable;
    private SQLTable childTable1;
    private SQLTable childTable2;
    private SQLRelationship rel1;
    private SQLRelationship rel2;
    private SQLDatabase database;

    public TestSQLRelationship(String name) throws Exception {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("-------------Starting New Test " + this.getName() + " -------------");
        this.database = new SQLDatabase();
        this.parentTable = new SQLTable(this.database, "parent", null, "TABLE", true);
        this.parentTable.addColumn(new SQLColumn(this.parentTable, "pkcol_1", 4, 10, 0));
        this.parentTable.addColumn(new SQLColumn(this.parentTable, "pkcol_2", 4, 10, 0));
        this.parentTable.addColumn(new SQLColumn(this.parentTable, "attribute_1", 4, 10, 0));
        this.database.addChild(this.parentTable);
        this.childTable1 = new SQLTable(this.database, "child_1", null, "TABLE", true);
        this.childTable1.addColumn(new SQLColumn(this.childTable1, "child_pkcol_1", 4, 10, 0));
        this.childTable1.addColumn(new SQLColumn(this.childTable1, "child_pkcol_2", 4, 10, 0));
        this.childTable1.addColumn(new SQLColumn(this.childTable1, "child_attribute", 4, 10, 0));
        this.database.addChild(this.childTable1);
        this.childTable2 = new SQLTable(this.database, "child_2", null, "TABLE", true);
        this.childTable2.addColumn(new SQLColumn(this.childTable2, "child2_pkcol_1", 4, 10, 0));
        this.childTable2.addColumn(new SQLColumn(this.childTable2, "child2_pkcol_2", 4, 10, 0));
        this.childTable2.addColumn(new SQLColumn(this.childTable2, "child2_attribute", 4, 10, 0));
        this.database.addChild(this.childTable2);
        this.rel1 = new SQLRelationship();
        this.rel1.setIdentifying(true);
        this.rel1.attachRelationship(this.parentTable, this.childTable1, false);
        this.rel1.setName("rel1");
        this.rel1.addMapping(this.parentTable.getColumn(0), this.childTable1.getColumn(0));
        this.rel1.addMapping(this.parentTable.getColumn(1), this.childTable1.getColumn(1));
        this.rel2 = new SQLRelationship();
        this.rel2.setName("rel2");
        this.rel2.attachRelationship(this.parentTable, this.childTable2, true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected SQLObject getSQLObjectUnderTest() {
        return this.rel1;
    }

    public void testSetPhysicalName() {
        CountingSQLObjectListener l = new CountingSQLObjectListener();
        this.rel1.addSQLObjectListener(l);
        TestSQLRelationship.assertEquals((int)0, (int)l.getInsertedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getRemovedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getChangedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getStructureChangedCount());
        this.rel1.setPhysicalName("test_new_name");
        TestSQLRelationship.assertEquals((int)0, (int)l.getInsertedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getRemovedCount());
        TestSQLRelationship.assertEquals((int)1, (int)l.getChangedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getStructureChangedCount());
        TestSQLRelationship.assertEquals((String)"new name didn't stick", (String)"test_new_name", (String)this.rel1.getPhysicalName());
        this.rel1.setPhysicalName("test_new_name");
        TestSQLRelationship.assertEquals((int)1, (int)l.getChangedCount());
        this.rel1.setPhysicalName("test_actual_new_name");
        TestSQLRelationship.assertEquals((int)2, (int)l.getChangedCount());
        this.rel1.setPhysicalName(null);
        TestSQLRelationship.assertEquals((int)3, (int)l.getChangedCount());
        TestSQLRelationship.assertEquals((String)"new name didn't go back to logical name", (String)this.rel1.getName(), (String)this.rel1.getPhysicalName());
        this.rel1.setPhysicalName(null);
        TestSQLRelationship.assertEquals((int)3, (int)l.getChangedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getInsertedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getRemovedCount());
        TestSQLRelationship.assertEquals((int)0, (int)l.getStructureChangedCount());
    }

    public void testReadFromDB() throws Exception {
        Connection con = null;
        Statement stmt = null;
        String lastSQL = null;
        try {
            try {
                con = this.db.getConnection();
                stmt = con.createStatement();
                try {
                    stmt.executeUpdate("DROP TABLE relationship_test_child");
                }
                catch (SQLException ex) {
                    System.out.println("Ignoring SQL Exception; assume relationship_test_child didn't exist.");
                    System.out.println(ex.getMessage());
                }
                try {
                    stmt.executeUpdate("DROP TABLE relationship_test_parent");
                }
                catch (SQLException ex) {
                    System.out.println("Ignoring SQL Exception; assume relationship_test_parent didn't exist.");
                    System.out.println(ex.getMessage());
                }
                lastSQL = "CREATE TABLE relationship_test_parent (\n pkcol_1 integer not null,\n pkcol_2 integer not null,\n attribute_1 integer not null)";
                stmt.executeUpdate(lastSQL);
                lastSQL = "CREATE TABLE relationship_test_child (\n parent_pkcol_1 integer not null,\n parent_pkcol_2 integer not null,\n child_attribute_1 integer not null)";
                stmt.executeUpdate(lastSQL);
                lastSQL = "ALTER TABLE relationship_test_parent\n ADD CONSTRAINT relationship_test_pk\n PRIMARY KEY (pkcol_1 , pkcol_2)";
                stmt.executeUpdate(lastSQL);
                lastSQL = "ALTER TABLE relationship_test_child\n ADD CONSTRAINT relationship_test_fk\n FOREIGN KEY (parent_pkcol_1, parent_pkcol_2)\n REFERENCES relationship_test_parent (pkcol_1 , pkcol_2)";
                stmt.executeUpdate(lastSQL);
            }
            catch (SQLException ex) {
                System.out.println("SQL Statement Failed:\n" + lastSQL + "\nStack trace of SQLException follows:");
                ex.printStackTrace();
                TestSQLRelationship.fail((String)"SQL statement failed. See system console for details.");
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                System.out.println("Couldn't close statement");
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                System.out.println("Couldn't close connection");
                e.printStackTrace();
            }
        }
        SQLTable parent = this.db.getTableByName("relationship_test_parent");
        SQLTable child = this.db.getTableByName("relationship_test_child");
        if (parent == null) {
            parent = this.db.getTableByName("relationship_test_parent".toUpperCase());
        }
        SQLRelationship rel = parent.getExportedKeys().get(0);
        TestSQLRelationship.assertEquals((String)"relationship_test_fk", (String)rel.getName().toLowerCase());
        TestSQLRelationship.assertSame((Object)parent, (Object)rel.getPkTable());
        TestSQLRelationship.assertSame((Object)child, (Object)rel.getFkTable());
        TestSQLRelationship.assertEquals((int)7, (int)rel.getFkCardinality());
        TestSQLRelationship.assertEquals((int)2, (int)rel.getPkCardinality());
    }

    public void testAllowsChildren() {
        TestSQLRelationship.assertTrue((boolean)this.rel1.allowsChildren());
    }

    public void testSQLRelationship() throws ArchitectException {
        SQLRelationship rel = new SQLRelationship();
        TestSQLRelationship.assertNotNull((Object)rel.getChildren());
        TestSQLRelationship.assertNotNull(rel.getSQLObjectListeners());
    }

    public void testGetMappingByPkCol() throws ArchitectException {
        SQLColumn col = this.parentTable.getColumnByName("pkcol_1");
        SQLRelationship.ColumnMapping m = this.rel1.getMappingByPkCol(col);
        TestSQLRelationship.assertEquals((String)"pkcol_1", (String)m.getPkColumn().getName());
        TestSQLRelationship.assertEquals((String)"child_pkcol_1", (String)m.getFkColumn().getName());
        col = this.parentTable.getColumnByName("pkcol_2");
        m = this.rel1.getMappingByPkCol(col);
        TestSQLRelationship.assertEquals((String)"pkcol_2", (String)m.getPkColumn().getName());
        TestSQLRelationship.assertEquals((String)"child_pkcol_2", (String)m.getFkColumn().getName());
    }

    public void testGetNonExistentMappingByPkCol() throws ArchitectException {
        SQLColumn col = this.parentTable.getColumnByName("attribute_1");
        SQLRelationship.ColumnMapping m = this.rel1.getMappingByPkCol(col);
        TestSQLRelationship.assertNull((Object)m);
    }

    public void testDeletePkColRemovesFkCol() throws ArchitectException {
        SQLColumn pkcol = this.parentTable.getColumnByName("pkcol_1");
        TestSQLRelationship.assertNotNull((String)"Child col should exist to start", (Object)this.childTable1.getColumnByName("child_pkcol_1"));
        this.parentTable.removeColumn(pkcol);
        TestSQLRelationship.assertNull((String)"Child col should have been removed", (Object)this.childTable1.getColumnByName("child_pkcol_1"));
    }

    public void testHijackedColumnGoesToPK() throws ArchitectException {
        SQLColumn pkcol = new SQLColumn(this.parentTable, "hijack", 4, 10, 0);
        SQLColumn fkcol = new SQLColumn(this.childTable1, "hijack", 4, 10, 0);
        SQLRelationship rel = this.parentTable.getExportedKeys().get(0);
        this.childTable1.addColumn(0, fkcol);
        this.parentTable.addColumn(0, pkcol);
        pkcol.setPrimaryKeySeq(0);
        TestSQLRelationship.assertNotNull((String)"parent column didn't to go PK", (Object)pkcol.getPrimaryKeySeq());
        TestSQLRelationship.assertTrue((String)"column didn't get hijacked", (boolean)rel.containsFkColumn(fkcol));
        TestSQLRelationship.assertNotNull((String)"column didn't go to primary key", (Object)fkcol.getPrimaryKeySeq());
    }

    public void testHijackedColumnGoesToPK2() throws ArchitectException {
        SQLColumn pkcol = new SQLColumn(this.parentTable, "hijack", 4, 10, 0);
        SQLColumn fkcol = new SQLColumn(this.childTable1, "hijack", 4, 10, 0);
        SQLRelationship rel = this.parentTable.getExportedKeys().get(0);
        this.childTable1.addColumn(fkcol);
        this.parentTable.addColumn(pkcol);
        TestSQLRelationship.assertNull((String)"pkcol already in the primary key", (Object)pkcol.getPrimaryKeySeq());
        pkcol.setPrimaryKeySeq(0);
        TestSQLRelationship.assertNotNull((String)"parent column didn't to go PK", (Object)pkcol.getPrimaryKeySeq());
        TestSQLRelationship.assertTrue((String)"column didn't get hijacked", (boolean)rel.containsFkColumn(fkcol));
        TestSQLRelationship.assertNotNull((String)"column didn't go to primary key", (Object)fkcol.getPrimaryKeySeq());
    }

    public void testFKColManagerRemovesImportedKey() throws ArchitectException {
        TestSQLRelationship.assertTrue((String)"Parent table should export rel1", (boolean)this.parentTable.getExportedKeys().contains(this.rel1));
        TestSQLRelationship.assertTrue((String)"childTable1 should import rel1", (boolean)this.childTable1.getImportedKeys().contains(this.rel1));
        TestSQLRelationship.assertEquals((String)"Child's imported count is whacked out", (int)1, (int)this.childTable1.getImportedKeys().size());
        TestSQLRelationship.assertNotNull((String)"Missing imported key", (Object)this.childTable1.getColumnByName("child_pkcol_1"));
        TestSQLRelationship.assertNotNull((String)"Missing imported key", (Object)this.childTable1.getColumnByName("child_pkcol_2"));
        int oldChildColCount = this.childTable1.getColumns().size();
        this.parentTable.removeExportedKey(this.rel1);
        TestSQLRelationship.assertFalse((String)"Parent table should not export rel1 any more", (boolean)this.parentTable.getExportedKeys().contains(this.rel1));
        TestSQLRelationship.assertFalse((String)"childTable1 should not import rel1 any more", (boolean)this.childTable1.getImportedKeys().contains(this.rel1));
        TestSQLRelationship.assertEquals((String)"Relationship still attached to child", (int)0, (int)this.childTable1.getImportedKeys().size());
        TestSQLRelationship.assertNull((String)"Orphaned imported key", (Object)this.childTable1.getColumnByName("child_pkcol_1"));
        TestSQLRelationship.assertNull((String)"Orphaned imported key", (Object)this.childTable1.getColumnByName("child_pkcol_2"));
        TestSQLRelationship.assertEquals((String)"Child column list should have shrunk by 2", (int)(oldChildColCount - 2), (int)this.childTable1.getColumns().size());
        TestSQLRelationship.assertNotNull((String)"Missing exported key", (Object)this.parentTable.getColumnByName("pkcol_1"));
        TestSQLRelationship.assertNotNull((String)"Missing exported key", (Object)this.parentTable.getColumnByName("pkcol_2"));
    }

    public void testRemovedRelationshipsDontInterfere() throws ArchitectException {
        this.testFKColManagerRemovesImportedKey();
        int oldChildColCount = this.childTable1.getColumns().size();
        SQLColumn pk3 = new SQLColumn(this.parentTable, "pk3", 12, 10, 0);
        this.parentTable.addColumn(pk3);
        pk3.setPrimaryKeySeq(0);
        TestSQLRelationship.assertEquals((String)"Child table got new col!?!", (int)oldChildColCount, (int)this.childTable1.getColumns().size());
    }

    public void testRemoveChildTable() throws ArchitectException {
        TestSQLRelationship.assertEquals((int)3, (int)this.database.getChildCount());
        TestSQLRelationship.assertEquals((int)2, (int)this.parentTable.getExportedKeys().size());
        this.database.removeChild(this.childTable1);
        TestSQLRelationship.assertEquals((int)2, (int)this.database.getChildCount());
        TestSQLRelationship.assertEquals((int)1, (int)this.parentTable.getExportedKeys().size());
        TestSQLRelationship.assertNull((String)"Child table not removed from the database", (Object)this.database.getTableByName(this.childTable1.getName()));
        TestSQLRelationship.assertFalse((String)"Parent still contains a reference to a deleted table", (boolean)this.parentTable.getExportedKeys().contains(this.rel1));
        this.database.removeChild(this.childTable2);
        TestSQLRelationship.assertNull((String)"Child table 2 not removed from the database", (Object)this.database.getTableByName(this.childTable2.getName()));
        TestSQLRelationship.assertFalse((String)"Parent still contains a reference to a deleted table", (boolean)this.parentTable.getExportedKeys().contains(this.rel2));
        TestSQLRelationship.assertEquals((int)1, (int)this.database.getChildCount());
        TestSQLRelationship.assertEquals((int)0, (int)this.parentTable.getExportedKeys().size());
    }

    public void testRemoveParentTable() throws ArchitectException {
        this.database.removeChild(this.parentTable);
        TestSQLRelationship.assertNull((String)"Child table not removed from the database", (Object)this.database.getTableByName(this.parentTable.getName()));
        TestSQLRelationship.assertFalse((String)"Parent still contains a reference to a deleted table", (boolean)this.parentTable.getExportedKeys().contains(this.rel1));
    }

    public void testPKColNameChangeGoesToFKColWhenNamesWereSame() throws ArchitectException {
        SQLColumn pkcol = new SQLColumn(this.parentTable, "old name", 12, 10, 0);
        this.parentTable.addColumn(pkcol);
        pkcol.setPrimaryKeySeq(0);
        SQLColumn fkcol = this.childTable1.getColumnByName("old name");
        pkcol.setName("new name");
        TestSQLRelationship.assertEquals((String)"fkcol's name didn't update", (String)"new name", (String)fkcol.getName());
    }

    public void testPKColNameChangeDoesntGoToFKColWhenNamesWereDifferent() throws ArchitectException {
        SQLColumn pkcol = new SQLColumn(this.parentTable, "old name", 12, 10, 0);
        this.parentTable.addColumn(pkcol);
        pkcol.setPrimaryKeySeq(0);
        SQLColumn fkcol = this.childTable1.getColumnByName("old name");
        fkcol.setName("custom fk col name");
        pkcol.setName("new name");
        TestSQLRelationship.assertEquals((String)"fkcol's name didn't update", (String)"custom fk col name", (String)fkcol.getName());
    }

    public void testPKColTypeChangeGoesToFKCol() throws ArchitectException {
        SQLColumn pkcol = new SQLColumn(this.parentTable, "old name", 12, 10, 0);
        this.parentTable.addColumn(pkcol);
        pkcol.setPrimaryKeySeq(0);
        SQLColumn fkcol = this.childTable1.getColumnByName("old name");
        pkcol.setType(-2);
        TestSQLRelationship.assertEquals((String)"fkcol's type didn't update", (int)-2, (int)fkcol.getType());
    }

    public void testCreateIdentifyingRelationship() throws ArchitectException {
        SQLTable parent = new SQLTable(null, "Parent", null, "TABLE", true);
        SQLTable child = new SQLTable(null, "Child", null, "TABLE", true);
        SQLColumn parentCol1 = new SQLColumn(null, "pk1", 4, 10, 0);
        SQLColumn childCol1 = new SQLColumn(null, "child_attr", 4, 10, 0);
        parent.addColumn(parentCol1);
        parentCol1.setPrimaryKeySeq(0);
        child.addColumn(childCol1);
        childCol1.setPrimaryKeySeq(null);
        SQLRelationship rel = new SQLRelationship();
        rel.setIdentifying(true);
        rel.attachRelationship(parent, child, true);
        TestSQLRelationship.assertEquals((String)"pk1", (String)parent.getColumn(0).getName());
        TestSQLRelationship.assertEquals((Object)new Integer(0), (Object)parent.getColumn(0).getPrimaryKeySeq());
        TestSQLRelationship.assertEquals((String)"pk1", (String)child.getColumn(0).getName());
        TestSQLRelationship.assertEquals((Object)new Integer(0), (Object)child.getColumn(0).getPrimaryKeySeq());
        TestSQLRelationship.assertEquals((String)"child_attr", (String)child.getColumn(1).getName());
        TestSQLRelationship.assertEquals(null, (Object)child.getColumn(1).getPrimaryKeySeq());
    }

    public void testCreateNonIdentifyingRelationship() throws ArchitectException {
        SQLTable parent = new SQLTable(null, "Parent", null, "TABLE", true);
        SQLTable child = new SQLTable(null, "Child", null, "TABLE", true);
        SQLColumn parentCol1 = new SQLColumn(null, "pk1", 4, 10, 0);
        SQLColumn childCol1 = new SQLColumn(null, "child_attr", 4, 10, 0);
        parent.addColumn(parentCol1);
        parentCol1.setPrimaryKeySeq(0);
        child.addColumn(childCol1);
        childCol1.setPrimaryKeySeq(null);
        SQLRelationship rel = new SQLRelationship();
        rel.setIdentifying(false);
        rel.attachRelationship(parent, child, true);
        TestSQLRelationship.assertEquals((String)"pk1", (String)parent.getColumn(0).getName());
        TestSQLRelationship.assertEquals((Object)new Integer(0), (Object)parent.getColumn(0).getPrimaryKeySeq());
        TestSQLRelationship.assertEquals((String)"child_attr", (String)child.getColumn(0).getName());
        TestSQLRelationship.assertEquals(null, (Object)child.getColumn(0).getPrimaryKeySeq());
        TestSQLRelationship.assertEquals((String)"pk1", (String)child.getColumn(1).getName());
        TestSQLRelationship.assertEquals(null, (Object)child.getColumn(1).getPrimaryKeySeq());
    }

    public void testPKColPrecisionChangeGoesToFKCol() throws ArchitectException {
        SQLColumn pkcol = new SQLColumn(this.parentTable, "old name", 12, 10, 0);
        this.parentTable.addColumn(pkcol);
        pkcol.setPrimaryKeySeq(0);
        SQLColumn fkcol = this.childTable1.getColumnByName("old name");
        pkcol.setPrecision(20);
        TestSQLRelationship.assertEquals((String)"fkcol's precision didn't update", (int)20, (int)fkcol.getPrecision());
    }

    public void testReconnectOldRelationshipWithCustomMapping() throws ArchitectException {
        ArrayList<SQLColumn> origParentCols = new ArrayList<SQLColumn>(this.parentTable.getColumns());
        ArrayList<SQLColumn> origChild1Cols = new ArrayList<SQLColumn>(this.childTable1.getColumns());
        this.parentTable.removeExportedKey(this.rel1);
        this.rel1.attachRelationship(this.parentTable, this.childTable1, false);
        TestSQLRelationship.assertEquals((String)"Exported key columns disappeared", origParentCols, this.parentTable.getColumns());
        TestSQLRelationship.assertEquals((String)"Imported key columns didn't get put back", origChild1Cols, this.childTable1.getColumns());
        TestSQLRelationship.assertEquals((String)"There are multiple copies of this relationship in the parent's exported keys folder", (int)2, (int)this.parentTable.getExportedKeys().size());
        TestSQLRelationship.assertEquals((String)"There are multiple copies of this relationship in the child's imported keys folder", (int)1, (int)this.childTable1.getImportedKeys().size());
    }

    public void testReconnectOldRelationshipWithAutoMapping() throws ArchitectException {
        SQLTable myParent = new SQLTable(this.db, true);
        SQLColumn col = new SQLColumn(myParent, "pkcol1", 12, 10, 0);
        myParent.addColumn(col);
        col.setPrimaryKeySeq(0);
        col = new SQLColumn(myParent, "pkcol2", 12, 10, 0);
        myParent.addColumn(col);
        col.setPrimaryKeySeq(0);
        SQLTable myChild = new SQLTable(this.db, true);
        SQLRelationship myRel = new SQLRelationship();
        myRel.attachRelationship(myParent, myChild, true);
        ArrayList<SQLColumn> origParentCols = new ArrayList<SQLColumn>(myParent.getColumns());
        ArrayList<SQLColumn> origChildCols = new ArrayList<SQLColumn>(myChild.getColumns());
        myParent.removeExportedKey(myRel);
        myRel.attachRelationship(myParent, myChild, false);
        TestSQLRelationship.assertEquals((String)"Exported key columns disappeared", origParentCols, myParent.getColumns());
        TestSQLRelationship.assertEquals((String)"Imported key columns didn't get put back", origChildCols, myChild.getColumns());
        TestSQLRelationship.assertEquals((String)"There are multiple copies of this relationship in the parent's export keys folder", (int)1, (int)myParent.getExportedKeys().size());
        TestSQLRelationship.assertEquals((String)"There are multiple copies of this relationship in the child's import keys folder", (int)1, (int)myChild.getImportedKeys().size());
    }

    public void testMovingPKColOutOfPK() throws ArchitectException {
        SQLColumn col = this.parentTable.getColumnByName("pkcol_1");
        col.setPrimaryKeySeq(null);
        TestSQLRelationship.assertTrue((String)"pkcol_1 dropped from the parent table", (boolean)this.parentTable.getColumns().contains(col));
    }

    public void testMovingPKColOutOfPKByColIndex() throws ArchitectException {
        SQLColumn col = this.parentTable.getColumnByName("pkcol_2");
        int index = this.parentTable.getColumnIndex(col);
        this.parentTable.changeColumnIndex(index, 1, false);
        TestSQLRelationship.assertTrue((String)"pkcol_1 dropped from the parent table", (boolean)this.parentTable.getColumns().contains(col));
    }

    public void testRelManagerDoesntDetachEarly() {
        TestSQLRelationship.assertTrue((boolean)this.parentTable.getSQLObjectListeners().contains(this.rel1.getRelationshipManager()));
        TestSQLRelationship.assertTrue((boolean)this.parentTable.getSQLObjectListeners().contains(this.rel2.getRelationshipManager()));
        TestSQLRelationship.assertTrue((boolean)this.childTable2.getSQLObjectListeners().contains(this.rel2.getRelationshipManager()));
        this.parentTable.getExportedKeysFolder().removeChild(this.rel1);
        TestSQLRelationship.assertFalse((boolean)this.parentTable.getSQLObjectListeners().contains(this.rel1.getRelationshipManager()));
        TestSQLRelationship.assertTrue((boolean)this.parentTable.getSQLObjectListeners().contains(this.rel2.getRelationshipManager()));
        TestSQLRelationship.assertTrue((boolean)this.childTable2.getSQLObjectListeners().contains(this.rel2.getRelationshipManager()));
    }

    public void testAutoGeneratedColumnGoesIntoPK() throws ArchitectException {
        SQLColumn mycol = new SQLColumn(null, "my_column", 1, 1000000, 0);
        this.parentTable.addColumn(0, mycol);
        mycol.setPrimaryKeySeq(0);
        TestSQLRelationship.assertTrue((boolean)mycol.isPrimaryKey());
        TestSQLRelationship.assertTrue((boolean)this.rel1.isIdentifying());
        SQLColumn generatedCol = this.childTable1.getColumnByName("my_column");
        System.out.println("Columns of childTable1: " + this.childTable1.getColumns());
        System.out.println("Column 0 pk value:" + this.childTable1.getColumn(0).getPrimaryKeySeq());
        TestSQLRelationship.assertTrue((this.childTable1.getColumnIndex(generatedCol) < this.childTable1.getPkSize() ? 1 : 0) != 0);
        TestSQLRelationship.assertTrue((boolean)generatedCol.isPrimaryKey());
    }

    public void testCreateMappingsFiresEvents() throws ArchitectException {
        CountingSQLObjectListener l = new CountingSQLObjectListener();
        this.rel1.addSQLObjectListener(l);
        SQLRelationship.ColumnMapping columnMapping = new SQLRelationship.ColumnMapping();
        columnMapping.setPkColumn(this.parentTable.getColumn(0));
        columnMapping.setFkColumn(this.childTable1.getColumn(0));
        this.rel1.addChild(0, columnMapping);
        TestSQLRelationship.assertEquals((int)1, (int)l.getInsertedCount());
    }

    public void testRemoveMappingsFiresEvents() {
        CountingSQLObjectListener l = new CountingSQLObjectListener();
        this.rel1.addSQLObjectListener(l);
        this.rel1.removeChild(0);
        TestSQLRelationship.assertEquals((int)1, (int)l.getRemovedCount());
    }

    public void testRelationshipManagerRemoveMappingsFiresEvents() throws ArchitectException {
        CountingSQLObjectListener l = new CountingSQLObjectListener();
        this.rel1.addSQLObjectListener(l);
        this.parentTable.removeColumn(0);
        TestSQLRelationship.assertEquals((int)1, (int)l.getRemovedCount());
    }
}

