/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.CountingPropertyChangeListener;
import java.util.Map;
import junit.framework.TestCase;

public class TestArchitectDataSource
extends TestCase {
    ArchitectDataSource ds;

    protected void setUp() throws Exception {
        super.setUp();
        this.ds = new ArchitectDataSource();
        this.ds.setDisplayName("Regression Test");
        this.ds.setDriverClass("com.does.not.exist");
        this.ds.setName("test_name");
        this.ds.setOdbcDsn("fake_odbc_dsn");
        this.ds.setPass("fake_password");
        this.ds.setPlDbType("fake_pl_type");
        this.ds.setPlSchema("my_fake_pl_schema");
        this.ds.setUrl("jdbc:fake:fake:fake");
        this.ds.setUser("fake_user");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHashCode() {
        String oldPass = this.ds.getPass();
        int oldCode = this.ds.hashCode();
        this.ds.setPass("cows");
        TestArchitectDataSource.assertFalse((oldCode == this.ds.hashCode() ? 1 : 0) != 0);
        this.ds.setPass(oldPass);
        TestArchitectDataSource.assertEquals((int)oldCode, (int)this.ds.hashCode());
    }

    public void testArchitectDataSource() {
        TestArchitectDataSource.assertNotNull(this.ds.getPropertiesMap());
        TestArchitectDataSource.assertNotNull((Object)this.ds.getPropertyChangeListeners());
    }

    public void testPut() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.put("test_key", "peek-a-boo!");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"test_key", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"peek-a-boo!", (String)this.ds.get("test_key"));
    }

    public void testGetPropertiesMap() {
        Map<String, String> m = this.ds.getPropertiesMap();
        TestArchitectDataSource.assertNotNull(m);
        try {
            m.put("won't work", "fooooooey");
            TestArchitectDataSource.fail((String)"client view of property map must be immutable");
        }
        catch (UnsupportedOperationException ex) {
            TestArchitectDataSource.assertTrue((boolean)true);
        }
    }

    public void testEquals() {
        ArchitectDataSource ds1 = new ArchitectDataSource();
        ArchitectDataSource ds2 = new ArchitectDataSource();
        ds1.setDisplayName("Regression Test");
        ds2.setDisplayName("Regression Test");
        ds1.setDriverClass("com.does.not.exist");
        ds2.setDriverClass("com.does.not.exist");
        ds1.setName("test_name");
        ds2.setName("test_name");
        ds1.setOdbcDsn("fake_odbc_dsn");
        ds2.setOdbcDsn("fake_odbc_dsn");
        ds1.setPass("fake_password");
        ds2.setPass("fake_password");
        ds1.setPlDbType("fake_pl_type");
        ds2.setPlDbType("fake_pl_type");
        ds1.setPlSchema("my_fake_pl_schema");
        ds2.setPlSchema("my_fake_pl_schema");
        ds1.setUrl("jdbc:fake:fake:fake");
        ds2.setUrl("jdbc:fake:fake:fake");
        ds1.setUser("fake_user");
        ds2.setUser("fake_user");
        TestArchitectDataSource.assertEquals((Object)ds1, (Object)ds2);
        ds2.setDisplayName("x");
        TestArchitectDataSource.assertFalse((boolean)ds1.equals(ds2));
        ds2.setDisplayName(ds1.getDisplayName());
        TestArchitectDataSource.assertEquals((Object)ds1, (Object)ds2);
        ds1.put("cow", "moo");
        TestArchitectDataSource.assertFalse((boolean)ds1.equals(ds2));
    }

    public void testEqualsNull() {
        TestArchitectDataSource.assertFalse((String)"This is really to check null comparison is allowed", (boolean)this.ds.equals(null));
    }

    public void testAddPropertyChangeListener() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        TestArchitectDataSource.assertTrue((boolean)this.ds.getPropertyChangeListeners().contains(l));
    }

    public void testRemovePropertyChangeListener() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        TestArchitectDataSource.assertTrue((boolean)this.ds.getPropertyChangeListeners().contains(l));
        this.ds.removePropertyChangeListener(l);
        TestArchitectDataSource.assertFalse((boolean)this.ds.getPropertyChangeListeners().contains(l));
    }

    public void testSetName() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setName("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"name", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getName());
    }

    public void testSetDisplayName() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setDisplayName("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"name", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getDisplayName());
    }

    public void testSetUrl() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setUrl("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"url", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getUrl());
    }

    public void testSetDriverClass() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setDriverClass("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"driverClass", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getDriverClass());
    }

    public void testSetUser() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setUser("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"user", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getUser());
    }

    public void testSetPass() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setPass("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"pass", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getPass());
    }

    public void testSetPlSchema() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setPlSchema("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"plSchema", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getPlSchema());
    }

    public void testSetPlDbType() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setPlDbType("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"plDbType", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getPlDbType());
    }

    public void testSetOdbcDsn() {
        CountingPropertyChangeListener l = new CountingPropertyChangeListener();
        this.ds.addPropertyChangeListener(l);
        this.ds.setOdbcDsn("test");
        TestArchitectDataSource.assertEquals((int)1, (int)l.getPropertyChangeCount());
        TestArchitectDataSource.assertEquals((String)"odbcDsn", (String)l.getLastPropertyChange());
        TestArchitectDataSource.assertEquals((String)"test", (String)this.ds.getOdbcDsn());
    }

    public void testComparator() {
        ArchitectDataSource ds2 = new ArchitectDataSource();
        for (String key : this.ds.getPropertiesMap().keySet()) {
            ds2.put(key, this.ds.get(key));
        }
        ArchitectDataSource.DefaultComparator cmp = new ArchitectDataSource.DefaultComparator();
        TestArchitectDataSource.assertEquals((int)0, (int)cmp.compare(this.ds, ds2));
        ds2.setDisplayName("a");
        ds2.setUser("z");
        TestArchitectDataSource.assertTrue((cmp.compare(this.ds, ds2) > 0 ? 1 : 0) != 0);
        ds2.setDisplayName("z");
        ds2.setUser("a");
        TestArchitectDataSource.assertTrue((cmp.compare(this.ds, ds2) < 0 ? 1 : 0) != 0);
        ds2.setDisplayName(this.ds.getDisplayName());
        ds2.setUser("a");
        TestArchitectDataSource.assertTrue((cmp.compare(this.ds, ds2) > 0 ? 1 : 0) != 0);
        ds2.setUser("z");
        TestArchitectDataSource.assertTrue((cmp.compare(this.ds, ds2) < 0 ? 1 : 0) != 0);
    }
}

