/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.ArchitectTestCase;
import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.CountingSQLObjectListener;
import ca.sqlpower.architect.MockJDBCDriver;
import ca.sqlpower.architect.PlDotIni;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.undo.UndoManager;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class SQLTestCase
extends ArchitectTestCase {
    SQLDatabase db;
    Set<String> propertiesToIgnoreForUndo = new HashSet<String>();
    Set<String> propertiesToIgnoreForEventGeneration = new HashSet<String>();

    public SQLTestCase(String name) throws Exception {
        super(name);
    }

    static ArchitectDataSource getDataSource() throws IOException {
        ArchitectFrame.getMainInstance();
        PlDotIni plini = new PlDotIni();
        plini.read(new File("pl.regression.ini"));
        return plini.getDataSource("regression_test");
    }

    protected void setUp() throws Exception {
        this.db = new SQLDatabase(SQLTestCase.getDataSource());
    }

    protected void tearDown() throws Exception {
        this.db.disconnect();
        this.db = null;
    }

    protected abstract SQLObject getSQLObjectUnderTest() throws ArchitectException;

    public void testAllSettersGenerateEvents() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ArchitectException {
        SQLObject so = this.getSQLObjectUnderTest();
        so.populate();
        this.propertiesToIgnoreForEventGeneration.add("referenceCount");
        this.propertiesToIgnoreForEventGeneration.add("populated");
        this.propertiesToIgnoreForEventGeneration.add("SQLObjectListeners");
        this.propertiesToIgnoreForEventGeneration.add("children");
        this.propertiesToIgnoreForEventGeneration.add("parent");
        this.propertiesToIgnoreForEventGeneration.add("parentDatabase");
        this.propertiesToIgnoreForEventGeneration.add("class");
        this.propertiesToIgnoreForEventGeneration.add("childCount");
        this.propertiesToIgnoreForEventGeneration.add("undoEventListeners");
        this.propertiesToIgnoreForEventGeneration.add("connection");
        this.propertiesToIgnoreForEventGeneration.add("typeMap");
        this.propertiesToIgnoreForEventGeneration.add("secondaryChangeMode");
        this.propertiesToIgnoreForEventGeneration.add("zoomInAction");
        this.propertiesToIgnoreForEventGeneration.add("zoomOutAction");
        this.propertiesToIgnoreForEventGeneration.add("magicEnabled");
        if (so instanceof SQLDatabase) {
            this.propertiesToIgnoreForEventGeneration.add("name");
        }
        CountingSQLObjectListener listener = new CountingSQLObjectListener();
        so.addSQLObjectListener(listener);
        List<PropertyDescriptor> settableProperties = Arrays.asList(PropertyUtils.getPropertyDescriptors(so.getClass()));
        for (PropertyDescriptor property : settableProperties) {
            Object newVal;
            Object oldVal;
            block23: {
                if (this.propertiesToIgnoreForEventGeneration.contains(property.getName())) continue;
                try {
                    oldVal = PropertyUtils.getSimpleProperty((Object)so, (String)property.getName());
                    if (property.getWriteMethod() == null) {
                    }
                    break block23;
                }
                catch (NoSuchMethodException e) {
                    System.out.println("Skipping non-settable property " + property.getName() + " on " + so.getClass().getName());
                }
                continue;
            }
            if (property.getPropertyType() == Integer.TYPE || property.getPropertyType() == Integer.class) {
                newVal = (Integer)oldVal + 1;
            } else if (property.getPropertyType() == String.class) {
                newVal = "new " + oldVal;
            } else if (property.getPropertyType() == Boolean.TYPE) {
                newVal = new Boolean((Boolean)oldVal == false);
            } else if (property.getPropertyType() == SQLCatalog.class) {
                newVal = new SQLCatalog(new SQLDatabase(), "This is a new catalog");
            } else if (property.getPropertyType() == ArchitectDataSource.class) {
                newVal = new ArchitectDataSource();
                ((ArchitectDataSource)newVal).setName("test");
                ((ArchitectDataSource)newVal).setDisplayName("test");
                ((ArchitectDataSource)newVal).setUser("a");
                ((ArchitectDataSource)newVal).setPass("b");
                ((ArchitectDataSource)newVal).setDriverClass(MockJDBCDriver.class.getName());
                ((ArchitectDataSource)newVal).setUrl("jdbc:mock:x=y");
            } else if (property.getPropertyType() == SQLTable.class) {
                newVal = new SQLTable();
            } else if (property.getPropertyType() == SQLColumn.class) {
                newVal = new SQLColumn();
            } else if (property.getPropertyType() == SQLIndex.IndexType.class) {
                newVal = SQLIndex.IndexType.STATISTIC;
            } else {
                throw new RuntimeException("This test case lacks a value for " + property.getName() + " (type " + property.getPropertyType().getName() + ") from " + so.getClass());
            }
            int oldChangeCount = listener.getChangedCount();
            try {
                BeanUtils.copyProperty((Object)so, (String)property.getName(), (Object)newVal);
                SQLTestCase.assertTrue((String)("Event for set " + property.getName() + " on " + so.getClass().getName() + " didn't fire!"), (listener.getChangedCount() > oldChangeCount ? 1 : 0) != 0);
                if (listener.getChangedCount() != oldChangeCount + 1) continue;
                SQLTestCase.assertEquals((String)("Property name mismatch for " + property.getName() + " in " + so.getClass()), (String)property.getName(), (String)listener.getLastEvent().getPropertyName());
                SQLTestCase.assertEquals((String)("New value for " + property.getName() + " was wrong"), (Object)newVal, (Object)listener.getLastEvent().getNewValue());
            }
            catch (InvocationTargetException e) {
                System.out.println("(non-fatal) Failed to write property '" + property.getName() + " to type " + so.getClass().getName());
            }
        }
    }

    public void testAllSettersAreUndoable() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ArchitectException {
        SQLObject so = this.getSQLObjectUnderTest();
        this.propertiesToIgnoreForUndo.add("referenceCount");
        this.propertiesToIgnoreForUndo.add("populated");
        this.propertiesToIgnoreForUndo.add("SQLObjectListeners");
        this.propertiesToIgnoreForUndo.add("children");
        this.propertiesToIgnoreForUndo.add("parent");
        this.propertiesToIgnoreForUndo.add("parentDatabase");
        this.propertiesToIgnoreForUndo.add("class");
        this.propertiesToIgnoreForUndo.add("childCount");
        this.propertiesToIgnoreForUndo.add("undoEventListeners");
        this.propertiesToIgnoreForUndo.add("connection");
        this.propertiesToIgnoreForUndo.add("typeMap");
        this.propertiesToIgnoreForUndo.add("secondaryChangeMode");
        this.propertiesToIgnoreForUndo.add("zoomInAction");
        this.propertiesToIgnoreForUndo.add("zoomOutAction");
        this.propertiesToIgnoreForUndo.add("magicEnabled");
        this.propertiesToIgnoreForUndo.add("deleteRule");
        this.propertiesToIgnoreForUndo.add("updateRule");
        if (so instanceof SQLDatabase) {
            this.propertiesToIgnoreForUndo.add("name");
        }
        UndoManager undoManager = new UndoManager(so);
        List<PropertyDescriptor> settableProperties = Arrays.asList(PropertyUtils.getPropertyDescriptors(so.getClass()));
        if (so instanceof SQLDatabase) {
            settableProperties.remove("name");
        }
        for (PropertyDescriptor property : settableProperties) {
            Object newVal;
            Object oldVal;
            block24: {
                if (this.propertiesToIgnoreForUndo.contains(property.getName())) continue;
                try {
                    oldVal = PropertyUtils.getSimpleProperty((Object)so, (String)property.getName());
                    if (property.getWriteMethod() == null) {
                    }
                    break block24;
                }
                catch (NoSuchMethodException e) {
                    System.out.println("Skipping non-settable property " + property.getName() + " on " + so.getClass().getName());
                }
                continue;
            }
            if (property.getPropertyType() == Integer.TYPE || property.getPropertyType() == Integer.class) {
                newVal = (Integer)oldVal + 1;
            } else if (property.getPropertyType() == String.class) {
                newVal = "new " + oldVal;
            } else if (property.getPropertyType() == Boolean.TYPE) {
                newVal = new Boolean((Boolean)oldVal == false);
            } else if (property.getPropertyType() == SQLCatalog.class) {
                newVal = new SQLCatalog(new SQLDatabase(), "This is a new catalog");
            } else if (property.getPropertyType() == ArchitectDataSource.class) {
                newVal = new ArchitectDataSource();
                ((ArchitectDataSource)newVal).setName("test");
                ((ArchitectDataSource)newVal).setDisplayName("test");
                ((ArchitectDataSource)newVal).setUser("a");
                ((ArchitectDataSource)newVal).setPass("b");
                ((ArchitectDataSource)newVal).setDriverClass(MockJDBCDriver.class.getName());
                ((ArchitectDataSource)newVal).setUrl("jdbc:mock:x=y");
            } else if (property.getPropertyType() == SQLTable.class) {
                newVal = new SQLTable();
            } else if (property.getPropertyType() == SQLColumn.class) {
                newVal = new SQLColumn();
            } else if (property.getPropertyType() == SQLIndex.IndexType.class) {
                newVal = SQLIndex.IndexType.STATISTIC;
            } else {
                throw new RuntimeException("This test case lacks a value for " + property.getName() + " (type " + property.getPropertyType().getName() + ") from " + so.getClass());
            }
            int oldChangeCount = undoManager.getUndoableEditCount();
            try {
                BeanUtils.copyProperty((Object)so, (String)property.getName(), (Object)newVal);
                SQLTestCase.assertEquals((String)("Event for set " + property.getName() + " on " + so.getClass().getName() + " added multiple (" + undoManager.printUndoVector() + ") undos!"), (int)(oldChangeCount + 1), (int)undoManager.getUndoableEditCount());
            }
            catch (InvocationTargetException e) {
                System.out.println("(non-fatal) Failed to write property '" + property.getName() + " to type " + so.getClass().getName());
            }
        }
    }

    public void testChildrenNotNull() throws ArchitectException {
        SQLTestCase.assertNotNull((Object)this.getSQLObjectUnderTest().getChildren());
    }
}

