/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import java.sql.SQLException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLSchema
extends SQLObject {
    private static final Logger logger = Logger.getLogger(SQLSchema.class);
    protected SQLObject parent;
    protected String nativeTerm;

    public SQLSchema(boolean populated) {
        this(null, null, populated);
    }

    public SQLSchema(SQLObject parent, String name, boolean populated) {
        if (parent != null && !(parent instanceof SQLCatalog) && !(parent instanceof SQLDatabase)) {
            throw new IllegalArgumentException("Parent to SQLSchema must be SQLCatalog or SQLDatabase");
        }
        this.parent = parent;
        this.setName(name);
        this.children = new LinkedList();
        this.nativeTerm = "schema";
        this.populated = populated;
    }

    public SQLTable getTableByName(String tableName) throws ArchitectException {
        this.populate();
        for (SQLTable child : this.children) {
            logger.debug((Object)("getTableByName: is child '" + child.getName() + "' equal to '" + tableName + "'?"));
            if (!child.getName().equalsIgnoreCase(tableName)) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return this.getShortDisplayName();
    }

    public boolean isParentTypeDatabase() {
        return this.parent instanceof SQLDatabase;
    }

    @Override
    public SQLObject getParent() {
        return this.parent;
    }

    @Override
    protected void setParent(SQLObject newParent) {
        this.parent = newParent;
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void populate() throws ArchitectException {
        block26: {
            if (this.populated) {
                return;
            }
            SQLSchema.logger.debug((Object)"SQLSchema: populate starting");
            oldSize = this.children.size();
            tmp = this.parent;
            while (tmp != null && !(tmp instanceof SQLDatabase)) {
                tmp = tmp.getParent();
            }
            if (tmp == null) {
                throw new IllegalStateException("Schema does not have a SQLDatabase ancestor. Can't populate.");
            }
            parentDatabase = (SQLDatabase)tmp;
            con = null;
            rs = null;
            try {
                try {
                    var6_6 = parentDatabase;
                    synchronized (var6_6) {
                        con = parentDatabase.getConnection();
                        dbmd = con.getMetaData();
                        if (this.parent instanceof SQLDatabase) {
                            rs = dbmd.getTables(null, this.getName(), "%", new String[]{"TABLE", "VIEW"});
                        } else if (this.parent instanceof SQLCatalog) {
                            rs = dbmd.getTables(this.parent.getName(), this.getName(), "%", new String[]{"TABLE", "VIEW"});
                        }
                        while (rs != null && rs.next()) {
                            this.children.add(new SQLTable(this, rs.getString(3), rs.getString(5), rs.getString(4), false));
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 7] lbl30 : MonitorExitStatement: MONITOREXIT : var6_6
                    }
                }
                catch (SQLException e) {
                    throw new ArchitectException("schema.populate.fail", e);
                }
            }
            finally {
                this.populated = true;
                newSize = this.children.size();
                if (newSize <= oldSize) break block26;
                e2 = new int[newSize - oldSize];
                i = 0;
                n = newSize - oldSize;
                ** while (i < n)
            }
lbl-1000:
            // 1 sources

            {
                changedIndices[i] = oldSize + i;
                ++i;
                continue;
            }
lbl47:
            // 1 sources

            this.fireDbChildrenInserted((int[])changedIndices, this.children.subList(oldSize, newSize));
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            SQLSchema.logger.error((Object)"Could not close result set", (Throwable)e2);
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e2) {
            SQLSchema.logger.error((Object)"Could not close connection", (Throwable)e2);
        }
        SQLSchema.logger.debug((Object)"SQLSchema: populate finished");
    }

    public String getNativeTerm() {
        return this.nativeTerm;
    }

    public void setNativeTerm(String argNativeTerm) {
        if (argNativeTerm != null) {
            argNativeTerm = argNativeTerm.toLowerCase();
        }
        this.nativeTerm = argNativeTerm;
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return SQLTable.class;
    }
}

