/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;

public class CountingUndoCompoundEventListener
implements UndoCompoundEventListener,
SQLObjectListener {
    private int editDepth;
    private int editsInLastGroup;
    private int editsBeforeLastGroup;
    private int liveEdits;

    public void compoundEditStart(UndoCompoundEvent e) {
        if (this.editDepth == 0) {
            this.editsBeforeLastGroup = this.liveEdits;
        }
        ++this.editDepth;
    }

    public void compoundEditEnd(UndoCompoundEvent e) {
        if (this.editDepth == 0) {
            throw new IllegalStateException("Compound edit depth was already 0");
        }
        --this.editDepth;
        if (this.editDepth == 0) {
            this.editsInLastGroup = this.liveEdits;
            this.liveEdits = 0;
        }
    }

    public int getEditDepth() {
        return this.editDepth;
    }

    public int getEditsInLastGroup() {
        return this.editsInLastGroup;
    }

    public int getEditsBeforeLastGroup() {
        return this.editsBeforeLastGroup;
    }

    public void dbChildrenInserted(SQLObjectEvent e) {
        ++this.liveEdits;
    }

    public void dbChildrenRemoved(SQLObjectEvent e) {
        ++this.liveEdits;
    }

    public void dbObjectChanged(SQLObjectEvent e) {
        ++this.liveEdits;
    }

    public void dbStructureChanged(SQLObjectEvent e) {
        ++this.liveEdits;
    }
}

