/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;

public class CountingSQLObjectListener
implements SQLObjectListener {
    private int insertedCount;
    private int removedCount;
    private int changedCount;
    private int structureChangedCount;
    private SQLObjectEvent lastEvent;

    public void dbChildrenInserted(SQLObjectEvent e) {
        this.lastEvent = e;
        ++this.insertedCount;
    }

    public void dbChildrenRemoved(SQLObjectEvent e) {
        this.lastEvent = e;
        ++this.removedCount;
    }

    public void dbObjectChanged(SQLObjectEvent e) {
        this.lastEvent = e;
        ++this.changedCount;
    }

    public void dbStructureChanged(SQLObjectEvent e) {
        this.lastEvent = e;
        ++this.structureChangedCount;
    }

    public int getChangedCount() {
        return this.changedCount;
    }

    public int getInsertedCount() {
        return this.insertedCount;
    }

    public int getRemovedCount() {
        return this.removedCount;
    }

    public int getStructureChangedCount() {
        return this.structureChangedCount;
    }

    public SQLObjectEvent getLastEvent() {
        return this.lastEvent;
    }
}

