/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.PrintUserSettings;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.ddl.DDLUserSettings;
import ca.sqlpower.architect.etl.ETLUserSettings;
import ca.sqlpower.architect.qfa.QFAUserSettings;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class ConfigFile {
    private static final int MAX_DRIVER_JAR_FILE_NAMES = 99;
    protected static final String JAR_FILE_NODE_NAME = "jarfiles";
    protected static final String PREFS_JARFILE_PREFIX = "JDBCJarFile.";
    private static final Logger logger = Logger.getLogger(ConfigFile.class);
    private static ConfigFile singleton = new ConfigFile();
    private Preferences prefs;
    protected File file;

    private ConfigFile() {
    }

    public static ConfigFile getDefaultInstance() {
        return singleton;
    }

    public CoreUserSettings read(ArchitectSession session) {
        logger.debug((Object)"loading UserSettings from java.util.prefs.");
        if (this.prefs == null) {
            this.prefs = ArchitectFrame.getMainInstance().getPrefs();
        }
        logger.debug((Object)("Preferences class = " + this.prefs.getClass()));
        CoreUserSettings userSettings = new CoreUserSettings();
        Preferences jarNode = this.prefs.node(JAR_FILE_NODE_NAME);
        logger.debug((Object)("PreferencesManager.load(): jarNode " + jarNode));
        session.removeAllDriverJars();
        int i = 0;
        while (i <= 99) {
            String jarName = jarNode.get(this.jarFilePrefName(i), null);
            logger.debug((Object)("read Jar File entry: " + jarName));
            if (jarName == null) break;
            logger.debug((Object)("Adding JarName: " + jarName));
            session.addDriverJar(jarName);
            ++i;
        }
        userSettings.setPlDotIniPath(this.prefs.get("PL.INI.PATH", null));
        UserSettings swingUserSettings = userSettings.getSwingSettings();
        swingUserSettings.setBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", this.prefs.getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false));
        ETLUserSettings etlUserSettings = userSettings.getETLUserSettings();
        etlUserSettings.setString("ETLUserSettings.PROP_PL_ENGINE_PATH", this.prefs.get("ETLUserSettings.PROP_PL_ENGINE_PATH", ""));
        etlUserSettings.setString("ETLUserSettings.PROP_ETL_LOG_PATH", this.prefs.get("ETLUserSettings.PROP_ETL_LOG_PATH", this.defaultHomeFile("etl.log")));
        DDLUserSettings ddlUserSettings = userSettings.getDDLUserSettings();
        ddlUserSettings.setString("DDLUserSettings.PROP_DDL_LOG_PATH", this.prefs.get("DDLUserSettings.PROP_DDL_LOG_PATH", this.defaultHomeFile("ddl.log")));
        QFAUserSettings qfaUserSettings = userSettings.getQfaUserSettings();
        qfaUserSettings.setBoolean("QFAUserSettings.EXCEPTION_REPORTING", this.prefs.getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true));
        PrintUserSettings printUserSettings = userSettings.getPrintUserSettings();
        printUserSettings.setDefaultPrinterName(this.prefs.get("DEFAULT_PRINTER_NAME", ""));
        return userSettings;
    }

    public void write(ArchitectSession session) throws ArchitectException {
        logger.debug((Object)"Saving prefs to java.util.prefs");
        CoreUserSettings userSettings = session.getUserSettings();
        try {
            this.prefs.node(JAR_FILE_NODE_NAME).removeNode();
            this.prefs.flush();
            if (this.prefs.nodeExists(JAR_FILE_NODE_NAME)) {
                System.err.println("Warning: Jar Node Still Exists!!");
            }
        }
        catch (BackingStoreException e) {
            logger.warn((Object)"Error: BackingStoreException while removing or testing previous Jar Node!!");
        }
        Preferences jarNode = this.prefs.node(JAR_FILE_NODE_NAME);
        List<String> driverJarList = session.getDriverJarList();
        Iterator<String> it = driverJarList.iterator();
        int i = 0;
        while (i <= 99) {
            if (it.hasNext()) {
                String name = it.next();
                logger.debug((Object)("Putting JAR " + i + " " + name));
                jarNode.put(this.jarFilePrefName(i), name);
            }
            ++i;
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Unable to flush Java preferences", e);
        }
        this.prefs.put("PL.INI.PATH", userSettings.getPlDotIniPath());
        UserSettings swingUserSettings = userSettings.getSwingSettings();
        this.prefs.putBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", swingUserSettings.getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false));
        ETLUserSettings etlUserSettings = userSettings.getETLUserSettings();
        this.prefs.put("ETLUserSettings.PROP_PL_ENGINE_PATH", etlUserSettings.getString("ETLUserSettings.PROP_PL_ENGINE_PATH", ""));
        this.prefs.put("ETLUserSettings.PROP_ETL_LOG_PATH", etlUserSettings.getString("ETLUserSettings.PROP_ETL_LOG_PATH", ""));
        DDLUserSettings ddlUserSettings = userSettings.getDDLUserSettings();
        this.prefs.put("DDLUserSettings.PROP_DDL_LOG_PATH", ddlUserSettings.getString("DDLUserSettings.PROP_DDL_LOG_PATH", ""));
        QFAUserSettings qfaUserSettings = userSettings.getQfaUserSettings();
        this.prefs.putBoolean("QFAUserSettings.EXCEPTION_REPORTING", qfaUserSettings.getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true));
        PrintUserSettings printUserSettings = userSettings.getPrintUserSettings();
        this.prefs.put("DEFAULT_PRINTER_NAME", printUserSettings.getDefaultPrinterName());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new ArchitectException("Unable to flush Java preferences", e);
        }
    }

    private String jarFilePrefName(int i) {
        return PREFS_JARFILE_PREFIX + String.format("%02d", i);
    }

    private String defaultHomeFile(String name) {
        return String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + name;
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    public void setPrefs(Preferences prefs) {
        this.prefs = prefs;
    }
}

