/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.jdbc.ConnectionDecorator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.log4j.Logger;

public class ArchitectConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = Logger.getLogger(ArchitectConnectionFactory.class);
    private ArchitectDataSource dataSource;

    public ArchitectConnectionFactory(ArchitectDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection createConnection() throws SQLException {
        try {
            if (this.dataSource.getDriverClass() == null || this.dataSource.getDriverClass().trim().length() == 0) {
                throw new SQLException("Connection \"" + this.dataSource.getName() + "\" has no JDBC Driver class specified.");
            }
            if (this.dataSource.getUrl() == null || this.dataSource.getUrl().trim().length() == 0) {
                throw new SQLException("Connection \"" + this.dataSource.getName() + "\" has no JDBC URL.");
            }
            if (this.dataSource.getUser() == null || this.dataSource.getUser().trim().length() == 0) {
                throw new SQLException("Connection \"" + this.dataSource.getName() + "\" has no JDBC username.");
            }
            ArchitectSession session = ArchitectSessionImpl.getInstance();
            if (session == null) {
                throw new SQLException("Can't connect to database \"" + this.dataSource.getName() + "\" because ArchitectSession.getInstance() returned null");
            }
            if (logger.isDebugEnabled()) {
                ClassLoader cl = this.getClass().getClassLoader();
                StringBuffer loaders = new StringBuffer();
                loaders.append("Local Classloader chain: ");
                while (cl != null) {
                    loaders.append(cl).append(", ");
                    cl = cl.getParent();
                }
                logger.debug((Object)loaders);
            }
            Driver driver = (Driver)Class.forName(this.dataSource.getDriverClass(), true, session.getJDBCClassLoader()).newInstance();
            logger.info((Object)("Driver Class " + this.dataSource.getDriverClass() + " loaded without exception"));
            if (!driver.acceptsURL(this.dataSource.getUrl())) {
                throw new SQLException("Couldn't connect to database:\nJDBC Driver " + this.dataSource.getDriverClass() + "\n" + "does not accept the URL " + this.dataSource.getUrl());
            }
            Properties connectionProps = new Properties();
            connectionProps.setProperty("user", this.dataSource.getUser());
            connectionProps.setProperty("password", this.dataSource.getPass());
            Connection realConnection = driver.connect(this.dataSource.getUrl(), connectionProps);
            if (realConnection == null) {
                throw new SQLException("JDBC Driver returned a null connection!");
            }
            ConnectionDecorator connection = ConnectionDecorator.createFacade(realConnection);
            logger.debug((Object)("Connection class is: " + connection.getClass().getName()));
            return connection;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Driver Class not found", (Throwable)e);
            throw new SQLException("JDBC Driver \"" + this.dataSource.getDriverClass() + "\" not found.");
        }
        catch (InstantiationException e) {
            logger.error((Object)"Creating SQL Exception to conform to interface.  Real exception is: ", (Throwable)e);
            throw new SQLException("Couldn't create an instance of the JDBC driver '" + this.dataSource.getDriverClass() + "'. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Creating SQL Exception to conform to interface.  Real exception is: ", (Throwable)e);
            throw new SQLException("Couldn't connect to database because the JDBC driver has no public constructor (this is bad). " + e.getMessage());
        }
    }
}

