/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.csv;

import com.darwinsys.csv.CSVImport;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CSVTest
extends TestCase {
    CSVImport csv = new CSVImport();
    String[] data = new String[]{"abc", "hello, world", "a,b,c", "a\"bc,d,e", "\"a,a\",b,\"c:\\foo\\bar\"", "\"he\"llo", "123,456", "\"LU\",86.25,\"11/4/1998\",\"2:19PM\",+4.0625", "bad \"input\",123e01"};
    int[] listLength = new int[]{1, 2, 3, 3, 3, 1, 2, 5, 2};

    public static void main(String[] args) {
        TestRunner.run(CSVTest.class);
    }

    public void testCSV() {
        int i = 0;
        while (i < this.data.length) {
            List<String> l = this.csv.parse(this.data[i]);
            CSVTest.assertEquals((int)l.size(), (int)this.listLength[i]);
            int k = 0;
            while (k < l.size()) {
                System.out.print("[" + l.get(k) + "],");
                ++k;
            }
            System.out.println();
            ++i;
        }
    }

    public void testBarDelim() {
        CSVImport parser = new CSVImport('|');
        List<String> l = parser.parse("\"LU\"|86.25|\"11/4/1998\"|\"2:19PM\"|+4.0625");
        CSVTest.assertEquals((int)l.size(), (int)5);
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            System.out.print("[" + it.next() + "],");
        }
        System.out.println();
    }
}

