/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.WindowSystemSnapshot;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.view.ControllerHandler;
import org.netbeans.core.windows.view.ElementAccessor;
import org.netbeans.core.windows.view.ModeAccessor;
import org.netbeans.core.windows.view.ModeStructureAccessorImpl;
import org.netbeans.core.windows.view.SlidingAccessor;
import org.netbeans.core.windows.view.SplitAccessor;
import org.netbeans.core.windows.view.WindowSystemAccessor;
import org.netbeans.core.windows.view.WindowSystemAccessorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ViewHelper {
    private static final boolean DEBUG = Debug.isLoggable(ViewHelper.class);

    private ViewHelper() {
    }

    public static WindowSystemAccessor createWindowSystemAccessor(WindowSystemSnapshot windowSystemSnapshot) {
        if (windowSystemSnapshot == null) {
            return null;
        }
        WindowSystemAccessorImpl windowSystemAccessorImpl = new WindowSystemAccessorImpl();
        ModeStructureAccessorImpl modeStructureAccessorImpl = ViewHelper.createModeStructureAccessor(windowSystemSnapshot.getModeStructureSnapshot());
        windowSystemAccessorImpl.setModeStructureAccessor(modeStructureAccessorImpl);
        ModeStructureSnapshot.ModeSnapshot modeSnapshot = windowSystemSnapshot.getActiveModeSnapshot();
        windowSystemAccessorImpl.setActiveModeAccessor(modeSnapshot == null ? null : modeStructureAccessorImpl.findModeAccessor(modeSnapshot.getName()));
        ModeStructureSnapshot.ModeSnapshot modeSnapshot2 = windowSystemSnapshot.getMaximizedModeSnapshot();
        windowSystemAccessorImpl.setMaximizedModeAccessor(modeSnapshot2 == null ? null : modeStructureAccessorImpl.findModeAccessor(modeSnapshot2.getName()));
        windowSystemAccessorImpl.setMainWindowBoundsJoined(windowSystemSnapshot.getMainWindowBoundsJoined());
        windowSystemAccessorImpl.setMainWindowBoundsSeparated(windowSystemSnapshot.getMainWindowBoundsSeparated());
        windowSystemAccessorImpl.setEditorAreaBounds(windowSystemSnapshot.getEditorAreaBounds());
        windowSystemAccessorImpl.setEditorAreaState(windowSystemSnapshot.getEditorAreaState());
        windowSystemAccessorImpl.setEditorAreaFrameState(windowSystemSnapshot.getEditorAreaFrameState());
        windowSystemAccessorImpl.setMainWindowFrameStateJoined(windowSystemSnapshot.getMainWindowFrameStateJoined());
        windowSystemAccessorImpl.setMainWindowFrameStateSeparated(windowSystemSnapshot.getMainWindowFrameStateSeparated());
        windowSystemAccessorImpl.setToolbarConfigurationName(windowSystemSnapshot.getToolbarConfigurationName());
        return windowSystemAccessorImpl;
    }

    private static ModeStructureAccessorImpl createModeStructureAccessor(ModeStructureSnapshot modeStructureSnapshot) {
        ElementAccessor elementAccessor = ViewHelper.createVisibleAccessor(modeStructureSnapshot.getSplitRootSnapshot());
        Set<ModeAccessor> set = ViewHelper.createSeparateModeAccessors(modeStructureSnapshot.getSeparateModeSnapshots());
        Set<SlidingAccessor> set2 = ViewHelper.createSlidingModeAccessors(modeStructureSnapshot.getSlidingModeSnapshots());
        ModeStructureAccessorImpl modeStructureAccessorImpl = new ModeStructureAccessorImpl(elementAccessor, set, set2);
        return modeStructureAccessorImpl;
    }

    private static Set<ModeAccessor> createSeparateModeAccessors(ModeStructureSnapshot.ModeSnapshot[] modeSnapshotArray) {
        HashSet<ModeAccessor> hashSet = new HashSet<ModeAccessor>();
        for (int i = 0; i < modeSnapshotArray.length; ++i) {
            ModeStructureSnapshot.ModeSnapshot modeSnapshot = modeSnapshotArray[i];
            if (!modeSnapshot.isVisibleSeparate()) continue;
            hashSet.add(new ModeStructureAccessorImpl.ModeAccessorImpl(modeSnapshot.getOriginator(), modeSnapshot));
        }
        return hashSet;
    }

    private static Set<SlidingAccessor> createSlidingModeAccessors(ModeStructureSnapshot.SlidingModeSnapshot[] slidingModeSnapshotArray) {
        HashSet<SlidingAccessor> hashSet = new HashSet<SlidingAccessor>();
        for (int i = 0; i < slidingModeSnapshotArray.length; ++i) {
            ModeStructureSnapshot.SlidingModeSnapshot slidingModeSnapshot = slidingModeSnapshotArray[i];
            hashSet.add(new ModeStructureAccessorImpl.SlidingAccessorImpl(slidingModeSnapshot.getOriginator(), slidingModeSnapshot, slidingModeSnapshot.getSide(), slidingModeSnapshot.getSlideInSizes()));
        }
        return hashSet;
    }

    private static ElementAccessor createVisibleAccessor(ModeStructureSnapshot.ElementSnapshot elementSnapshot) {
        if (elementSnapshot == null) {
            return null;
        }
        if (elementSnapshot instanceof ModeStructureSnapshot.EditorSnapshot) {
            ModeStructureSnapshot.EditorSnapshot editorSnapshot = (ModeStructureSnapshot.EditorSnapshot)elementSnapshot;
            return new ModeStructureAccessorImpl.EditorAccessorImpl(editorSnapshot.getOriginator(), editorSnapshot, ViewHelper.createVisibleAccessor(editorSnapshot.getEditorAreaSnapshot()), editorSnapshot.getResizeWeight());
        }
        if (elementSnapshot.isVisibleInSplit()) {
            if (elementSnapshot instanceof ModeStructureSnapshot.SplitSnapshot) {
                ModeStructureSnapshot.SplitSnapshot splitSnapshot = (ModeStructureSnapshot.SplitSnapshot)elementSnapshot;
                return ViewHelper.createSplitAccessor(splitSnapshot);
            }
            if (elementSnapshot instanceof ModeStructureSnapshot.ModeSnapshot) {
                ModeStructureSnapshot.ModeSnapshot modeSnapshot = (ModeStructureSnapshot.ModeSnapshot)elementSnapshot;
                return new ModeStructureAccessorImpl.ModeAccessorImpl(modeSnapshot.getOriginator(), modeSnapshot);
            }
        } else if (elementSnapshot instanceof ModeStructureSnapshot.SplitSnapshot) {
            ModeStructureSnapshot.SplitSnapshot splitSnapshot = (ModeStructureSnapshot.SplitSnapshot)elementSnapshot;
            for (ModeStructureSnapshot.ElementSnapshot elementSnapshot2 : splitSnapshot.getChildSnapshots()) {
                if (!elementSnapshot2.hasVisibleDescendant()) continue;
                return ViewHelper.createVisibleAccessor(elementSnapshot2);
            }
        }
        return null;
    }

    private static ElementAccessor createSplitAccessor(ModeStructureSnapshot.SplitSnapshot splitSnapshot) {
        Object object2;
        List list = splitSnapshot.getVisibleChildSnapshots();
        ArrayList<ElementAccessor> arrayList = new ArrayList<ElementAccessor>(list.size());
        ArrayList<Double> arrayList2 = new ArrayList<Double>(list.size());
        int n = 0;
        for (Object object2 : list) {
            ElementAccessor elementAccessor = ViewHelper.createVisibleAccessor((ModeStructureSnapshot.ElementSnapshot)object2);
            double d = splitSnapshot.getChildSnapshotSplitWeight((ModeStructureSnapshot.ElementSnapshot)object2);
            if (elementAccessor instanceof SplitAccessor && ((SplitAccessor)elementAccessor).getOrientation() == splitSnapshot.getOrientation()) {
                SplitAccessor splitAccessor = (SplitAccessor)elementAccessor;
                ElementAccessor[] elementAccessorArray = splitAccessor.getChildren();
                double[] dArray = splitAccessor.getSplitWeights();
                for (int i = 0; i < elementAccessorArray.length; ++i) {
                    arrayList.add(elementAccessorArray[i]);
                    arrayList2.add(dArray[i] * d);
                }
            } else {
                arrayList.add(elementAccessor);
                arrayList2.add(d);
            }
            ++n;
        }
        ElementAccessor[] elementAccessorArray = new ElementAccessor[arrayList.size()];
        object2 = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementAccessor elementAccessor = (ElementAccessor)arrayList.get(i);
            Double d = (Double)arrayList2.get(i);
            elementAccessorArray[i] = elementAccessor;
            object2[i] = d;
        }
        return new ModeStructureAccessorImpl.SplitAccessorImpl(splitSnapshot.getOriginator(), splitSnapshot, splitSnapshot.getOrientation(), (double[])object2, elementAccessorArray, splitSnapshot.getResizeWeight());
    }

    public static void setSplitWeights(SplitAccessor splitAccessor, ElementAccessor[] elementAccessorArray, double[] dArray, ControllerHandler controllerHandler) {
        ModeStructureSnapshot.SplitSnapshot splitSnapshot = (ModeStructureSnapshot.SplitSnapshot)splitAccessor.getSnapshot();
        if (splitSnapshot == null) {
            return;
        }
        ModelElement[] modelElementArray = new ModelElement[elementAccessorArray.length];
        for (int i = 0; i < elementAccessorArray.length; ++i) {
            ModeStructureSnapshot.ElementSnapshot elementSnapshot = ViewHelper.findVisibleSplitSnapshot(elementAccessorArray[i].getSnapshot());
            modelElementArray[i] = elementSnapshot.getOriginator();
            dArray[i] = ViewHelper.correctNestedSplitWeight(elementSnapshot.getParent(), dArray[i]);
        }
        controllerHandler.userChangedSplit(modelElementArray, dArray);
    }

    private static double correctNestedSplitWeight(ModeStructureSnapshot.SplitSnapshot splitSnapshot, double d) {
        ModeStructureSnapshot.SplitSnapshot splitSnapshot2;
        int n = splitSnapshot.getOrientation();
        for (splitSnapshot2 = splitSnapshot.getParent(); null != splitSnapshot2 && !splitSnapshot2.isVisibleInSplit(); splitSnapshot2 = splitSnapshot2.getParent()) {
            splitSnapshot = splitSnapshot2;
        }
        if (null != splitSnapshot2 && splitSnapshot2.getOrientation() == n) {
            double d2 = splitSnapshot2.getChildSnapshotSplitWeight(splitSnapshot);
            if (splitSnapshot2.getVisibleChildSnapshots().size() > 1 && d2 > 0.0) {
                d /= d2;
            }
            return ViewHelper.correctNestedSplitWeight(splitSnapshot2, d);
        }
        return d;
    }

    private static ModeStructureSnapshot.ElementSnapshot findVisibleSplitSnapshot(ModeStructureSnapshot.ElementSnapshot elementSnapshot) {
        List list;
        ModeStructureSnapshot.SplitSnapshot splitSnapshot = elementSnapshot.getParent();
        if (null != splitSnapshot && (list = splitSnapshot.getVisibleChildSnapshots()).size() == 1) {
            return ViewHelper.findVisibleSplitSnapshot(splitSnapshot);
        }
        return elementSnapshot;
    }

    private static void debugLog(String string) {
        Debug.log(ViewHelper.class, string);
    }
}

