/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.EdgeInsnAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.CleanRegions;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IRegionVisitor;
import jadx.core.dex.visitors.regions.ProcessTryCatchRegions;
import jadx.core.dex.visitors.regions.RegionMaker;
import jadx.core.dex.visitors.regions.RegionStack;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMakerVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(RegionMakerVisitor.class);
    private static final IRegionVisitor POST_REGION_VISITOR = new PostRegionVisitor();

    @Override
    public void visit(MethodNode mth) throws JadxException {
        IRegion expOutBlock;
        if (mth.isNoCode() || mth.getBasicBlocks().isEmpty()) {
            return;
        }
        RegionMaker rm = new RegionMaker(mth);
        RegionStack state = new RegionStack(mth);
        BlockNode startBlock = Utils.first(mth.getEnterBlock().getCleanSuccessors());
        mth.setRegion(rm.makeRegion(startBlock, state));
        if (!mth.isNoExceptionHandlers() && (expOutBlock = rm.processTryCatchBlocks(mth)) != null) {
            mth.getRegion().add(expOutBlock);
        }
        RegionMakerVisitor.postProcessRegions(mth);
    }

    private static void postProcessRegions(MethodNode mth) {
        RegionMakerVisitor.processForceInlineInsns(mth);
        ProcessTryCatchRegions.process(mth);
        DepthRegionTraversal.traverse(mth, POST_REGION_VISITOR);
        CleanRegions.process(mth);
        if (mth.getAccessFlags().isSynchronized()) {
            RegionMakerVisitor.removeSynchronized(mth);
        }
    }

    private static void processForceInlineInsns(MethodNode mth) {
        boolean needShrink = mth.getBasicBlocks().stream().flatMap(block -> block.getInstructions().stream()).anyMatch(insn -> insn.contains(AFlag.FORCE_ASSIGN_INLINE));
        if (needShrink) {
            CodeShrinkVisitor.shrinkMethod(mth);
        }
    }

    private static void removeSynchronized(MethodNode mth) {
        Region startRegion = mth.getRegion();
        List<IContainer> subBlocks = startRegion.getSubBlocks();
        if (!subBlocks.isEmpty() && subBlocks.get(0) instanceof SynchronizedRegion) {
            SynchronizedRegion synchRegion = (SynchronizedRegion)subBlocks.get(0);
            InsnNode synchInsn = synchRegion.getEnterInsn();
            if (!synchInsn.getArg(0).isThis()) {
                LOG.warn("In synchronized method {}, top region not synchronized by 'this' {}", (Object)mth, (Object)synchInsn);
                return;
            }
            startRegion.getSubBlocks().set(0, synchRegion.getRegion());
            InsnRemover.remove(mth, synchInsn);
            for (InsnNode exit : synchRegion.getExitInsns()) {
                InsnRemover.remove(mth, exit);
            }
            CleanRegions.process(mth);
        }
    }

    private static final class PostRegionVisitor
    extends AbstractRegionVisitor {
        private PostRegionVisitor() {
        }

        @Override
        public void leaveRegion(MethodNode mth, IRegion region) {
            if (region instanceof LoopRegion) {
                LoopRegion loop = (LoopRegion)region;
                loop.mergePreCondition();
            } else if (region instanceof SwitchRegion) {
                PostRegionVisitor.processSwitch(mth, (SwitchRegion)region);
            } else if (region instanceof Region) {
                PostRegionVisitor.insertEdgeInsn((Region)region);
            }
        }

        private static void insertEdgeInsn(Region region) {
            BlockNode block;
            List<IContainer> subBlocks = region.getSubBlocks();
            if (subBlocks.isEmpty()) {
                return;
            }
            IContainer last = subBlocks.get(subBlocks.size() - 1);
            List edgeInsnAttrs = last.getAll(AType.EDGE_INSN);
            if (edgeInsnAttrs.isEmpty()) {
                return;
            }
            EdgeInsnAttr insnAttr = (EdgeInsnAttr)edgeInsnAttrs.get(0);
            if (!insnAttr.getStart().equals(last)) {
                return;
            }
            if (last instanceof BlockNode && (block = (BlockNode)last).getInstructions().isEmpty()) {
                block.getInstructions().add(insnAttr.getInsn());
                return;
            }
            List<InsnNode> insns = Collections.singletonList(insnAttr.getInsn());
            region.add(new InsnContainer(insns));
        }

        private static void processSwitch(MethodNode mth, SwitchRegion sw) {
            for (IContainer c : sw.getBranches()) {
                if (!(c instanceof Region)) continue;
                HashSet<IBlock> blocks = new HashSet<IBlock>();
                RegionUtils.getAllRegionBlocks(c, blocks);
                if (blocks.isEmpty()) {
                    PostRegionVisitor.addBreakToContainer((Region)c);
                    continue;
                }
                for (IBlock block : blocks) {
                    if (!(block instanceof BlockNode)) continue;
                    PostRegionVisitor.addBreakForBlock(mth, c, blocks, (BlockNode)block);
                }
            }
        }

        private static void addBreakToContainer(Region c) {
            if (RegionUtils.hasExitEdge(c)) {
                return;
            }
            ArrayList<InsnNode> insns = new ArrayList<InsnNode>(1);
            insns.add(new InsnNode(InsnType.BREAK, 0));
            c.add(new InsnContainer(insns));
        }

        private static void addBreakForBlock(MethodNode mth, IContainer c, Set<IBlock> blocks, BlockNode bn) {
            for (BlockNode s : bn.getCleanSuccessors()) {
                if (blocks.contains(s) || bn.contains(AFlag.ADDED_TO_REGION) || s.contains(AFlag.FALL_THROUGH)) continue;
                PostRegionVisitor.addBreak(mth, c, bn);
                return;
            }
        }

        private static void addBreak(MethodNode mth, IContainer c, BlockNode bn) {
            IContainer blockContainer = RegionUtils.getBlockContainer(c, bn);
            if (blockContainer instanceof Region) {
                PostRegionVisitor.addBreakToContainer((Region)blockContainer);
            } else if (c instanceof Region) {
                PostRegionVisitor.addBreakToContainer((Region)c);
            } else {
                LOG.warn("Can't insert break, container: {}, block: {}, mth: {}", new Object[]{blockContainer, bn, mth});
            }
        }
    }
}

