/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolox.swt.SWTShapeManager;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class SWTGraphics2D
extends Graphics2D {
    protected static int CACHE_COUNT = 0;
    protected static HashMap FONT_CACHE = new HashMap();
    protected static HashMap COLOR_CACHE = new HashMap();
    protected static HashMap SHAPE_CACHE = new HashMap();
    protected static BufferedImage BUFFER = new BufferedImage(1, 1, 2);
    static java.awt.Point PT = new java.awt.Point();
    static Rectangle2D RECT = new Rectangle2D.Double();
    static Rectangle2D LINE_RECT = new Rectangle2D.Double();
    static org.eclipse.swt.graphics.Rectangle SWT_RECT = new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    protected GC gc;
    protected Device device;
    protected AffineTransform transform = new AffineTransform();
    protected org.eclipse.swt.graphics.Font curFont;
    protected double lineWidth = 1.0;

    public SWTGraphics2D(GC gC, Device device) {
        this.gc = gC;
        this.device = device;
    }

    public Rectangle getClipBounds() {
        org.eclipse.swt.graphics.Rectangle rectangle = this.gc.getClipping();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            SWTShapeManager.transform(rectangle2, this.transform.createInverse());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return rectangle2;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        RECT.setRect(n, n2, n3, n4);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        org.eclipse.swt.graphics.Rectangle rectangle = this.gc.getClipping();
        rectangle = rectangle.intersection(SWT_RECT);
        this.gc.setClipping(rectangle);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        RECT.setRect(n, n2, n3, n4);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.setClipping(SWT_RECT);
    }

    public void clip(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        SWTShapeManager.transform(rectangle2D, this.transform);
        SWTShapeManager.awtToSWT(rectangle2D, SWT_RECT);
        org.eclipse.swt.graphics.Rectangle rectangle = this.gc.getClipping();
        rectangle = rectangle.intersection(SWT_RECT);
        this.gc.setClipping(SWT_RECT);
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            this.gc.setClipping((org.eclipse.swt.graphics.Rectangle)null);
        } else {
            Rectangle2D rectangle2D = shape.getBounds2D();
            SWTShapeManager.transform(rectangle2D, this.transform);
            SWTShapeManager.awtToSWT(rectangle2D, SWT_RECT);
            this.gc.setClipping(SWT_RECT);
        }
    }

    public Shape getClip() {
        org.eclipse.swt.graphics.Rectangle rectangle = this.gc.getClipping();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            SWTShapeManager.transform(double_, this.transform.createInverse());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return double_;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return ((Graphics2D)BUFFER.getGraphics()).getDeviceConfiguration();
    }

    public Paint getPaint() {
        return this.getColor();
    }

    public void setPaint(Paint paint) {
        if (paint instanceof java.awt.Color) {
            this.setColor((java.awt.Color)paint);
        }
    }

    public java.awt.Color getColor() {
        Color color = this.gc.getForeground();
        java.awt.Color color2 = new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
        return color2;
    }

    public void setColor(java.awt.Color color) {
        Color color2 = (Color)COLOR_CACHE.get(color);
        if (color2 == null) {
            color2 = new Color(this.device, color.getRed(), color.getGreen(), color.getBlue());
            COLOR_CACHE.put(color, color2);
        }
        this.gc.setForeground(color2);
    }

    public void setColor(Color color) {
        this.gc.setForeground(color);
    }

    public void setBackground(java.awt.Color color) {
        Color color2 = (Color)COLOR_CACHE.get(color);
        if (color2 == null) {
            color2 = new Color(this.device, color.getRed(), color.getGreen(), color.getBlue());
            COLOR_CACHE.put(color, color2);
        }
        this.gc.setBackground(color2);
    }

    public void setBackground(Color color) {
        this.gc.setBackground(color);
    }

    public java.awt.Color getBackground() {
        Color color = this.gc.getBackground();
        java.awt.Color color2 = new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
        return color2;
    }

    public org.eclipse.swt.graphics.Font getSWTFont() {
        return this.curFont;
    }

    public FontMetrics getSWTFontMetrics() {
        this.gc.setFont(this.curFont);
        return this.gc.getFontMetrics();
    }

    public Font getFont() {
        if (this.curFont != null) {
            int n = 0;
            FontData[] fontDataArray = this.curFont.getFontData();
            if (fontDataArray.length > 0) {
                if ((fontDataArray[0].getStyle() & 1) != 0) {
                    n |= 1;
                }
                if ((fontDataArray[0].getStyle() & 2) != 0) {
                    n |= 2;
                }
                return new Font(fontDataArray[0].getName(), n, fontDataArray[0].height);
            }
            return null;
        }
        return null;
    }

    public void setFont(Font font) {
        String string = "name=" + font.getFamily() + ";bold=" + font.isBold() + ";italic=" + font.isItalic() + ";size=" + font.getSize();
        this.curFont = this.getFont(string);
    }

    public void setFont(org.eclipse.swt.graphics.Font font) {
        this.curFont = font;
    }

    public org.eclipse.swt.graphics.Font getFont(String string) {
        org.eclipse.swt.graphics.Font font = (org.eclipse.swt.graphics.Font)FONT_CACHE.get(string);
        if (font == null) {
            int n = 0;
            if (string.indexOf("bold=true") != -1) {
                n |= 1;
            }
            if (string.indexOf("italic=true") != -1) {
                n |= 2;
            }
            String string2 = string.substring(0, string.indexOf(";"));
            String string3 = string.substring(string.lastIndexOf(";") + 1, string.length());
            int n2 = 12;
            try {
                n2 = Integer.parseInt(string3.substring(string3.indexOf("=") + 1, string3.length()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            font = new org.eclipse.swt.graphics.Font(this.device, string2.substring(string2.indexOf("=") + 1, string2.length()), n2, n);
            FONT_CACHE.put(string, font);
        }
        return font;
    }

    protected org.eclipse.swt.graphics.Font getTransformedFont() {
        if (this.curFont != null) {
            FontData fontData = this.curFont.getFontData()[0];
            int n = fontData.getHeight();
            RECT.setRect(0.0, 0.0, n, n);
            SWTShapeManager.transform(RECT, this.transform);
            n = (int)(RECT.getHeight() + 0.5);
            String string = "name=" + fontData.getName() + ";bold=" + ((fontData.getStyle() & 1) != 0) + ";italic=" + ((fontData.getStyle() & 2) != 0) + ";size=" + n;
            return this.getFont(string);
        }
        return null;
    }

    public void translate(int n, int n2) {
        this.transform.translate(n, n2);
    }

    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
    }

    public void rotate(double d) {
        this.transform.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
    }

    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = (AffineTransform)affineTransform.clone();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.fillRect(n, n2, n3, n4);
    }

    public void draw(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.drawRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            this.drawOval(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight());
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            this.drawRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        } else if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            this.drawArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent());
        } else {
            double[] dArray = (double[])SHAPE_CACHE.get(shape);
            if (dArray == null) {
                dArray = SWTShapeManager.shapeToPolyline(shape);
                SHAPE_CACHE.put(shape, dArray);
            }
            this.drawPolyline(dArray);
        }
    }

    public void fill(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.fillRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            this.fillOval(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight());
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            this.fillRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        } else if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            this.fillArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent());
        } else {
            double[] dArray = (double[])SHAPE_CACHE.get(shape);
            if (dArray == null) {
                dArray = SWTShapeManager.shapeToPolyline(shape);
                SHAPE_CACHE.put(shape, dArray);
            }
            this.fillPolygon(dArray);
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[2 * n];
        for (int i = 0; i < n; ++i) {
            PT.setLocation(nArray[i], nArray2[i]);
            this.transform.transform(PT, PT);
            nArray3[2 * i] = nArray[i];
            nArray3[2 * i + 1] = nArray2[i];
        }
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawPolyline(nArray3);
    }

    public void drawPolyline(double[] dArray) {
        int[] nArray = SWTShapeManager.transform(dArray, this.transform);
        this.gc.drawPolyline(nArray);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[2 * n];
        for (int i = 0; i < n; ++i) {
            PT.setLocation(nArray[i], nArray2[i]);
            this.transform.transform(PT, PT);
            nArray3[2 * i] = nArray[i];
            nArray3[2 * i + 1] = nArray2[i];
        }
        this.gc.drawPolygon(nArray3);
    }

    public void fillPolygon(double[] dArray) {
        int[] nArray = SWTShapeManager.transform(dArray, this.transform);
        this.gc.fillPolygon(nArray);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[2 * n];
        for (int i = 0; i < n; ++i) {
            PT.setLocation(nArray[i], nArray2[i]);
            this.transform.transform(PT, PT);
            nArray3[2 * i] = nArray[i];
            nArray3[2 * i + 1] = nArray2[i];
        }
        this.gc.fillPolygon(nArray3);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        PT.setLocation(d, d2);
        this.transform.transform(PT, PT);
        d = (int)PT.getX();
        d2 = (int)PT.getY();
        PT.setLocation(d3, d4);
        this.transform.transform(PT, PT);
        d3 = (int)PT.getX();
        d4 = (int)PT.getY();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawLine((int)(d + 0.5), (int)(d2 + 0.5), (int)(d3 + 0.5), (int)(d4 + 0.5));
    }

    public void copyArea(org.eclipse.swt.graphics.Image image, double d, double d2) {
        PT.setLocation(d, d2);
        this.transform.transform(PT, PT);
        this.gc.copyArea(image, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        RECT.setRect(n, n2, n3, n4);
        SWTShapeManager.transform(RECT, this.transform);
        PT.setLocation(n5, n6);
        this.transform.transform(PT, PT);
        this.gc.copyArea((int)RECT.getX(), (int)RECT.getY(), (int)RECT.getWidth(), (int)RECT.getHeight(), (int)PT.getX(), (int)PT.getY());
    }

    public void drawString(String string, double d, double d2) {
        PT.setLocation(d, d2);
        this.transform.transform(PT, PT);
        this.gc.setFont(this.getTransformedFont());
        this.gc.drawString(string, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5), true);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (double)n, (double)n2);
    }

    public void drawString(String string, float f, float f2) {
        this.drawString(string, (double)f, (double)f2);
    }

    public void drawText(String string, double d, double d2) {
        PT.setLocation(d, d2);
        this.transform.transform(PT, PT);
        this.gc.setFont(this.getTransformedFont());
        this.gc.drawText(string, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5), true);
    }

    public void drawText(String string, double d, double d2, int n) {
        PT.setLocation(d, d2);
        this.transform.transform(PT, PT);
        this.gc.setFont(this.getTransformedFont());
        this.gc.drawText(string, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5), n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawRectangle(SWT_RECT);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.fillRectangle(SWT_RECT);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void drawRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        d = RECT.getX();
        d2 = RECT.getY();
        d3 = RECT.getWidth();
        d4 = RECT.getHeight();
        RECT.setRect(0.0, 0.0, d5, d6);
        SWTShapeManager.transform(RECT, this.transform);
        d5 = RECT.getWidth();
        d6 = RECT.getHeight();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawRoundRectangle((int)(d + 0.5), (int)(d2 + 0.5), (int)(d3 + 0.5), (int)(d4 + 0.5), (int)(d5 + 0.5), (int)(d6 + 0.5));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void fillRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        d = RECT.getX();
        d2 = RECT.getY();
        d3 = RECT.getWidth();
        d4 = RECT.getHeight();
        RECT.setRect(0.0, 0.0, d5, d6);
        SWTShapeManager.transform(RECT, this.transform);
        d5 = RECT.getWidth();
        d6 = RECT.getHeight();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.fillRoundRectangle((int)(d + 0.5), (int)(d2 + 0.5), (int)(d3 + 0.5), (int)(d4 + 0.5), (int)(d5 + 0.5), (int)(d6 + 0.5));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawOval((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void fillOval(double d, double d2, double d3, double d4) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.fillOval((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void drawArc(double d, double d2, double d3, double d4, double d5, double d6) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawArc((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5), (int)(d5 + 0.5), (int)(d5 + d6 + 0.5));
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void fillArc(double d, double d2, double d3, double d4, double d5, double d6) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.drawArc((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5), (int)(d5 + 0.5), (int)(d5 + d6 + 0.5));
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, double d, double d2) {
        org.eclipse.swt.graphics.Rectangle rectangle = image.getBounds();
        RECT.setRect(d, d2, rectangle.width, rectangle.height);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.drawImage(image, 0, 0, rectangle.width, rectangle.height, SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height);
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.drawImage(image, n, n2, n3, n4, SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height);
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
    }

    protected int getTransformedLineWidth() {
        LINE_RECT.setRect(0.0, 0.0, this.lineWidth, this.lineWidth);
        SWTShapeManager.transform(LINE_RECT, this.transform);
        return (int)(Math.max(LINE_RECT.getWidth(), 1.0) + 0.5);
    }

    public void fillGradientRectangle(double d, double d2, double d3, double d4, boolean bl) {
        RECT.setRect(d, d2, d3, d4);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.fillGradientRectangle(SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height, bl);
    }

    public void setXORMode(boolean bl) {
        this.gc.setXORMode(bl);
    }

    public int getAdvanceWidth(char c) {
        org.eclipse.swt.graphics.Font font = this.gc.getFont();
        this.gc.setFont(this.curFont);
        int n = this.gc.getAdvanceWidth(c);
        this.gc.setFont(font);
        return n;
    }

    public int getCharWidth(char c) {
        org.eclipse.swt.graphics.Font font = this.gc.getFont();
        this.gc.setFont(this.curFont);
        int n = this.gc.getCharWidth(c);
        this.gc.setFont(font);
        return n;
    }

    public Point stringExtent(String string) {
        org.eclipse.swt.graphics.Font font = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point point = this.gc.stringExtent(string);
        this.gc.setFont(font);
        return point;
    }

    public Point textExtent(String string) {
        org.eclipse.swt.graphics.Font font = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point point = this.gc.textExtent(string);
        this.gc.setFont(font);
        return point;
    }

    public Point textExtent(String string, int n) {
        org.eclipse.swt.graphics.Font font = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point point = this.gc.textExtent(string, n);
        this.gc.setFont(font);
        return point;
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return false;
    }

    public void setComposite(Composite composite) {
    }

    public void setStroke(Stroke stroke) {
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHints(Map map) {
    }

    public void addRenderingHints(Map map) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public Stroke getStroke() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public Graphics create() {
        return null;
    }

    public void setPaintMode() {
    }

    public void setXORMode(java.awt.Color color) {
    }

    public java.awt.FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, java.awt.Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, java.awt.Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, java.awt.Color color, ImageObserver imageObserver) {
        return false;
    }

    public void dispose() {
    }

    public static void incrementGCCount() {
        ++CACHE_COUNT;
    }

    public static void decrementGCCount() {
        if (--CACHE_COUNT == 0) {
            org.eclipse.swt.graphics.Font font;
            Iterator iterator = FONT_CACHE.values().iterator();
            while (iterator.hasNext()) {
                font = (org.eclipse.swt.graphics.Font)iterator.next();
                font.dispose();
            }
            iterator = COLOR_CACHE.values().iterator();
            while (iterator.hasNext()) {
                font = (Color)iterator.next();
                font.dispose();
            }
        }
    }
}

