/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;

public final class BooleanCounter
extends PrimitiveCounter {
    private int size;
    private final int[] counts = new int[2];

    public void count(boolean key) {
        int index;
        int n = index = key ? 1 : 0;
        if (this.counts[index] == 0) {
            ++this.size;
        }
        int n2 = index;
        this.counts[n2] = this.counts[n2] + 1;
    }

    @Override
    public void count(String value) {
        this.count(Boolean.parseBoolean(value));
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    public final class Iterator
    implements java.util.Iterator<Record> {
        private int index;
        private int count;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < BooleanCounter.this.size;
        }

        @Override
        public Record next() {
            Record entry = new Record();
            entry.count = BooleanCounter.this.counts[this.index];
            while (entry.count == 0) {
                entry.count = BooleanCounter.this.counts[++this.index];
            }
            entry.value = 1 == this.index++;
            ++this.count;
            return entry;
        }
    }

    public static final class Record
    extends PrimitiveCounter.Record {
        private boolean value;
        private int count;

        private Record() {
        }

        public boolean getPrimitive() {
            return this.value;
        }

        @Override
        public String getValue() {
            return Boolean.toString(this.value);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            return this.value == ((Record)o).value;
        }
    }
}

