/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.charts.xy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartItemChange;
import org.graalvm.visualvm.lib.charts.ItemSelection;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.XYItem;
import org.graalvm.visualvm.lib.charts.xy.XYItemChange;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYChartContext;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemPainter;
import org.graalvm.visualvm.lib.ui.charts.xy.ProfilerGCXYItem;

public class ProfilerGCXYItemPainter
extends SynchronousXYItemPainter {
    public static ProfilerGCXYItemPainter painter(Color fillColor) {
        return new ProfilerGCXYItemPainter(fillColor);
    }

    ProfilerGCXYItemPainter(Color fillColor) {
        super(0.0f, null, fillColor, 0, 0);
    }

    public LongRect getItemBounds(ChartItem item, ChartContext context) {
        LongRect viewBounds = super.getItemBounds(item, context);
        viewBounds.y = 0L;
        viewBounds.height = context.getViewportHeight();
        return viewBounds;
    }

    public LongRect getDirtyBounds(ChartItemChange itemChange, ChartContext context) {
        XYItemChange change = (XYItemChange)itemChange;
        ProfilerGCXYItem item = (ProfilerGCXYItem)change.getItem();
        int[] indexes = change.getValuesIndexes();
        if (indexes.length == 1 && indexes[0] == -1) {
            LongRect dirtyBounds = change.getDirtyValuesBounds();
            long x = (long)context.getViewX((double)dirtyBounds.x);
            long y = (long)context.getViewY((double)(context.getDataOffsetY() + context.getDataHeight()));
            long width = (long)context.getViewWidth((double)dirtyBounds.width);
            long height = context.getViewportHeight();
            return new LongRect(x, y, width, height);
        }
        int lastIndex = indexes[indexes.length - 1];
        long dataStart = -1L;
        long dataEnd = -1L;
        for (int index = indexes[0]; index <= lastIndex; ++index) {
            long[] gcEnds = item.getGCEnds(index);
            if (gcEnds.length <= 0) continue;
            dataEnd = gcEnds[gcEnds.length - 1];
            if (dataStart != -1L) continue;
            long[] gcStarts = item.getGCStarts(index);
            dataStart = gcStarts[0];
        }
        if (dataStart == -1L) {
            return new LongRect();
        }
        if (dataEnd == -1L) {
            dataEnd = item.getXValue(item.getValuesCount() - 1);
        }
        long x = (long)context.getViewX((double)dataStart);
        long y = (long)context.getViewY((double)(context.getDataOffsetY() + context.getDataHeight()));
        long width = (long)context.getViewWidth((double)(dataEnd - dataStart));
        width = Math.max(width, 1L);
        long height = context.getViewportHeight();
        return new LongRect(x, y, width, height);
    }

    public double getItemView(double dataY, XYItem item, ChartContext context) {
        return 0.0;
    }

    public double getItemValue(double viewY, XYItem item, ChartContext context) {
        return 0.0;
    }

    public double getItemValueScale(XYItem item, ChartContext context) {
        return -1.0;
    }

    protected void paint(XYItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, SynchronousXYChartContext context) {
        int itemsStep;
        int valuesCount = item.getValuesCount();
        if (valuesCount < 2) {
            return;
        }
        if (context.getViewWidth() == 0L || context.getViewHeight() == 0L) {
            return;
        }
        int[][] visibleBounds = context.getVisibleBounds(dirtyArea);
        int firstFirst = visibleBounds[0][0];
        int index = firstFirst;
        if (index == -1) {
            index = visibleBounds[0][1];
        }
        if (index == -1) {
            return;
        }
        int lastFirst = visibleBounds[1][0];
        int lastIndex = lastFirst;
        if (lastIndex == -1) {
            lastIndex = visibleBounds[1][1];
        }
        if (lastIndex == -1) {
            lastIndex = valuesCount - 1;
        }
        if (lastFirst != -1 && lastIndex < valuesCount - 1) {
            ++lastIndex;
        }
        if ((itemsStep = (int)Math.ceil((double)valuesCount / (double)context.getViewWidth())) == 0) {
            itemsStep = 1;
        }
        int visibleCount = lastIndex - index + 1;
        if (itemsStep > 1) {
            int firstMod = index % itemsStep;
            int lastMod = lastIndex % itemsStep;
            lastIndex = lastIndex - lastMod + itemsStep;
            visibleCount = (lastIndex - (index -= firstMod)) / itemsStep + 1;
            lastIndex = Math.min(lastIndex, valuesCount - 1);
        }
        ProfilerGCXYItem xyItem = (ProfilerGCXYItem)item;
        g.setColor(this.fillColor);
        int startY = (int)context.getViewY((double)(context.getDataOffsetY() + context.getDataHeight()));
        int height = context.getViewportHeight();
        for (int iter = 0; iter < visibleCount; ++iter) {
            long[] gcStarts = xyItem.getGCStarts(index);
            if (gcStarts.length > 0) {
                long[] gcEnds = xyItem.getGCEnds(index);
                for (int i = 0; i < gcStarts.length; ++i) {
                    int itemStart = Utils.checkedInt((double)context.getViewX((double)gcStarts[i]));
                    long gcEnd = gcEnds[i];
                    if (gcEnd == -1L) {
                        gcEnd = item.getXValue(item.getValuesCount() - 1);
                    }
                    int itemLength = Utils.checkedInt((double)context.getViewWidth((double)(gcEnd - gcStarts[i])));
                    g.fillRect(itemStart, startY, Math.max(itemLength, 1), height);
                }
            }
            index = Math.min(index + itemsStep, lastIndex);
        }
    }
}

