/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.Constants;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.FinishingTextDetailList;
import org.netbeans.modules.search.matcher.LineReader;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.netbeans.modules.search.matcher.ReadLineBuffer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class SingleLineStreamMatcher
extends AbstractMatcher {
    private static final int limit = Constants.DETAILS_COUNT_LIMIT;
    private volatile boolean terminated = false;
    private SearchPattern searchPattern;
    private Pattern pattern;
    private int count = 0;

    public SingleLineStreamMatcher(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
        this.pattern = TextRegexpUtil.makeTextPattern(searchPattern);
    }

    @Override
    public MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        CharsetDecoder charsetDecoder = this.prepareDecoder(charset);
        try {
            searchListener.fileContentMatchingStarted(fileObject.getPath());
            List<TextDetail> list = this.getTextDetailsSL(fileObject, charsetDecoder, searchListener);
            if (list == null) {
                return null;
            }
            return new MatchingObject.Def(fileObject, charset, list);
        }
        catch (CharacterCodingException characterCodingException) {
            this.handleDecodingError(searchListener, fileObject, charsetDecoder, characterCodingException);
            return null;
        }
        catch (Exception exception) {
            searchListener.fileContentMatchingError(fileObject.getPath(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TextDetail> getTextDetailsSL(FileObject fileObject, CharsetDecoder charsetDecoder, SearchListener searchListener) throws FileNotFoundException, DataObjectNotFoundException, IOException {
        LinkedList<Object> linkedList = null;
        DataObject dataObject = null;
        ReadLineBuffer readLineBuffer = new ReadLineBuffer(3);
        FinishingTextDetailList finishingTextDetailList = new FinishingTextDetailList(3);
        boolean bl = true;
        try (InputStream inputStream = fileObject.getInputStream();
             LineReader lineReader = new LineReader(charsetDecoder, inputStream);){
            LineReader.LineInfo lineInfo;
            while ((lineInfo = lineReader.readNext()) != null && bl && this.count < limit) {
                Object object;
                Matcher matcher = this.pattern.matcher(lineInfo.getString());
                while (matcher.find() && bl) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Object>();
                        dataObject = DataObject.find((FileObject)fileObject);
                    }
                    object = MatcherUtils.createTextDetail(false, matcher, dataObject, lineInfo.getNumber(), lineInfo.getString(), lineInfo.getFileStart(), this.searchPattern);
                    linkedList.add(object);
                    for (ReadLineBuffer.Line line : readLineBuffer.getLines()) {
                        ((TextDetail)object).addSurroundingLine(line.getNumber(), line.getText());
                    }
                    finishingTextDetailList.addTextDetail((TextDetail)object);
                    ++this.count;
                }
                if (lineInfo.getNumber() % 50 == 0) {
                    object = this;
                    synchronized (object) {
                        bl = !this.terminated;
                    }
                    searchListener.fileContentMatchingProgress(fileObject.getPath(), lineInfo.getFileEnd());
                }
                readLineBuffer.addLine(lineInfo.getNumber(), lineInfo.getString());
                finishingTextDetailList.nextLineRead(lineInfo.getNumber(), lineInfo.getString());
            }
        }
        return linkedList;
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }
}

