/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import org.openide.actions.NewTemplateAction;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.NodeAction;

public final class SaveAsTemplateAction
extends NodeAction {
    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAsTemplateAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(DataObject.class, (String)"SaveAsTemplate");
    }

    @Deprecated
    public String iconResource() {
        return super.iconResource();
    }

    protected boolean surviveFocusChange() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
            if (dataObject != null && dataObject.isCopyAllowed()) continue;
            return false;
        }
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        Node[] nodeArray2;
        FolderNodeAcceptor folderNodeAcceptor = FolderNodeAcceptor.getInstance();
        String string = NbBundle.getMessage(DataObject.class, (String)"Title_SaveAsTemplate");
        String string2 = NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsTemplate");
        Node node = NewTemplateAction.getTemplateRoot();
        node.setDisplayName(NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsTemplate_TemplatesRoot"));
        try {
            nodeArray2 = NodeOperation.getDefault().select(string, string2, node, (NodeAcceptor)folderNodeAcceptor, null);
        }
        catch (UserCancelException userCancelException) {
            return;
        }
        DataFolder dataFolder = (DataFolder)nodeArray2[0].getCookie(DataFolder.class);
        for (int i = 0; i < nodeArray.length; ++i) {
            this.createNewTemplate((DataObject)nodeArray[i].getCookie(DataObject.class), dataFolder);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private void createNewTemplate(DataObject dataObject, DataFolder dataFolder) {
        try {
            SaveCookie saveCookie = dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            DataObject dataObject2 = dataObject.copy(dataFolder);
            dataObject2.setTemplate(true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    static final class FolderNodeAcceptor
    implements NodeAcceptor {
        private static FolderNodeAcceptor instance;

        private FolderNodeAcceptor() {
        }

        public final boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            return nodeArray[0].getCookie(DataFolder.class) != null;
        }

        static FolderNodeAcceptor getInstance() {
            if (instance == null) {
                instance = new FolderNodeAcceptor();
            }
            return instance;
        }
    }
}

