/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class LpadRpadPadEmulation
extends AbstractSqmFunctionDescriptor {
    public LpadRpadPadEmulation(TypeConfiguration typeConfiguration) {
        super("pad", new ArgumentTypesValidator(StandardArgumentsValidators.between(3, 4), FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.TRIM_SPEC, FunctionParameterType.STRING), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.TRIM_SPEC, FunctionParameterType.STRING));
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        SqmTrimSpecification padSpec = (SqmTrimSpecification)arguments.get(2);
        String padName = padSpec.getSpecification() == TrimSpec.LEADING ? "lpad" : "rpad";
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor(padName).generateSqmExpression(arguments.size() > 3 ? Arrays.asList(arguments.get(0), arguments.get(1), arguments.get(3)) : Arrays.asList(arguments.get(0), arguments.get(1)), impliedResultType, queryEngine);
    }

    @Override
    public String getArgumentListSignature() {
        return "(STRING string with INTEGER length {leading|trailing}[ STRING character])";
    }
}

