/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;

public final class AlphanumComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AlphanumComparator INSTANCE = new AlphanumComparator();

    public static AlphanumComparator getInstance() {
        return INSTANCE;
    }

    private AlphanumComparator() {
    }

    private static String getChunk(String s, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (Character.isDigit(c)) {
            while (marker < slength && Character.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !Character.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            int result;
            String thisChunk = AlphanumComparator.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = AlphanumComparator.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            if (Character.isDigit(thisChunk.charAt(0)) && Character.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                Collator compareOperator = Collator.getInstance();
                compareOperator.setStrength(1);
                result = compareOperator.compare(thisChunk, thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }
}

