/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.layout.LineStraightenerLayout;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PopupMenuFactory;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AutoLayoutAction;
import ca.sqlpower.architect.swingui.event.ItemSelectionEvent;
import ca.sqlpower.architect.swingui.event.ItemSelectionListener;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RelationalPlayPenFactory {
    private static final Logger logger = Logger.getLogger(RelationalPlayPenFactory.class);

    public static PlayPen createPlayPen(ArchitectSwingSession session, DBTree dbTree) {
        PlayPen pp = new PlayPen(session);
        pp.setPopupFactory(new RelationalPopupFactory(pp, session));
        SelectionSynchronizer synchronizer = new SelectionSynchronizer(dbTree, pp);
        pp.addSelectionListener(synchronizer);
        dbTree.addTreeSelectionListener(synchronizer);
        pp.addMouseListener(synchronizer);
        return pp;
    }

    static void setupKeyboardActions(PlayPen pp, ArchitectSwingSession session) {
        pp.setupKeyboardActions();
        final ArchitectFrame af = session.getArchitectFrame();
        String KEY_DELETE_SELECTED = "ca.sqlpower.architect.swingui.PlayPen.KEY_DELETE_SELECTED";
        InputMap inputMap = pp.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), KEY_DELETE_SELECTED);
        inputMap.put(KeyStroke.getKeyStroke(8, 0), KEY_DELETE_SELECTED);
        pp.getActionMap().put(KEY_DELETE_SELECTED, af.getDeleteSelectedAction());
        if (af.getDeleteSelectedAction() == null) {
            logger.warn((Object)"af.deleteSelectedAction is null!");
        }
        pp.getInputMap(2).put((KeyStroke)af.getZoomToFitAction().getValue("AcceleratorKey"), "ZOOM TO FIT");
        pp.getActionMap().put("ZOOM TO FIT", af.getZoomToFitAction());
        pp.getInputMap(2).put((KeyStroke)af.getZoomInAction().getValue("AcceleratorKey"), "ZOOM IN");
        pp.getActionMap().put("ZOOM IN", af.getZoomInAction());
        pp.getInputMap(2).put((KeyStroke)af.getZoomOutAction().getValue("AcceleratorKey"), "ZOOM OUT");
        pp.getActionMap().put("ZOOM OUT", af.getZoomOutAction());
        pp.getInputMap(2).put((KeyStroke)af.getZoomResetAction().getValue("AcceleratorKey"), "ZOOM RESET");
        pp.getActionMap().put("ZOOM RESET", af.getZoomResetAction());
        pp.getInputMap(2).put((KeyStroke)af.getCreateTableAction().getValue("AcceleratorKey"), "NEW TABLE");
        pp.getActionMap().put("NEW TABLE", af.getCreateTableAction());
        pp.getInputMap(2).put((KeyStroke)af.getInsertColumnAction().getValue("AcceleratorKey"), "NEW COLUMN");
        pp.getActionMap().put("NEW COLUMN", af.getInsertColumnAction());
        pp.getInputMap(2).put((KeyStroke)af.getInsertIndexAction().getValue("AcceleratorKey"), "NEW INDEX");
        pp.getActionMap().put("NEW INDEX", af.getInsertIndexAction());
        pp.getInputMap(2).put((KeyStroke)af.getCreateIdentifyingRelationshipAction().getValue("AcceleratorKey"), "NEW IDENTIFYING RELATION");
        pp.getActionMap().put("NEW IDENTIFYING RELATION", af.getCreateIdentifyingRelationshipAction());
        pp.getInputMap(2).put((KeyStroke)af.getCreateNonIdentifyingRelationshipAction().getValue("AcceleratorKey"), "NEW NON IDENTIFYING RELATION");
        pp.getActionMap().put("NEW NON IDENTIFYING RELATION", af.getCreateNonIdentifyingRelationshipAction());
        String KEY_EDIT_SELECTION = "ca.sqlpower.architect.PlayPen.KEY_EDIT_SELECTION";
        pp.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), KEY_EDIT_SELECTION);
        pp.getActionMap().put(KEY_EDIT_SELECTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent ev = new ActionEvent(e.getSource(), e.getID(), "PlayPen", e.getWhen(), e.getModifiers());
                af.getEditSelectedAction().actionPerformed(ev);
            }
        });
    }

    static class SelectionSynchronizer
    implements SelectionListener,
    ItemSelectionListener<SQLTable, SQLColumn>,
    TreeSelectionListener,
    MouseListener {
        private int eventDepth = 0;
        private final DBTree tree;
        private final PlayPen pp;

        public SelectionSynchronizer(DBTree tree, PlayPen pp) {
            this.tree = tree;
            this.pp = pp;
        }

        public void updateDBTree() {
            if (this.eventDepth != 1) {
                return;
            }
            this.tree.clearSelection();
            ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
            boolean addedPaths = false;
            TreePath lastPath = null;
            for (PlayPenComponent comp : this.pp.getSelectedItems()) {
                TreePath tp = this.tree.getTreePathForNode((SQLObject)comp.getModel());
                if (!selectionPaths.contains(tp)) {
                    selectionPaths.add(tp);
                    addedPaths = true;
                    lastPath = tp;
                }
                if (!(comp instanceof TablePane)) continue;
                for (SQLColumn col : ((TablePane)comp).getSelectedItems()) {
                    tp = this.tree.getTreePathForNode((SQLObject)col);
                    if (selectionPaths.contains(tp)) continue;
                    selectionPaths.add(tp);
                    addedPaths = true;
                    lastPath = tp;
                }
            }
            if (lastPath != null) {
                this.tree.scrollPathToVisible(lastPath);
            }
            this.tree.setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
            if (addedPaths) {
                this.tree.clearNonPlayPenSelections();
            }
        }

        private void selectInPlayPen(TreePath[] treePaths) {
            if (this.eventDepth != 1) {
                return;
            }
            if (treePaths == null) {
                this.pp.selectNone();
            } else {
                ArrayList<Object> objects = new ArrayList<Object>();
                for (TreePath tp : treePaths) {
                    if (this.tree.isTargetDatabaseNode(tp) || !this.tree.isTargetDatabaseChild(tp)) continue;
                    SPObject obj = (SPObject)tp.getLastPathComponent();
                    if ((obj instanceof SQLTable || obj instanceof SQLRelationship || obj instanceof SQLColumn) && !objects.contains(obj)) {
                        objects.add(obj);
                        continue;
                    }
                    if (!(obj instanceof SQLRelationship.SQLImportedKey)) continue;
                    objects.add(((SQLRelationship.SQLImportedKey)obj).getRelationship());
                }
                try {
                    this.pp.selectObjects(objects);
                }
                catch (SQLObjectException e) {
                    throw new SQLObjectRuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemDeselected(SelectionEvent e) {
            if (this.pp.isSelectionInProgress()) {
                return;
            }
            try {
                ++this.eventDepth;
                this.updateDBTree();
            }
            finally {
                --this.eventDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemSelected(SelectionEvent e) {
            if (this.pp.isSelectionInProgress()) {
                return;
            }
            try {
                ++this.eventDepth;
                this.updateDBTree();
            }
            finally {
                --this.eventDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemsDeselected(ItemSelectionEvent<SQLTable, SQLColumn> e) {
            if (this.pp.isSelectionInProgress()) {
                return;
            }
            try {
                ++this.eventDepth;
                this.updateDBTree();
            }
            finally {
                --this.eventDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemsSelected(ItemSelectionEvent<SQLTable, SQLColumn> e) {
            if (this.pp.isSelectionInProgress()) {
                return;
            }
            try {
                ++this.eventDepth;
                this.updateDBTree();
            }
            finally {
                --this.eventDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            try {
                ++this.eventDepth;
                this.selectInPlayPen(((JTree)e.getSource()).getSelectionPaths());
            }
            finally {
                --this.eventDepth;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == this.pp) {
                ++this.eventDepth;
                try {
                    this.updateDBTree();
                }
                finally {
                    --this.eventDepth;
                }
            }
        }
    }

    private static class RelationalPopupFactory
    implements PopupMenuFactory {
        private final PlayPen pp;
        private final ArchitectSwingSession session;

        RelationalPopupFactory(PlayPen pp, ArchitectSwingSession session) {
            this.pp = pp;
            this.session = session;
        }

        @Override
        public JPopupMenu createPopupMenu(Object sourceComponent) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem mi = new JMenuItem();
            mi.setAction(this.session.getArchitectFrame().getCreateTableAction());
            menu.add(mi);
            mi = new JMenuItem();
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/famfamfam/wrench.png"));
            AutoLayoutAction layoutAction = new AutoLayoutAction(this.session, this.session.getPlayPen(), Messages.getString("PlayPen.straightenLinesActionName"), Messages.getString("PlayPen.straightenLinesActionDescription"), (Icon)icon);
            layoutAction.setLayout(new LineStraightenerLayout());
            mi.setAction(layoutAction);
            menu.add(mi);
            if (this.pp.isDebugEnabled()) {
                menu.addSeparator();
                mi = new JMenuItem("Show Relationships");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JOptionPane.showMessageDialog(RelationalPopupFactory.this.pp, new JScrollPane(new JList(new Vector(RelationalPopupFactory.this.pp.getContentPane().getChildren(Relationship.class)))));
                    }
                });
                menu.add(mi);
                mi = new JMenuItem("Show PlayPen Components");
                mi.setActionCommand("PlayPen");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        StringBuffer componentList = new StringBuffer();
                        for (PlayPenComponent playPenComponent : RelationalPopupFactory.this.pp.getContentPane().getChildren()) {
                            componentList.append(playPenComponent).append("[" + playPenComponent.getModel() + "]\n");
                        }
                        JOptionPane.showMessageDialog(RelationalPopupFactory.this.pp, new JScrollPane(new JTextArea(componentList.toString())));
                    }
                });
                menu.add(mi);
                mi = new JMenuItem("Show Undo Vector");
                mi.setActionCommand("PlayPen");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JOptionPane.showMessageDialog(RelationalPopupFactory.this.pp, new JScrollPane(new JTextArea(RelationalPopupFactory.this.session.getUndoManager().printUndoVector())));
                    }
                });
                menu.add(mi);
            }
            return menu;
        }
    }
}

