/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectSessionContext;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.SPServerInfoManager;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.PlDotIni;
import ca.sqlpower.sql.SpecificDataSourceCollection;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class ArchitectSessionContextImpl
implements ArchitectSessionContext {
    private static final Logger logger = Logger.getLogger(ArchitectSessionContextImpl.class);
    private static final String DEFAULT_PATH = "/architect-enterprise";
    private final Preferences prefs = Preferences.userNodeForPackage(ArchitectSessionContextImpl.class);
    private DataSourceCollection<JDBCDataSource> plDotIni;
    private String plDotIniPath;
    private Collection<ArchitectSession> sessions;
    private SPServerInfoManager serverManager;

    public ArchitectSessionContextImpl() throws SQLObjectException, BackingStoreException {
        this((String)null);
    }

    public ArchitectSessionContextImpl(boolean checkPlDotIni) throws SQLObjectException, BackingStoreException {
        this(null, checkPlDotIni);
    }

    public ArchitectSessionContextImpl(String PlDotIniPath) throws SQLObjectException, BackingStoreException {
        this(PlDotIniPath, true);
    }

    public ArchitectSessionContextImpl(String PlDotIniPath, boolean checkPath) throws SQLObjectException, BackingStoreException {
        if (PlDotIniPath == null) {
            PlDotIniPath = this.prefs.get("PL.INI.PATH", null);
        }
        this.setPlDotIniPath(PlDotIniPath);
        if (checkPath) {
            this.setPlDotIniPath(ArchitectUtils.checkForValidPlDotIni(PlDotIniPath, "Architect"));
        }
        this.init();
    }

    public ArchitectSessionContextImpl(DataSourceCollection<JDBCDataSource> dataSources) throws SQLObjectException, BackingStoreException {
        this.plDotIni = dataSources;
        this.init();
    }

    private void init() throws BackingStoreException {
        this.sessions = new HashSet<ArchitectSession>();
        ArchitectUtils.startup();
        ArchitectUtils.configureLog4j();
        SPServerInfo defaultSettings = new SPServerInfo("", "", 8080, DEFAULT_PATH, "", "");
        this.serverManager = new SPServerInfoManager(this.getPrefs().node("servers"), new Version(ArchitectVersion.APP_FULL_VERSION.toString()), defaultSettings);
    }

    @Override
    public ArchitectSession createSession() throws SQLObjectException {
        return this.createSessionImpl("New Project");
    }

    @Override
    public ArchitectSession createSession(InputStream in) throws SQLObjectException, IOException {
        ArchitectSession session = this.createSessionImpl("Loading...");
        session.getProjectLoader().load(in, this.getPlDotIni());
        return session;
    }

    private ArchitectSession createSessionImpl(String projectName) throws SQLObjectException {
        logger.debug((Object)("About to create a new session for project \"" + projectName + "\""));
        ArchitectSessionImpl session = new ArchitectSessionImpl(this, projectName);
        this.sessions.add(session);
        return session;
    }

    @Override
    public Preferences getPrefs() {
        return this.prefs;
    }

    @Override
    public Collection<ArchitectSession> getSessions() {
        return this.sessions;
    }

    @Override
    public DataSourceCollection<JDBCDataSource> getPlDotIni() {
        String path = this.getPlDotIniPath();
        if (path == null && this.plDotIni == null) {
            return null;
        }
        if (this.plDotIni == null) {
            PlDotIni newPlDotIni = new PlDotIni();
            try {
                logger.debug((Object)"Reading PL.INI defaults");
                newPlDotIni.read(this.getClass().getClassLoader().getResourceAsStream("ca/sqlpower/sql/default_database_types.ini"));
            }
            catch (IOException e) {
                throw new SQLObjectRuntimeException(new SQLObjectException("Failed to read system resource default_database_types.ini", (Throwable)e));
            }
            try {
                if (newPlDotIni != null) {
                    logger.debug((Object)"Reading new PL.INI instance");
                    newPlDotIni.read(new File(path));
                }
            }
            catch (IOException e) {
                throw new SQLObjectRuntimeException(new SQLObjectException("Failed to read pl.ini at \"" + this.getPlDotIniPath() + "\"", (Throwable)e));
            }
            this.plDotIni = new SpecificDataSourceCollection((DataSourceCollection)newPlDotIni, JDBCDataSource.class);
        }
        return this.plDotIni;
    }

    @Override
    public String getPlDotIniPath() {
        return this.plDotIniPath;
    }

    @Override
    public void setPlDotIniPath(String plDotIniPath) {
        logger.debug((Object)("PlDotIniPath changing from \"" + this.plDotIniPath + "\" to \"" + plDotIniPath + "\""));
        if (this.plDotIniPath != null && this.plDotIniPath.equals(plDotIniPath)) {
            return;
        }
        this.plDotIniPath = plDotIniPath;
        this.plDotIni = null;
    }

    @Override
    public List<JDBCDataSource> getConnections() {
        return this.getPlDotIni().getConnections();
    }

    @Override
    public SPServerInfoManager getServerManager() {
        return this.serverManager;
    }
}

