/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import java.io.IOException;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> generator) {
        this.generator = generator;
    }

    public boolean writeAsId(JsonGenerator jgen, SerializerProvider provider, ObjectIdWriter w) throws IOException, JsonGenerationException {
        if (this.id != null && (this.idWritten || w.alwaysAsId)) {
            if (jgen.canWriteObjectId()) {
                jgen.writeObjectRef((Object)String.valueOf(this.id));
            } else {
                w.serializer.serialize(this.id, jgen, provider);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object forPojo) {
        this.id = this.generator.generateId(forPojo);
        return this.id;
    }

    public void writeAsField(JsonGenerator jgen, SerializerProvider provider, ObjectIdWriter w) throws IOException, JsonGenerationException {
        this.idWritten = true;
        if (jgen.canWriteObjectId()) {
            jgen.writeObjectId((Object)String.valueOf(this.id));
            return;
        }
        SerializedString name = w.propertyName;
        if (name != null) {
            jgen.writeFieldName((SerializableString)name);
            w.serializer.serialize(this.id, jgen, provider);
        }
    }
}

