/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.libgraal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.jvm.MonitoredData;
import org.graalvm.visualvm.application.jvm.MonitoredDataListener;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.charts.SimpleXYChartSupport;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;

final class MemoryModel {
    private static final Logger LOGGER = Logger.getLogger(MemoryModel.class.getName());
    private static final String PROP_PREFIX = "LibgraalModel_";
    private static final String USAGE_ATTRIBUTE = "Usage";
    private static final String PEAK_USAGE_ATTRIBUTE = "PeakUsage";
    private static final String SNAPSHOT_VERSION = "LibgraalModel_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROP_NOT_DEFINED = "<not defined>";
    private static final String PROP_CHART_CACHE = "LibgraalModel_chart_cache";
    private static final String PROP_HEAP_NAME = "LibgraalModel_heap_name";
    private static final String PROP_HEAP_CAPACITY = "LibgraalModel_heap_capacity";
    private static final String PROP_HEAP_USED = "LibgraalModel_heap_used";
    private static final String PROP_MAX_HEAP = "LibgraalModel_max_heap";
    private static final String CHART_STORAGE = "LibgraalModel_monitor_libgraal.dat";
    private boolean initialized = false;
    private DataSource source;
    private boolean live;
    private final List<ChangeListener> listeners = Collections.synchronizedList(new ArrayList());
    private SimpleXYChartSupport heapChartSupport;
    private MonitoredDataListener monitoredDataListener;
    private Jvm jvm;
    private ObjectName libgraalName;
    private MBeanServerConnection connection;
    private int chartCache = -1;
    private long timestamp = -1L;
    private String heapName;
    private long heapCapacity = -1L;
    private long heapUsed = -1L;
    private long maxHeap = -1L;

    static MemoryModel create(Application application, String name, ObjectName libgraalName) {
        return new MemoryModel((DataSource)application, name, libgraalName);
    }

    static MemoryModel create(DataSource ds, String name) {
        return new MemoryModel(ds, name);
    }

    DataSource getSource() {
        return this.source;
    }

    boolean isLive() {
        return this.live;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    int getChartCache() {
        return this.chartCache;
    }

    String getHeapName() {
        return this.heapName;
    }

    long getHeapCapacity() {
        return this.heapCapacity;
    }

    long getHeapUsed() {
        return this.heapUsed;
    }

    long getMaxHeap() {
        return this.maxHeap;
    }

    synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.source instanceof Application) {
            this.initialize((Application)this.source);
        } else {
            this.initialize((Snapshot)this.source);
        }
    }

    void registerHeapChartSupport(final SimpleXYChartSupport heapChartSupport) {
        this.heapChartSupport = heapChartSupport;
        if (heapChartSupport != null && this.source instanceof Snapshot) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    File file = new File(MemoryModel.this.source.getStorage().getDirectory(), MemoryModel.CHART_STORAGE);
                    if (file.isFile() && file.canRead()) {
                        MemoryModel.loadChartSupport(heapChartSupport, file);
                    }
                }
            });
        }
    }

    synchronized void cleanup() {
        this.listeners.clear();
        if (!this.initialized) {
            return;
        }
        if (this.jvm != null && this.monitoredDataListener != null) {
            this.jvm.removeMonitoredDataListener(this.monitoredDataListener);
        }
        this.connection = null;
    }

    void addChangeListener(ChangeListener listener) {
        if (this.live) {
            this.listeners.add(listener);
        }
    }

    void removeChangeListener(ChangeListener listener) {
        if (this.live) {
            this.listeners.remove(listener);
        }
    }

    void save(Snapshot snapshot) {
        this.initialize();
        Storage storage = snapshot.getStorage();
        MemoryModel.setProperty(storage, SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        MemoryModel.setProperty(storage, PROP_CHART_CACHE, Integer.toString(this.chartCache));
        MemoryModel.setProperty(storage, PROP_HEAP_NAME, this.heapName);
        MemoryModel.setProperty(storage, PROP_HEAP_CAPACITY, Long.toString(this.heapCapacity));
        MemoryModel.setProperty(storage, PROP_HEAP_USED, Long.toString(this.heapUsed));
        MemoryModel.setProperty(storage, PROP_MAX_HEAP, Long.toString(this.maxHeap));
        File dir = storage.getDirectory();
        MemoryModel.saveChartSupport(this.heapChartSupport, new File(dir, CHART_STORAGE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveChartSupport(SimpleXYChartSupport chartSupport, File file) {
        if (chartSupport == null) {
            return;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            chartSupport.saveValues((OutputStream)os);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "saveChartSupport", e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "saveChartSupport", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadChartSupport(SimpleXYChartSupport chartSupport, File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            chartSupport.loadValues((InputStream)is);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "loadChartSupport", e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "loadChartSupport", e);
            }
        }
    }

    private void initialize(Snapshot snapshot) {
        Storage storage = snapshot.getStorage();
        String version = MemoryModel.getProperty(storage, SNAPSHOT_VERSION);
        this.heapName = MemoryModel.getProperty(storage, PROP_HEAP_NAME);
        this.chartCache = Integer.parseInt(MemoryModel.getProperty(storage, PROP_CHART_CACHE));
        this.heapCapacity = Long.parseLong(MemoryModel.getProperty(storage, PROP_HEAP_CAPACITY));
        this.heapUsed = Long.parseLong(MemoryModel.getProperty(storage, PROP_HEAP_USED));
        this.maxHeap = Long.parseLong(MemoryModel.getProperty(storage, PROP_MAX_HEAP));
    }

    private static void setProperty(Storage storage, String property, String value) {
        storage.setCustomProperty(property, value == null ? PROP_NOT_DEFINED : value);
    }

    private static String getProperty(Storage storage, String property) {
        String value = storage.getCustomProperty(property);
        return PROP_NOT_DEFINED.equals(value) ? null : value;
    }

    private void initialize(Application application) {
        GlobalPreferences preferences = GlobalPreferences.sharedInstance();
        this.chartCache = preferences.getMonitoredDataCache() * 60 / preferences.getMonitoredDataPoll();
        this.jvm = JvmFactory.getJVMFor((Application)application);
        this.connection = MemoryModel.getConnection(application);
        if (this.connection != null) {
            this.updateValues(System.currentTimeMillis(), this.getData());
            if (this.live) {
                this.monitoredDataListener = new MonitoredDataListener(){
                    long lastTimestamp = -1L;

                    public void monitoredDataEvent(MonitoredData data) {
                        long timestamp = System.currentTimeMillis();
                        final long timestampF = this.lastTimestamp < timestamp ? (this.lastTimestamp = timestamp) : (this.lastTimestamp = this.lastTimestamp + 1L);
                        final Object[] values = MemoryModel.this.getData();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MemoryModel.this.updateValues(timestampF, values);
                                MemoryModel.this.fireChange();
                            }
                        });
                    }
                };
                this.jvm.addMonitoredDataListener(this.monitoredDataListener);
            }
        }
    }

    private Object[] getAttributes(String ... names) {
        try {
            List<Attribute> attrs = this.connection.getAttributes(this.libgraalName, names).asList();
            Object[] values = new Object[attrs.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = attrs.get(i).getValue();
            }
            return values;
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "getAttributes", ex);
            return null;
        }
    }

    private Object[] getData() {
        if (this.live && this.connection != null) {
            Object[] values = this.getAttributes(USAGE_ATTRIBUTE, PEAK_USAGE_ATTRIBUTE);
            if (values == null) {
                this.connection = null;
            }
            return values;
        }
        return null;
    }

    private void updateValues(long time, Object[] values) {
        if (values != null) {
            CompositeData usageData = (CompositeData)values[0];
            CompositeData peakData = (CompositeData)values[1];
            if (usageData != null && peakData != null) {
                MemoryUsage mem = MemoryUsage.from(usageData);
                MemoryUsage peak = MemoryUsage.from(peakData);
                this.heapUsed = mem.getUsed();
                this.heapCapacity = peak.getUsed();
                this.maxHeap = mem.getMax();
                this.timestamp = time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> list = new ArrayList<ChangeListener>();
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            list.addAll(this.listeners);
        }
        for (ChangeListener l : list) {
            l.stateChanged(new ChangeEvent(this));
        }
    }

    private MemoryModel() {
    }

    private MemoryModel(DataSource src, String name) {
        this();
        this.source = src;
        this.heapName = name;
        this.live = false;
    }

    private MemoryModel(DataSource src, String name, ObjectName mbeanName) {
        this(src, name);
        this.live = true;
        this.libgraalName = mbeanName;
    }

    private static MBeanServerConnection getConnection(Application app) {
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
        if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            return jmxModel.getMBeanServerConnection();
        }
        return null;
    }

    static boolean isInStapshot(ApplicationSnapshot snapshot) {
        String version = MemoryModel.getProperty(snapshot.getStorage(), SNAPSHOT_VERSION);
        return version != null;
    }
}

