/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.cli.InputHandler;
import org.apache.fop.tools.anttasks.FileCompare;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestConverter {
    private FopFactory fopFactory = FopFactory.newInstance();
    private boolean failOnly = false;
    private String outputFormat = "application/X-fop-areatree";
    private File destdir;
    private File compare = null;
    private String baseDir = "./";
    private Map differ = new HashMap();
    protected SimpleLog logger = new SimpleLog("FOP/Test");

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("test suite file name required");
        }
        TestConverter tc = new TestConverter();
        String results = "results";
        String testFile = null;
        for (int count = 0; count < args.length; ++count) {
            if (args[count].equals("-failOnly")) {
                tc.setFailOnly(true);
                continue;
            }
            if (args[count].equals("-pdf")) {
                tc.setOutputFormat("application/pdf");
                continue;
            }
            if (args[count].equals("-rtf")) {
                tc.setOutputFormat("application/rtf");
                continue;
            }
            if (args[count].equals("-ps")) {
                tc.setOutputFormat("application/postscript");
                continue;
            }
            if (args[count].equals("-d")) {
                tc.setDebug(true);
                continue;
            }
            if (args[count].equals("-b")) {
                tc.setBaseDir(args[++count]);
                continue;
            }
            if (args[count].equals("-results")) {
                results = args[++count];
                continue;
            }
            testFile = args[count];
        }
        if (testFile == null) {
            System.out.println("test suite file name required");
        }
        tc.runTests(testFile, results, null);
    }

    public TestConverter() {
        this.logger.setLevel(5);
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setFailOnly(boolean fail) {
        this.failOnly = fail;
    }

    public void setBaseDir(String str) {
        this.baseDir = str;
    }

    public void setDebug(boolean debug) {
        if (debug) {
            this.logger.setLevel(2);
        } else {
            this.logger.setLevel(5);
        }
    }

    public Map runTests(String fname, String dest, String compDir) {
        this.logger.debug((Object)("running tests in file:" + fname));
        try {
            if (compDir != null) {
                this.compare = new File(this.baseDir + "/" + compDir);
            }
            this.destdir = new File(this.baseDir + "/" + dest);
            this.destdir.mkdirs();
            File f = new File(this.baseDir + "/" + fname);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(f);
            NodeList suitelist = doc.getChildNodes();
            if (suitelist.getLength() == 0) {
                return this.differ;
            }
            Element testsuite = null;
            testsuite = doc.getDocumentElement();
            if (testsuite.hasAttributes()) {
                String profile = testsuite.getAttributes().getNamedItem("profile").getNodeValue();
                this.logger.debug((Object)("testing test suite:" + profile));
            }
            NodeList testcases = testsuite.getChildNodes();
            for (int count = 0; count < testcases.getLength(); ++count) {
                Node testcase = testcases.item(count);
                if (!testcase.getNodeName().equals("testcases")) continue;
                this.runTestCase(testcase);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while running tests", (Throwable)e);
        }
        return this.differ;
    }

    protected void runTestCase(Node tcase) {
        if (tcase.hasAttributes()) {
            String profile = tcase.getAttributes().getNamedItem("profile").getNodeValue();
            this.logger.debug((Object)("testing profile:" + profile));
        }
        NodeList cases = tcase.getChildNodes();
        for (int count = 0; count < cases.getLength(); ++count) {
            Node node = cases.item(count);
            String nodename = node.getNodeName();
            if (nodename.equals("testcases")) {
                this.runTestCase(node);
                continue;
            }
            if (nodename.equals("test")) {
                this.runTest(tcase, node);
                continue;
            }
            if (!nodename.equals("result")) continue;
        }
    }

    protected void runTest(Node testcase, Node test) {
        String id = test.getAttributes().getNamedItem("id").getNodeValue();
        Node result = this.locateResult(testcase, id);
        boolean pass = false;
        if (result != null) {
            String agreement = result.getAttributes().getNamedItem("agreement").getNodeValue();
            pass = agreement.equals("full");
        }
        if (pass && this.failOnly) {
            return;
        }
        String xml = test.getAttributes().getNamedItem("xml").getNodeValue();
        Node xslNode = test.getAttributes().getNamedItem("xsl");
        String xsl = null;
        if (xslNode != null) {
            xsl = xslNode.getNodeValue();
        }
        this.logger.debug((Object)("converting xml:" + xml + " and xsl:" + xsl + " to area tree"));
        String res = xml;
        Node resNode = test.getAttributes().getNamedItem("results");
        if (resNode != null) {
            res = resNode.getNodeValue();
        }
        try {
            File f2;
            File f1;
            File xmlFile = new File(this.baseDir + "/" + xml);
            String baseURL = null;
            try {
                baseURL = xmlFile.getParentFile().toURL().toExternalForm();
            }
            catch (Exception e) {
                this.logger.error((Object)"Error setting base directory");
            }
            InputHandler inputHandler = null;
            inputHandler = xsl == null ? new InputHandler(xmlFile) : new InputHandler(xmlFile, new File(this.baseDir + "/" + xsl), null);
            FOUserAgent userAgent = this.fopFactory.newFOUserAgent();
            userAgent.setBaseURL(baseURL);
            userAgent.getRendererOptions().put("fineDetail", new Boolean(false));
            userAgent.getRendererOptions().put("consistentOutput", new Boolean(true));
            userAgent.setProducer("Testsuite Converter");
            String outname = res;
            if (outname.endsWith(".xml") || outname.endsWith(".pdf")) {
                outname = outname.substring(0, outname.length() - 4);
            }
            File outputFile = new File(this.destdir, outname + this.makeResultExtension());
            outputFile.getParentFile().mkdirs();
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            this.logger.debug((Object)("ddir:" + this.destdir + " on:" + outputFile.getName()));
            inputHandler.renderTo(userAgent, this.outputFormat, outStream);
            ((OutputStream)outStream).close();
            if (this.compare != null && !this.compareFiles(f1 = new File(this.destdir, outname + ".at.xml"), f2 = new File(this.compare, outname + ".at.xml"))) {
                this.differ.put(outname + ".at.xml", new Boolean(pass));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while running tests", (Throwable)e);
        }
    }

    private String makeResultExtension() {
        if ("application/pdf".equals(this.outputFormat)) {
            return ".pdf";
        }
        if ("application/rtf".equals(this.outputFormat)) {
            return ".rtf";
        }
        if ("application/postscript".equals(this.outputFormat)) {
            return ".ps";
        }
        return ".at.xml";
    }

    protected boolean compareFiles(File f1, File f2) {
        try {
            return FileCompare.compareFiles(f1, f2);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while comparing files", (Throwable)e);
            return false;
        }
    }

    private Node locateResult(Node testcase, String id) {
        NodeList cases = testcase.getChildNodes();
        for (int count = 0; count < cases.getLength(); ++count) {
            String resultid;
            Node node = cases.item(count);
            String nodename = node.getNodeName();
            if (!nodename.equals("result") || !id.equals(resultid = node.getAttributes().getNamedItem("id").getNodeValue())) continue;
            return node;
        }
        return null;
    }
}

