/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMeshMorphKey")
public class AIMeshMorphKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUES;
    public static final int MWEIGHTS;
    public static final int MNUMVALUESANDWEIGHTS;

    public AIMeshMorphKey(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMeshMorphKey.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIMeshMorphKey.nmTime(this.address());
    }

    @NativeType(value="unsigned int *")
    public IntBuffer mValues() {
        return AIMeshMorphKey.nmValues(this.address());
    }

    @NativeType(value="double *")
    public DoubleBuffer mWeights() {
        return AIMeshMorphKey.nmWeights(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumValuesAndWeights() {
        return AIMeshMorphKey.nmNumValuesAndWeights(this.address());
    }

    public AIMeshMorphKey mTime(double value) {
        AIMeshMorphKey.nmTime(this.address(), value);
        return this;
    }

    public AIMeshMorphKey mValues(@NativeType(value="unsigned int *") IntBuffer value) {
        AIMeshMorphKey.nmValues(this.address(), value);
        return this;
    }

    public AIMeshMorphKey mWeights(@NativeType(value="double *") DoubleBuffer value) {
        AIMeshMorphKey.nmWeights(this.address(), value);
        return this;
    }

    public AIMeshMorphKey mNumValuesAndWeights(@NativeType(value="unsigned int") int value) {
        AIMeshMorphKey.nmNumValuesAndWeights(this.address(), value);
        return this;
    }

    public AIMeshMorphKey set(double mTime, IntBuffer mValues, DoubleBuffer mWeights, int mNumValuesAndWeights) {
        this.mTime(mTime);
        this.mValues(mValues);
        this.mWeights(mWeights);
        this.mNumValuesAndWeights(mNumValuesAndWeights);
        return this;
    }

    public AIMeshMorphKey set(AIMeshMorphKey src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIMeshMorphKey malloc() {
        return (AIMeshMorphKey)AIMeshMorphKey.wrap(AIMeshMorphKey.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIMeshMorphKey calloc() {
        return (AIMeshMorphKey)AIMeshMorphKey.wrap(AIMeshMorphKey.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIMeshMorphKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIMeshMorphKey)AIMeshMorphKey.wrap(AIMeshMorphKey.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIMeshMorphKey create(long address) {
        return (AIMeshMorphKey)AIMeshMorphKey.wrap(AIMeshMorphKey.class, (long)address);
    }

    @Nullable
    public static AIMeshMorphKey createSafe(long address) {
        return address == 0L ? null : (AIMeshMorphKey)AIMeshMorphKey.wrap(AIMeshMorphKey.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIMeshMorphKey.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIMeshMorphKey.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIMeshMorphKey.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMeshMorphKey.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIMeshMorphKey.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIMeshMorphKey.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIMeshMorphKey.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static AIMeshMorphKey mallocStack() {
        return AIMeshMorphKey.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMeshMorphKey callocStack() {
        return AIMeshMorphKey.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMeshMorphKey mallocStack(MemoryStack stack) {
        return AIMeshMorphKey.malloc(stack);
    }

    @Deprecated
    public static AIMeshMorphKey callocStack(MemoryStack stack) {
        return AIMeshMorphKey.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMeshMorphKey.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMeshMorphKey.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMeshMorphKey.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMeshMorphKey.calloc(capacity, stack);
    }

    public static AIMeshMorphKey malloc(MemoryStack stack) {
        return (AIMeshMorphKey)AIMeshMorphKey.wrap(AIMeshMorphKey.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMeshMorphKey calloc(MemoryStack stack) {
        return (AIMeshMorphKey)AIMeshMorphKey.wrap(AIMeshMorphKey.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)AIMeshMorphKey.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)AIMeshMorphKey.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static double nmTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MTIME);
    }

    public static IntBuffer nmValues(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MVALUES)), (int)AIMeshMorphKey.nmNumValuesAndWeights(struct));
    }

    public static DoubleBuffer nmWeights(long struct) {
        return MemoryUtil.memDoubleBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)), (int)AIMeshMorphKey.nmNumValuesAndWeights(struct));
    }

    public static int nmNumValuesAndWeights(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMVALUESANDWEIGHTS);
    }

    public static void nmTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MTIME, value);
    }

    public static void nmValues(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MVALUES), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nmWeights(long struct, DoubleBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MWEIGHTS), (long)MemoryUtil.memAddress((DoubleBuffer)value));
    }

    public static void nmNumValuesAndWeights(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMVALUESANDWEIGHTS, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MVALUES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)));
    }

    static {
        Struct.Layout layout = AIMeshMorphKey.__struct((Struct.Member[])new Struct.Member[]{AIMeshMorphKey.__member((int)8), AIMeshMorphKey.__member((int)POINTER_SIZE), AIMeshMorphKey.__member((int)POINTER_SIZE), AIMeshMorphKey.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUES = layout.offsetof(1);
        MWEIGHTS = layout.offsetof(2);
        MNUMVALUESANDWEIGHTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIMeshMorphKey, Buffer>
    implements NativeResource {
        private static final AIMeshMorphKey ELEMENT_FACTORY = AIMeshMorphKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMeshMorphKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIMeshMorphKey.nmTime(this.address());
        }

        @NativeType(value="unsigned int *")
        public IntBuffer mValues() {
            return AIMeshMorphKey.nmValues(this.address());
        }

        @NativeType(value="double *")
        public DoubleBuffer mWeights() {
            return AIMeshMorphKey.nmWeights(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumValuesAndWeights() {
            return AIMeshMorphKey.nmNumValuesAndWeights(this.address());
        }

        public Buffer mTime(double value) {
            AIMeshMorphKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValues(@NativeType(value="unsigned int *") IntBuffer value) {
            AIMeshMorphKey.nmValues(this.address(), value);
            return this;
        }

        public Buffer mWeights(@NativeType(value="double *") DoubleBuffer value) {
            AIMeshMorphKey.nmWeights(this.address(), value);
            return this;
        }

        public Buffer mNumValuesAndWeights(@NativeType(value="unsigned int") int value) {
            AIMeshMorphKey.nmNumValuesAndWeights(this.address(), value);
            return this;
        }
    }
}

