/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITEvaluatedSymbol;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMJITCSymbolMapPair
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SYM;

    public LLVMJITCSymbolMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMJITCSymbolMapPair.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMJITCSymbolMapPair.nName(this.address());
    }

    public LLVMJITEvaluatedSymbol Sym() {
        return LLVMJITCSymbolMapPair.nSym(this.address());
    }

    public LLVMJITCSymbolMapPair Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMJITCSymbolMapPair.nName(this.address(), value);
        return this;
    }

    public LLVMJITCSymbolMapPair Sym(LLVMJITEvaluatedSymbol value) {
        LLVMJITCSymbolMapPair.nSym(this.address(), value);
        return this;
    }

    public LLVMJITCSymbolMapPair Sym(Consumer<LLVMJITEvaluatedSymbol> consumer) {
        consumer.accept(this.Sym());
        return this;
    }

    public LLVMJITCSymbolMapPair set(long Name, LLVMJITEvaluatedSymbol Sym) {
        this.Name(Name);
        this.Sym(Sym);
        return this;
    }

    public LLVMJITCSymbolMapPair set(LLVMJITCSymbolMapPair src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMJITCSymbolMapPair malloc() {
        return (LLVMJITCSymbolMapPair)LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LLVMJITCSymbolMapPair calloc() {
        return (LLVMJITCSymbolMapPair)LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LLVMJITCSymbolMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LLVMJITCSymbolMapPair)LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LLVMJITCSymbolMapPair create(long address) {
        return (LLVMJITCSymbolMapPair)LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, (long)address);
    }

    @Nullable
    public static LLVMJITCSymbolMapPair createSafe(long address) {
        return address == 0L ? null : (LLVMJITCSymbolMapPair)LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LLVMJITCSymbolMapPair.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LLVMJITCSymbolMapPair.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LLVMJITCSymbolMapPair.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMJITCSymbolMapPair.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LLVMJITCSymbolMapPair.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMJITCSymbolMapPair.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMJITCSymbolMapPair.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMJITCSymbolMapPair malloc(MemoryStack stack) {
        return (LLVMJITCSymbolMapPair)LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMJITCSymbolMapPair calloc(MemoryStack stack) {
        return (LLVMJITCSymbolMapPair)LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMJITCSymbolMapPair.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMJITCSymbolMapPair.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NAME));
    }

    public static LLVMJITEvaluatedSymbol nSym(long struct) {
        return LLVMJITEvaluatedSymbol.create(struct + (long)SYM);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)Checks.check((long)value));
    }

    public static void nSym(long struct, LLVMJITEvaluatedSymbol value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SYM), (long)LLVMJITEvaluatedSymbol.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    static {
        Struct.Layout layout = LLVMJITCSymbolMapPair.__struct((Struct.Member[])new Struct.Member[]{LLVMJITCSymbolMapPair.__member((int)POINTER_SIZE), LLVMJITCSymbolMapPair.__member((int)LLVMJITEvaluatedSymbol.SIZEOF, (int)LLVMJITEvaluatedSymbol.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SYM = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMJITCSymbolMapPair, Buffer>
    implements NativeResource {
        private static final LLVMJITCSymbolMapPair ELEMENT_FACTORY = LLVMJITCSymbolMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMJITCSymbolMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMJITCSymbolMapPair.nName(this.address());
        }

        public LLVMJITEvaluatedSymbol Sym() {
            return LLVMJITCSymbolMapPair.nSym(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMJITCSymbolMapPair.nName(this.address(), value);
            return this;
        }

        public Buffer Sym(LLVMJITEvaluatedSymbol value) {
            LLVMJITCSymbolMapPair.nSym(this.address(), value);
            return this;
        }

        public Buffer Sym(Consumer<LLVMJITEvaluatedSymbol> consumer) {
            consumer.accept(this.Sym());
            return this;
        }
    }
}

