/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileProvider;

public abstract class AbstractUserProfileBean {
    private static final Comparator<Attribute> ATTRIBUTE_COMPARATOR = (a1, a2) -> {
        AttributeGroup g1 = a1.getGroup();
        AttributeGroup g2 = a2.getGroup();
        if (g1 == null && g2 == null) {
            return a1.compareTo((Attribute)a2);
        }
        if (g1 != null && g1.equals(g2)) {
            return a1.compareTo((Attribute)a2);
        }
        return Comparator.nullsFirst(AttributeGroup::compareTo).compare(g1, g2);
    };
    protected final MultivaluedMap<String, String> formData;
    protected UserProfile profile;
    protected List<Attribute> attributes;
    protected Map<String, Attribute> attributesByName;

    public AbstractUserProfileBean(MultivaluedMap<String, String> formData) {
        this.formData = formData;
    }

    protected void init(KeycloakSession session, boolean writeableOnly) {
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        this.profile = this.createUserProfile(provider);
        this.attributes = this.toAttributes(this.profile.getAttributes().getReadable(), writeableOnly);
        if (this.attributes != null) {
            this.attributesByName = this.attributes.stream().collect(Collectors.toMap(a -> a.getName(), a -> a));
        }
    }

    protected abstract UserProfile createUserProfile(UserProfileProvider var1);

    protected abstract Stream<String> getAttributeDefaultValues(String var1);

    public abstract String getContext();

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getHtml5DataAnnotations() {
        return this.getAttributes().stream().map(Attribute::getHtml5DataAnnotations).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, r) -> l));
    }

    public Map<String, Attribute> getAttributesByName() {
        return this.attributesByName;
    }

    private List<Attribute> toAttributes(Map<String, List<String>> attributes, boolean writeableOnly) {
        if (attributes == null) {
            return null;
        }
        Attributes profileAttributes = this.profile.getAttributes();
        return attributes.keySet().stream().map(arg_0 -> ((Attributes)profileAttributes).getMetadata(arg_0)).filter(Objects::nonNull).filter(am -> writeableOnly ? !profileAttributes.isReadOnly(am.getName()) : true).filter(am -> !profileAttributes.getUnmanagedAttributes().containsKey(am.getName())).map(x$0 -> new Attribute((AttributeMetadata)x$0)).sorted(ATTRIBUTE_COMPARATOR).collect(Collectors.toList());
    }

    public class Attribute
    implements Comparable<Attribute> {
        private final AttributeMetadata metadata;

        public Attribute(AttributeMetadata metadata) {
            this.metadata = metadata;
        }

        public String getName() {
            return this.metadata.getName();
        }

        public String getDisplayName() {
            return this.metadata.getAttributeDisplayName();
        }

        public boolean isMultivalued() {
            return this.metadata.isMultivalued();
        }

        public String getValue() {
            List<String> v = this.getValues();
            if (v == null || v.isEmpty()) {
                return null;
            }
            return v.get(0);
        }

        public List<String> getValues() {
            List v;
            List list = v = AbstractUserProfileBean.this.formData != null ? (List)AbstractUserProfileBean.this.formData.get((Object)this.getName()) : null;
            if (v == null || v.isEmpty()) {
                Stream<String> vs = AbstractUserProfileBean.this.getAttributeDefaultValues(this.getName());
                if (vs == null) {
                    return Collections.emptyList();
                }
                return vs.collect(Collectors.toList());
            }
            return v;
        }

        public boolean isRequired() {
            return AbstractUserProfileBean.this.profile.getAttributes().isRequired(this.getName());
        }

        public boolean isReadOnly() {
            return AbstractUserProfileBean.this.profile.getAttributes().isReadOnly(this.getName());
        }

        public String getAutocomplete() {
            if (this.getName().equals("email") || this.getName().equals("username")) {
                return this.getName();
            }
            return null;
        }

        public Map<String, Object> getAnnotations() {
            Map annotations = this.metadata.getAnnotations();
            if (annotations == null) {
                return Collections.emptyMap();
            }
            return annotations;
        }

        public Map<String, Object> getHtml5DataAnnotations() {
            Map groupAnnotations = Optional.ofNullable(this.getGroup()).map(AttributeGroup::getAnnotations).orElse(Map.of());
            Map<String, Object> annotations = Stream.concat(this.getAnnotations().entrySet().stream(), groupAnnotations.entrySet().stream()).filter(entry -> ((String)entry.getKey()).startsWith("kc")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (this.isMultivalued()) {
                annotations = new HashMap<String, Object>(annotations);
                annotations.put("kcMultivalued", "");
            }
            return annotations;
        }

        public Map<String, Map<String, Object>> getValidators() {
            if (this.metadata.getValidators() == null) {
                return Collections.emptyMap();
            }
            return this.metadata.getValidators().stream().collect(Collectors.toMap(AttributeValidatorMetadata::getValidatorId, AttributeValidatorMetadata::getValidatorConfig));
        }

        public AttributeGroup getGroup() {
            AttributeGroupMetadata groupMetadata = this.metadata.getAttributeGroupMetadata();
            if (groupMetadata != null) {
                return new AttributeGroup(groupMetadata);
            }
            return null;
        }

        @Override
        public int compareTo(Attribute o) {
            return Integer.compare(this.metadata.getGuiOrder(), o.metadata.getGuiOrder());
        }
    }

    public class AttributeGroup
    implements Comparable<AttributeGroup> {
        private AttributeGroupMetadata metadata;

        AttributeGroup(AttributeGroupMetadata metadata) {
            this.metadata = metadata;
        }

        public String getName() {
            return this.metadata.getName();
        }

        public String getDisplayHeader() {
            return Optional.ofNullable(this.metadata.getDisplayHeader()).orElse(this.getName());
        }

        public String getDisplayDescription() {
            return this.metadata.getDisplayDescription();
        }

        public Map<String, Object> getAnnotations() {
            return Optional.ofNullable(this.metadata.getAnnotations()).orElse(Map.of());
        }

        public Map<String, Object> getHtml5DataAnnotations() {
            return this.getAnnotations().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("kc")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeGroup that = (AttributeGroup)o;
            return Objects.equals(this.metadata.getName(), that.metadata.getName());
        }

        public int hashCode() {
            return Objects.hash(this.metadata);
        }

        public String toString() {
            return this.metadata.getName();
        }

        @Override
        public int compareTo(AttributeGroup o) {
            return this.getDisplayHeader().compareTo(o.getDisplayHeader());
        }
    }
}

