/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership.group;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapperConfig;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.group.GroupMapperConfig;
import org.keycloak.storage.ldap.mappers.membership.group.GroupTreeResolver;
import org.keycloak.storage.user.SynchronizationResult;

public class GroupLDAPStorageMapper
extends AbstractLDAPStorageMapper
implements CommonLDAPGroupMapper {
    private static final Logger logger = Logger.getLogger(GroupLDAPStorageMapper.class);
    private final GroupMapperConfig config;
    private final GroupLDAPStorageMapperFactory factory;
    private boolean syncFromLDAPPerformedInThisTransaction = false;

    public GroupLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, GroupLDAPStorageMapperFactory factory) {
        super(mapperModel, ldapProvider);
        this.config = new GroupMapperConfig(mapperModel);
        this.factory = factory;
    }

    @Override
    public LDAPQuery createLDAPGroupQuery() {
        return this.createGroupQuery(false);
    }

    @Override
    public CommonLDAPGroupMapperConfig getConfig() {
        return this.config;
    }

    public LDAPQuery createGroupQuery(boolean includeMemberAttribute) {
        LDAPQuery ldapQuery = new LDAPQuery(this.ldapProvider);
        ldapQuery.setSearchScope(this.ldapProvider.getLdapIdentityStore().getConfig().getSearchScope());
        String groupsDn = this.config.getGroupsDn();
        ldapQuery.setSearchDn(groupsDn);
        Collection<String> groupObjectClasses = this.config.getGroupObjectClasses(this.ldapProvider);
        ldapQuery.addObjectClasses(groupObjectClasses);
        String customFilter = this.config.getCustomLdapFilter();
        if (customFilter != null && customFilter.trim().length() > 0) {
            Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilter);
            ldapQuery.addWhereCondition(customFilterCondition);
        }
        ldapQuery.addReturningLdapAttribute(this.config.getGroupNameLdapAttribute());
        if (includeMemberAttribute) {
            ldapQuery.addReturningLdapAttribute(this.config.getMembershipLdapAttribute());
        }
        for (String groupAttr : this.config.getGroupAttributes()) {
            ldapQuery.addReturningLdapAttribute(groupAttr);
        }
        return ldapQuery;
    }

    public LDAPObject createLDAPGroup(String groupName, Map<String, Set<String>> additionalAttributes) {
        LDAPObject ldapGroup = LDAPUtils.createLDAPGroup(this.ldapProvider, groupName, this.config.getGroupNameLdapAttribute(), this.config.getGroupObjectClasses(this.ldapProvider), this.config.getGroupsDn(), additionalAttributes, this.config.getMembershipLdapAttribute());
        logger.debugf("Creating group [%s] to LDAP with DN [%s]", (Object)groupName, (Object)ldapGroup.getDn().toString());
        return ldapGroup;
    }

    public LDAPObject loadLDAPGroupByName(String groupName) {
        try (LDAPQuery ldapQuery = this.createGroupQuery(true);){
            Condition roleNameCondition = new LDAPQueryConditionsBuilder().equal(this.config.getGroupNameLdapAttribute(), groupName);
            ldapQuery.addWhereCondition(roleNameCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    public LDAPObject updateLDAPGroup(LDAPObject ldapObject) {
        LDAPObject ldapGroup = LDAPUtils.updateLDAPGroup(this.ldapProvider, ldapObject);
        return ldapGroup;
    }

    protected Set<LDAPDn> getLDAPSubgroups(LDAPObject ldapGroup) {
        MembershipType membershipType = this.config.getMembershipTypeLdapAttribute();
        return membershipType.getLDAPSubgroups(this, ldapGroup);
    }

    @Override
    public SynchronizationResult syncDataFromFederationProviderToKeycloak(RealmModel realm) {
        SynchronizationResult syncResult = new SynchronizationResult(){

            public String getStatus() {
                return String.format("%d imported groups, %d updated groups, %d removed groups", this.getAdded(), this.getUpdated(), this.getRemoved());
            }
        };
        logger.debugf("Syncing groups from LDAP into Keycloak DB. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getName());
        List<LDAPObject> ldapGroups = this.getAllLDAPGroups(this.config.isPreserveGroupsInheritance());
        HashMap<String, LDAPObject> ldapGroupsMap = new HashMap<String, LDAPObject>();
        LinkedList<GroupTreeResolver.Group> ldapGroupsRep = new LinkedList<GroupTreeResolver.Group>();
        this.convertGroupsToInternalRep(ldapGroups, ldapGroupsMap, ldapGroupsRep);
        if (this.config.isPreserveGroupsInheritance()) {
            try {
                List<GroupTreeResolver.GroupTreeEntry> groupTrees = new GroupTreeResolver().resolveGroupTree(ldapGroupsRep, this.config.isIgnoreMissingGroups());
                this.updateKeycloakGroupTree(realm, groupTrees, ldapGroupsMap, syncResult);
            }
            catch (GroupTreeResolver.GroupTreeResolveException gre) {
                throw new ModelException("Couldn't resolve groups from LDAP. Fix LDAP or skip preserve inheritance. Details: " + gre.getMessage(), (Throwable)gre);
            }
        } else {
            this.syncFlatGroupStructure(realm, syncResult, ldapGroupsMap);
        }
        this.syncFromLDAPPerformedInThisTransaction = true;
        return syncResult;
    }

    private void syncExistingGroup(RealmModel realm, GroupModel kcExistingGroup, Map.Entry<String, LDAPObject> groupEntry, SynchronizationResult syncResult, Set<String> visitedGroupIds, String groupName) {
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.ldapProvider.getSession().getKeycloakSessionFactory(), session -> {
                RealmModel innerTransactionRealm = session.realms().getRealm(realm.getId());
                GroupModel innerTransactionGroup = session.groups().getGroupById(innerTransactionRealm, kcExistingGroup.getId());
                this.updateAttributesOfKCGroup(innerTransactionGroup, (LDAPObject)groupEntry.getValue());
                syncResult.increaseUpdated();
                visitedGroupIds.add(kcExistingGroup.getId());
            });
        }
        catch (ModelException me) {
            logger.error((Object)String.format("Failed to update attributes of LDAP group %s: ", groupName), (Throwable)me);
            syncResult.increaseFailed();
        }
    }

    private void syncNonExistingGroup(RealmModel realm, Map.Entry<String, LDAPObject> groupEntry, SynchronizationResult syncResult, Set<String> visitedGroupIds, String groupName) {
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.ldapProvider.getSession().getKeycloakSessionFactory(), session -> {
                RealmModel innerTransactionRealm = session.realms().getRealm(realm.getId());
                GroupModel kcGroup = this.createKcGroup(innerTransactionRealm, groupName, null);
                this.updateAttributesOfKCGroup(kcGroup, (LDAPObject)groupEntry.getValue());
                syncResult.increaseAdded();
                visitedGroupIds.add(kcGroup.getId());
            });
        }
        catch (ModelException me) {
            logger.error((Object)String.format("Failed to sync group %s from LDAP: ", groupName), (Throwable)me);
            syncResult.increaseFailed();
        }
    }

    private void convertGroupsToInternalRep(List<LDAPObject> ldapGroups, Map<String, LDAPObject> ldapGroupsMap, List<GroupTreeResolver.Group> ldapGroupsRep) {
        String groupsRdnAttr = this.config.getGroupNameLdapAttribute();
        for (LDAPObject ldapGroup : ldapGroups) {
            String groupName = ldapGroup.getAttributeAsString(groupsRdnAttr);
            if (this.config.isPreserveGroupsInheritance()) {
                HashSet<String> subgroupNames = new HashSet<String>();
                for (LDAPDn groupDn : this.getLDAPSubgroups(ldapGroup)) {
                    String subGroupName = groupDn.getFirstRdn().getAttrValue(groupsRdnAttr);
                    subgroupNames.add(subGroupName);
                }
                ldapGroupsRep.add(new GroupTreeResolver.Group(groupName, subgroupNames));
            }
            ldapGroupsMap.put(groupName, ldapGroup);
        }
    }

    private void syncFlatGroupStructure(RealmModel realm, SynchronizationResult syncResult, Map<String, LDAPObject> ldapGroupsMap) {
        HashSet<String> visitedGroupIds = new HashSet<String>();
        LDAPConfig ldapConfig = this.ldapProvider.getLdapIdentityStore().getConfig();
        int groupsPerTransaction = ldapConfig.getBatchSizeForSync();
        Set<Map.Entry<String, LDAPObject>> entries = ldapGroupsMap.entrySet();
        Iterator<Map.Entry<String, LDAPObject>> it = entries.iterator();
        while (it.hasNext()) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.ldapProvider.getSession().getKeycloakSessionFactory(), session -> {
                RealmModel currentRealm = session.realms().getRealm(realm.getId());
                Map transactionGroupPathGroups = this.getKcSubGroups(currentRealm, null).collect(Collectors.toMap(GroupModel::getName, Function.identity()));
                for (int i = 0; i < groupsPerTransaction && it.hasNext(); ++i) {
                    Map.Entry groupEntry = (Map.Entry)it.next();
                    String groupName = (String)groupEntry.getKey();
                    GroupModel kcExistingGroup = (GroupModel)transactionGroupPathGroups.get(groupName);
                    if (kcExistingGroup != null) {
                        this.syncExistingGroup(currentRealm, kcExistingGroup, groupEntry, syncResult, visitedGroupIds, groupName);
                        continue;
                    }
                    this.syncNonExistingGroup(currentRealm, groupEntry, syncResult, visitedGroupIds, groupName);
                }
            });
        }
        if (this.config.isDropNonExistingGroupsDuringSync()) {
            this.dropNonExistingKcGroups(realm, syncResult, visitedGroupIds);
        }
    }

    private void updateKeycloakGroupTree(RealmModel realm, List<GroupTreeResolver.GroupTreeEntry> groupTrees, Map<String, LDAPObject> ldapGroups, SynchronizationResult syncResult) {
        HashSet<String> visitedGroupIds = new HashSet<String>();
        for (GroupTreeResolver.GroupTreeEntry groupEntry : groupTrees) {
            this.updateKeycloakGroupTreeEntry(realm, groupEntry, ldapGroups, null, syncResult, visitedGroupIds);
        }
        if (this.config.isDropNonExistingGroupsDuringSync()) {
            this.dropNonExistingKcGroups(realm, syncResult, visitedGroupIds);
        }
    }

    private void updateKeycloakGroupTreeEntry(RealmModel realm, GroupTreeResolver.GroupTreeEntry groupTreeEntry, Map<String, LDAPObject> ldapGroups, GroupModel kcParent, SynchronizationResult syncResult, Set<String> visitedGroupIds) {
        String groupName = groupTreeEntry.getGroupName();
        GroupModel kcGroup = this.getKcSubGroups(realm, kcParent).filter(g -> Objects.equals(g.getName(), groupName)).findFirst().orElse(null);
        if (kcGroup != null) {
            logger.debugf("Updated Keycloak group '%s' from LDAP", (Object)kcGroup.getName());
            this.updateAttributesOfKCGroup(kcGroup, ldapGroups.get(kcGroup.getName()));
            syncResult.increaseUpdated();
        } else {
            kcGroup = this.createKcGroup(realm, groupTreeEntry.getGroupName(), kcParent);
            if (kcGroup.getParent() == null) {
                logger.debugf("Imported top-level group '%s' from LDAP", (Object)kcGroup.getName());
            } else {
                logger.debugf("Imported group '%s' from LDAP as child of group '%s'", (Object)kcGroup.getName(), (Object)kcGroup.getParent().getName());
            }
            this.updateAttributesOfKCGroup(kcGroup, ldapGroups.get(kcGroup.getName()));
            syncResult.increaseAdded();
        }
        visitedGroupIds.add(kcGroup.getId());
        for (GroupTreeResolver.GroupTreeEntry childEntry : groupTreeEntry.getChildren()) {
            this.updateKeycloakGroupTreeEntry(realm, childEntry, ldapGroups, kcGroup, syncResult, visitedGroupIds);
        }
    }

    private void dropNonExistingKcGroups(RealmModel realm, SynchronizationResult syncResult, Set<String> visitedGroupIds) {
        GroupModel parent = this.getKcGroupsPathGroup(realm);
        this.getAllKcGroups(realm, parent).filter(kcGroup -> !visitedGroupIds.contains(kcGroup.getId())).forEach(kcGroup -> {
            logger.debugf("Removing Keycloak group '%s', which doesn't exist in LDAP", (Object)kcGroup.getName());
            realm.removeGroup(kcGroup);
            syncResult.increaseRemoved();
        });
    }

    private void updateAttributesOfKCGroup(GroupModel kcGroup, LDAPObject ldapGroup) {
        Collection<String> groupAttributes = this.config.getGroupAttributes();
        for (String attrName : groupAttributes) {
            Set<String> attrValues = ldapGroup.getAttributeAsSet(attrName);
            if (attrValues == null) {
                kcGroup.removeAttribute(attrName);
                continue;
            }
            kcGroup.setAttribute(attrName, new LinkedList<String>(attrValues));
        }
    }

    protected GroupModel findKcGroupByLDAPGroup(RealmModel realm, GroupModel parent, LDAPObject ldapGroup) {
        String groupNameAttr = this.config.getGroupNameLdapAttribute();
        String groupName = ldapGroup.getAttributeAsString(groupNameAttr);
        if (this.config.isPreserveGroupsInheritance()) {
            return this.getAllKcGroups(realm, parent).filter(group -> Objects.equals(group.getName(), groupName)).findFirst().orElse(null);
        }
        return this.session.groups().getGroupByName(realm, parent, groupName);
    }

    protected GroupModel findKcGroupOrSyncFromLDAP(RealmModel realm, GroupModel parent, LDAPObject ldapGroup, UserModel user) {
        GroupModel kcGroup = this.findKcGroupByLDAPGroup(realm, parent, ldapGroup);
        if (kcGroup == null) {
            if (this.config.isPreserveGroupsInheritance()) {
                if (!this.syncFromLDAPPerformedInThisTransaction) {
                    this.syncDataFromFederationProviderToKeycloak(realm);
                    kcGroup = this.findKcGroupByLDAPGroup(realm, parent, ldapGroup);
                }
            } else {
                String groupNameAttr = this.config.getGroupNameLdapAttribute();
                String groupName = ldapGroup.getAttributeAsString(groupNameAttr);
                kcGroup = this.createKcGroup(realm, groupName, null);
                this.updateAttributesOfKCGroup(kcGroup, ldapGroup);
            }
            if (kcGroup == null) {
                String groupName = ldapGroup.getAttributeAsString(this.config.getGroupNameLdapAttribute());
                logger.warnf("User '%s' is member of group '%s', which doesn't exist in LDAP", (Object)user.getUsername(), (Object)groupName);
            }
        }
        return kcGroup;
    }

    protected List<LDAPObject> getAllLDAPGroups(boolean includeMemberAttribute) {
        try (LDAPQuery ldapGroupQuery = this.createGroupQuery(includeMemberAttribute);){
            List<LDAPObject> list = LDAPUtils.loadAllLDAPObjects(ldapGroupQuery, this.ldapProvider);
            return list;
        }
    }

    @Override
    public SynchronizationResult syncDataFromKeycloakToFederationProvider(RealmModel realm) {
        SynchronizationResult syncResult = new SynchronizationResult(){

            public String getStatus() {
                return String.format("%d groups imported to LDAP, %d groups updated to LDAP, %d groups removed from LDAP", this.getAdded(), this.getUpdated(), this.getRemoved());
            }
        };
        if (this.config.getMode() != LDAPGroupMapperMode.LDAP_ONLY) {
            logger.warnf("Ignored sync for federation mapper '%s' as it's mode is '%s'", (Object)this.mapperModel.getName(), (Object)this.config.getMode().toString());
            return syncResult;
        }
        logger.debugf("Syncing groups from Keycloak into LDAP. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getName());
        List<LDAPObject> ldapGroups = this.getAllLDAPGroups(this.config.isPreserveGroupsInheritance());
        HashMap<String, LDAPObject> ldapGroupsMap = new HashMap<String, LDAPObject>();
        String groupsRdnAttr = this.config.getGroupNameLdapAttribute();
        for (LDAPObject ldapGroup : ldapGroups) {
            String groupName = ldapGroup.getAttributeAsString(groupsRdnAttr);
            ldapGroupsMap.put(groupName, ldapGroup);
        }
        HashSet ldapGroupNames = new HashSet();
        this.getKcSubGroups(realm, null).forEach(kcGroup -> this.processKeycloakGroupSyncToLDAP((GroupModel)kcGroup, (Map<String, LDAPObject>)ldapGroupsMap, ldapGroupNames, syncResult));
        if (this.config.isDropNonExistingGroupsDuringSync()) {
            HashSet copy = new HashSet(ldapGroupsMap.keySet());
            for (String groupName : copy) {
                if (ldapGroupNames.contains(groupName)) continue;
                LDAPObject ldapGroup = (LDAPObject)ldapGroupsMap.remove(groupName);
                this.ldapProvider.getLdapIdentityStore().remove(ldapGroup);
                syncResult.increaseRemoved();
            }
        }
        if (this.config.isPreserveGroupsInheritance()) {
            this.getKcSubGroups(realm, null).forEach(kcGroup -> this.processKeycloakGroupMembershipsSyncToLDAP((GroupModel)kcGroup, (Map<String, LDAPObject>)ldapGroupsMap));
        }
        return syncResult;
    }

    private void processKeycloakGroupSyncToLDAP(GroupModel kcGroup, Map<String, LDAPObject> ldapGroupsMap, Set<String> ldapGroupNames, SynchronizationResult syncResult) {
        String groupName = kcGroup.getName();
        HashMap<String, Set<String>> supportedLdapAttributes = new HashMap<String, Set<String>>();
        Iterator<String> iterator = this.config.getGroupAttributes().iterator();
        while (iterator.hasNext()) {
            String attrName;
            Set valueSet = kcGroup.getAttributeStream(attrName = iterator.next()).collect(Collectors.toSet());
            supportedLdapAttributes.put(attrName, valueSet.isEmpty() ? null : valueSet);
        }
        LDAPObject ldapGroup = ldapGroupsMap.get(groupName);
        if (ldapGroup == null) {
            ldapGroup = this.createLDAPGroup(groupName, supportedLdapAttributes);
            syncResult.increaseAdded();
        } else {
            for (Map.Entry attrEntry : supportedLdapAttributes.entrySet()) {
                ldapGroup.setAttribute((String)attrEntry.getKey(), (Set)attrEntry.getValue());
            }
            this.ldapProvider.getLdapIdentityStore().update(ldapGroup);
            syncResult.increaseUpdated();
        }
        ldapGroupsMap.put(groupName, ldapGroup);
        ldapGroupNames.add(groupName);
        kcGroup.getSubGroupsStream().forEach(kcSubgroup -> this.processKeycloakGroupSyncToLDAP((GroupModel)kcSubgroup, ldapGroupsMap, ldapGroupNames, syncResult));
    }

    private void processKeycloakGroupMembershipsSyncToLDAP(GroupModel kcGroup, Map<String, LDAPObject> ldapGroupsMap) {
        LDAPObject ldapGroup = ldapGroupsMap.get(kcGroup.getName());
        Set<LDAPDn> toRemoveSubgroupsDNs = this.getLDAPSubgroups(ldapGroup);
        String membershipUserLdapAttrName = this.getMembershipUserLdapAttribute();
        Set kcSubgroups = kcGroup.getSubGroupsStream().collect(Collectors.toSet());
        for (GroupModel kcSubgroup : kcSubgroups) {
            LDAPObject ldapSubgroup = ldapGroupsMap.get(kcSubgroup.getName());
            if (toRemoveSubgroupsDNs.remove(ldapSubgroup.getDn())) continue;
            LDAPUtils.addMember(this.ldapProvider, MembershipType.DN, this.config.getMembershipLdapAttribute(), membershipUserLdapAttrName, ldapGroup, ldapSubgroup);
        }
        for (LDAPDn toRemoveDN : toRemoveSubgroupsDNs) {
            LDAPObject fakeGroup = new LDAPObject();
            fakeGroup.setDn(toRemoveDN);
            LDAPUtils.deleteMember(this.ldapProvider, MembershipType.DN, this.config.getMembershipLdapAttribute(), membershipUserLdapAttrName, ldapGroup, fakeGroup);
        }
        for (GroupModel kcSubgroup : kcSubgroups) {
            this.processKeycloakGroupMembershipsSyncToLDAP(kcSubgroup, ldapGroupsMap);
        }
    }

    private GroupModel getHighestPredecessorNotExistentInLdap(GroupModel groupsPathGroup, GroupModel group) {
        GroupModel parentGroup = group.getParent();
        if (parentGroup == groupsPathGroup) {
            return group;
        }
        LDAPObject ldapGroup = this.loadLDAPGroupByName(parentGroup.getName());
        if (ldapGroup != null) {
            return group;
        }
        return this.getHighestPredecessorNotExistentInLdap(groupsPathGroup, parentGroup);
    }

    @Override
    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel kcGroup, int firstResult, int maxResults) {
        if (this.config.getMode() == LDAPGroupMapperMode.IMPORT) {
            return Collections.emptyList();
        }
        if (!this.isGroupInGroupPath(realm, kcGroup)) {
            return Collections.emptyList();
        }
        LDAPObject ldapGroup = this.loadLDAPGroupByName(kcGroup.getName());
        if (ldapGroup == null) {
            return Collections.emptyList();
        }
        String strategyKey = this.config.getUserGroupsRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserGroupsRetrieveStrategy(strategyKey);
        return strategy.getLDAPRoleMembers(realm, this, ldapGroup, firstResult, maxResults);
    }

    public void addGroupMappingInLDAP(RealmModel realm, GroupModel kcGroup, LDAPObject ldapUser) {
        String groupName = kcGroup.getName();
        LDAPObject ldapGroup = this.loadLDAPGroupByName(groupName);
        if (ldapGroup == null) {
            if (this.config.isPreserveGroupsInheritance()) {
                GroupModel groupsPathGroup = this.getKcGroupsPathGroup(realm);
                GroupModel highestGroupToSync = this.getHighestPredecessorNotExistentInLdap(groupsPathGroup, kcGroup);
                logger.debugf("Will sync group '%s' and it's subgroups from DB to LDAP", (Object)highestGroupToSync.getName());
                HashMap<String, LDAPObject> syncedLDAPGroups = new HashMap<String, LDAPObject>();
                this.processKeycloakGroupSyncToLDAP(highestGroupToSync, syncedLDAPGroups, new HashSet<String>(), new SynchronizationResult());
                this.processKeycloakGroupMembershipsSyncToLDAP(highestGroupToSync, syncedLDAPGroups);
                ldapGroup = this.loadLDAPGroupByName(groupName);
                if (highestGroupToSync.getParent() != groupsPathGroup) {
                    LDAPObject ldapParentGroup = this.loadLDAPGroupByName(highestGroupToSync.getParent().getName());
                    LDAPUtils.addMember(this.ldapProvider, MembershipType.DN, this.config.getMembershipLdapAttribute(), this.getMembershipUserLdapAttribute(), ldapParentGroup, ldapGroup);
                }
            } else {
                logger.debugf("Will sync group '%s' from DB to LDAP", (Object)groupName);
                this.processKeycloakGroupSyncToLDAP(kcGroup, new HashMap<String, LDAPObject>(), new HashSet<String>(), new SynchronizationResult());
                ldapGroup = this.loadLDAPGroupByName(groupName);
            }
        }
        String membershipUserLdapAttrName = this.getMembershipUserLdapAttribute();
        LDAPUtils.addMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), membershipUserLdapAttrName, ldapGroup, ldapUser);
    }

    public void deleteGroupMappingInLDAP(LDAPObject ldapUser, LDAPObject ldapGroup) {
        String membershipUserLdapAttrName = this.getMembershipUserLdapAttribute();
        LDAPUtils.deleteMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), membershipUserLdapAttrName, ldapGroup, ldapUser);
    }

    protected List<LDAPObject> getLDAPGroupMappings(LDAPObject ldapUser) {
        String strategyKey = this.config.getUserGroupsRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserGroupsRetrieveStrategy(strategyKey);
        LDAPConfig ldapConfig = this.ldapProvider.getLdapIdentityStore().getConfig();
        return strategy.getLDAPRoleMappings(this, ldapUser, ldapConfig);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String strategyKey = this.config.getUserGroupsRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserGroupsRetrieveStrategy(strategyKey);
        strategy.beforeUserLDAPQuery(this, query);
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT) {
            return delegate;
        }
        return new LDAPGroupMappingsUserDelegate(realm, delegate, ldapUser);
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        List<LDAPObject> ldapGroups;
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT && isCreate && !(ldapGroups = this.getLDAPGroupMappings(ldapUser)).isEmpty()) {
            GroupModel parent = this.getKcGroupsPathGroup(realm);
            for (LDAPObject ldapGroup : ldapGroups) {
                GroupModel kcGroup = this.findKcGroupOrSyncFromLDAP(realm, parent, ldapGroup, user);
                if (kcGroup == null) continue;
                logger.debugf("User '%s' joins group '%s' during import from LDAP", (Object)user.getUsername(), (Object)kcGroup.getName());
                user.joinGroup(kcGroup);
            }
        }
    }

    protected String getMembershipUserLdapAttribute() {
        LDAPConfig ldapConfig = this.ldapProvider.getLdapIdentityStore().getConfig();
        return this.config.getMembershipUserLdapAttribute(ldapConfig);
    }

    protected String getKcGroupPathFromLDAPGroupName(String ldapGroupName) {
        return this.config.getGroupsPathWithTrailingSlash() + ldapGroupName;
    }

    protected GroupModel getKcGroupsPathGroup(RealmModel realm) {
        return this.config.isTopLevelGroupsPath() ? null : KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)realm, (String)this.config.getGroupsPath());
    }

    protected boolean isGroupInGroupPath(RealmModel realm, GroupModel group) {
        if (this.config.isTopLevelGroupsPath()) {
            return true;
        }
        GroupModel groupPathGroup = KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)realm, (String)this.config.getGroupsPath());
        if (groupPathGroup != null) {
            while (!groupPathGroup.getId().equals(group.getId())) {
                if ((group = group.getParent()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected GroupModel createKcGroup(RealmModel realm, String ldapGroupName, GroupModel parentGroup) {
        if (parentGroup == null) {
            parentGroup = this.getKcGroupsPathGroup(realm);
        }
        return realm.createGroup(ldapGroupName, parentGroup);
    }

    protected Stream<GroupModel> getKcSubGroups(RealmModel realm, GroupModel parentGroup) {
        if (parentGroup == null) {
            parentGroup = this.getKcGroupsPathGroup(realm);
        }
        return parentGroup == null ? this.session.groups().getTopLevelGroupsStream(realm) : parentGroup.getSubGroupsStream();
    }

    protected Stream<GroupModel> getAllKcGroups(RealmModel realm, GroupModel topParentGroup) {
        Stream allGroups = realm.getGroupsStream();
        if (topParentGroup == null) {
            return allGroups;
        }
        return allGroups.filter(group -> {
            for (GroupModel parent = group.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.getId().equals(topParentGroup.getId())) continue;
                return true;
            }
            return false;
        });
    }

    public class LDAPGroupMappingsUserDelegate
    extends UserModelDelegate {
        private final RealmModel realm;
        private final LDAPObject ldapUser;
        private Set<GroupModel> cachedLDAPGroupMappings;

        public LDAPGroupMappingsUserDelegate(RealmModel realm, UserModel user, LDAPObject ldapUser) {
            super(user);
            this.realm = realm;
            this.ldapUser = ldapUser;
        }

        public boolean hasRole(RoleModel role) {
            return super.hasRole(role) || RoleUtils.hasRoleFromGroup(this.getGroupsStream(), (RoleModel)role, (boolean)true);
        }

        public Stream<GroupModel> getGroupsStream() {
            Stream<GroupModel> ldapGroupMappings = this.getLDAPGroupMappingsConverted();
            if (GroupLDAPStorageMapper.this.config.isTopLevelGroupsPath() && GroupLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                return ldapGroupMappings;
            }
            return Stream.concat(ldapGroupMappings, super.getGroupsStream());
        }

        public void joinGroup(GroupModel group) {
            if (GroupLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY && GroupLDAPStorageMapper.this.isGroupInGroupPath(this.realm, group)) {
                this.cachedLDAPGroupMappings = null;
                GroupLDAPStorageMapper.this.addGroupMappingInLDAP(this.realm, group, this.ldapUser);
            } else {
                super.joinGroup(group);
            }
        }

        public void leaveGroup(GroupModel group) {
            if (!GroupLDAPStorageMapper.this.isGroupInGroupPath(this.realm, group)) {
                super.leaveGroup(group);
            }
            try (LDAPQuery ldapQuery = GroupLDAPStorageMapper.this.createGroupQuery(true);){
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition roleNameCondition = conditionsBuilder.equal(GroupLDAPStorageMapper.this.config.getGroupNameLdapAttribute(), group.getName());
                String membershipUserLdapAttrName = GroupLDAPStorageMapper.this.getMembershipUserLdapAttribute();
                String membershipUserAttr = LDAPUtils.getMemberValueOfChildObject(this.ldapUser, GroupLDAPStorageMapper.this.config.getMembershipTypeLdapAttribute(), membershipUserLdapAttrName);
                Condition membershipCondition = conditionsBuilder.equal(GroupLDAPStorageMapper.this.config.getMembershipLdapAttribute(), membershipUserAttr);
                ldapQuery.addWhereCondition(roleNameCondition).addWhereCondition(membershipCondition);
                LDAPObject ldapGroup = ldapQuery.getFirstResult();
                if (ldapGroup == null) {
                    if (GroupLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.READ_ONLY) {
                        super.leaveGroup(group);
                    }
                } else {
                    if (GroupLDAPStorageMapper.this.config.getMode() == LDAPGroupMapperMode.READ_ONLY) {
                        throw new ModelException("Not possible to delete LDAP group mappings as mapper mode is READ_ONLY");
                    }
                    this.cachedLDAPGroupMappings = null;
                    GroupLDAPStorageMapper.this.deleteGroupMappingInLDAP(this.ldapUser, ldapGroup);
                }
            }
        }

        public boolean isMemberOf(GroupModel group) {
            return GroupLDAPStorageMapper.this.isGroupInGroupPath(this.realm, group) && RoleUtils.isDirectMember(this.getGroupsStream(), (GroupModel)group);
        }

        protected Stream<GroupModel> getLDAPGroupMappingsConverted() {
            if (this.cachedLDAPGroupMappings != null) {
                return this.cachedLDAPGroupMappings.stream();
            }
            List<LDAPObject> ldapGroups = GroupLDAPStorageMapper.this.getLDAPGroupMappings(this.ldapUser);
            if (!ldapGroups.isEmpty()) {
                GroupModel parent = GroupLDAPStorageMapper.this.getKcGroupsPathGroup(this.realm);
                this.cachedLDAPGroupMappings = ldapGroups.stream().map(ldapGroup -> GroupLDAPStorageMapper.this.findKcGroupOrSyncFromLDAP(this.realm, parent, (LDAPObject)ldapGroup, (UserModel)this)).filter(Objects::nonNull).collect(Collectors.toSet());
                return this.cachedLDAPGroupMappings.stream();
            }
            return Stream.empty();
        }
    }
}

