/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.utils.StringUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;

@Documented
@Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ConfigMapping {
    public String prefix() default "";

    public NamingStrategy namingStrategy() default NamingStrategy.KEBAB_CASE;

    public static enum NamingStrategy {
        VERBATIM(name -> name),
        KEBAB_CASE(name -> StringUtil.skewer((String)name, (char)'-')),
        SNAKE_CASE(name -> StringUtil.skewer((String)name, (char)'_'));

        private final Function<String, String> function;

        private NamingStrategy(Function<String, String> function) {
            this.function = function;
        }

        public String apply(String name) {
            return this.function.apply(name);
        }
    }
}

