/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.caffeine.deployment.devui;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;

public class CaffeineDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    void createCard(BuildProducer<CardPageBuildItem> cardPageBuildItemBuildProducer) {
        CardPageBuildItem card = new CardPageBuildItem();
        PageBuilder versionPage = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Version").icon("font-awesome-solid:mug-hot")).url("https://github.com/ben-manes/caffeine").doNotEmbed().staticLabel(CaffeineDevUIProcessor.getManifest(Caffeine.class).getMainAttributes().getValue("Bundle-Version"));
        card.addPage(versionPage);
        card.setCustomCard("qwc-caffeine-card.js");
        cardPageBuildItemBuildProducer.produce((BuildItem)card);
    }

    public static Manifest getManifest(Class<?> clz) {
        Manifest manifest;
        block8: {
            String resource = "/" + clz.getName().replace(".", "/") + ".class";
            String fullPath = clz.getResource(resource).toString();
            String archivePath = fullPath.substring(0, fullPath.length() - resource.length());
            InputStream input = new URL(archivePath + "/META-INF/MANIFEST.MF").openStream();
            try {
                manifest = new Manifest(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Loading MANIFEST for class " + String.valueOf(clz) + " failed!", e);
                }
            }
            input.close();
        }
        return manifest;
    }
}

