/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.wildfly.security.ssl.ElytronMessages;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    private static final Method SSLENGINE_GET_APPLICATION_PROTOCOL = JDKSpecific.getMethodOrNull(SSLEngine.class, "getApplicationProtocol", new Class[0]);
    private static final Method SSLENGINE_GET_HANDSHAKE_APPLICATION_PROTOCOL = JDKSpecific.getMethodOrNull(SSLEngine.class, "getHandshakeApplicationProtocol", new Class[0]);
    private static final Method SSLENGINE_SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = JDKSpecific.getMethodOrNull(SSLEngine.class, "setHandshakeApplicationProtocolSelector", BiFunction.class);
    private static final Method SSLENGINE_GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = JDKSpecific.getMethodOrNull(SSLEngine.class, "getHandshakeApplicationProtocolSelector", new Class[0]);
    private static final Method SSLPARAMETERS_GET_APPLICATION_PROTOCOLS = JDKSpecific.getMethodOrNull(SSLParameters.class, "getApplicationProtocols", new Class[0]);
    private static final Method SSLPARAMETERS_SET_APPLICATION_PROTOCOLS = JDKSpecific.getMethodOrNull(SSLParameters.class, "setApplicationProtocols", String[].class);
    private static final Method SSLSOCKET_GET_APPLICATION_PROTOCOL = JDKSpecific.getMethodOrNull(SSLSocket.class, "getApplicationProtocol", new Class[0]);
    private static final Method SSLSOCKET_GET_HANDSHAKE_APPLICATION_PROTOCOL = JDKSpecific.getMethodOrNull(SSLSocket.class, "getHandshakeApplicationProtocol", new Class[0]);
    private static final Method SSLSOCKET_SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = JDKSpecific.getMethodOrNull(SSLSocket.class, "setHandshakeApplicationProtocolSelector", BiFunction.class);
    private static final Method SSLSOCKET_GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = JDKSpecific.getMethodOrNull(SSLSocket.class, "getHandshakeApplicationProtocolSelector", new Class[0]);

    JDKSpecific() {
    }

    private static Method getMethodOrNull(Class clazz, String methodName, Class ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            if (ElytronMessages.tls.isTraceEnabled()) {
                ElytronMessages.tls.tracef(e, "Unable to getMethod %s on class %s", methodName, clazz.getName());
            } else if (ElytronMessages.tls.isDebugEnabled()) {
                ElytronMessages.tls.debugf("Unable to getMethod %s on class %s", methodName, clazz.getName());
            }
            return null;
        }
    }

    static String getApplicationProtocol(SSLEngine sslEngine) {
        if (SSLENGINE_GET_APPLICATION_PROTOCOL != null) {
            try {
                return (String)SSLENGINE_GET_APPLICATION_PROTOCOL.invoke((Object)sslEngine, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static String getHandshakeApplicationProtocol(SSLEngine sslEngine) {
        if (SSLENGINE_GET_HANDSHAKE_APPLICATION_PROTOCOL != null) {
            try {
                return (String)SSLENGINE_GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke((Object)sslEngine, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine sslEngine, BiFunction<SSLEngine, List<String>, String> selector) {
        if (SSLENGINE_SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR != null) {
            try {
                SSLENGINE_SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sslEngine, selector);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine sslEngine) {
        if (SSLENGINE_GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR != null) {
            try {
                return (BiFunction)SSLENGINE_GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sslEngine, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static String[] getApplicationProtocols(SSLParameters parameters) {
        if (SSLPARAMETERS_GET_APPLICATION_PROTOCOLS != null) {
            try {
                return (String[])SSLPARAMETERS_GET_APPLICATION_PROTOCOLS.invoke((Object)parameters, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static void setApplicationProtocols(SSLParameters parameters, String[] protocols) {
        if (SSLPARAMETERS_SET_APPLICATION_PROTOCOLS != null) {
            try {
                SSLPARAMETERS_SET_APPLICATION_PROTOCOLS.invoke((Object)parameters, new Object[]{protocols});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static SSLParameters setSSLParameters(SSLParameters original) {
        SSLParameters params = new SSLParameters();
        params.setProtocols(original.getProtocols());
        params.setCipherSuites(original.getCipherSuites());
        params.setUseCipherSuitesOrder(original.getUseCipherSuitesOrder());
        params.setServerNames(original.getServerNames());
        params.setSNIMatchers(original.getSNIMatchers());
        params.setAlgorithmConstraints(original.getAlgorithmConstraints());
        params.setEndpointIdentificationAlgorithm(original.getEndpointIdentificationAlgorithm());
        if (original.getWantClientAuth()) {
            params.setWantClientAuth(original.getWantClientAuth());
        } else if (original.getNeedClientAuth()) {
            params.setNeedClientAuth(original.getNeedClientAuth());
        }
        try {
            if (SSLPARAMETERS_GET_APPLICATION_PROTOCOLS != null && SSLPARAMETERS_SET_APPLICATION_PROTOCOLS != null) {
                JDKSpecific.setApplicationProtocols(params, JDKSpecific.getApplicationProtocols(original));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return params;
    }

    static String getApplicationProtocol(SSLSocket socket) {
        if (SSLSOCKET_GET_APPLICATION_PROTOCOL != null) {
            try {
                return (String)SSLSOCKET_GET_APPLICATION_PROTOCOL.invoke((Object)socket, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static String getHandshakeApplicationProtocol(SSLSocket socket) {
        if (SSLSOCKET_GET_HANDSHAKE_APPLICATION_PROTOCOL != null) {
            try {
                return (String)SSLSOCKET_GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke((Object)socket, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static void setHandshakeApplicationProtocolSelector(SSLSocket socket, BiFunction<SSLSocket, List<String>, String> selector) {
        if (SSLSOCKET_SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR != null) {
            try {
                SSLSOCKET_SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)socket, selector);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    static BiFunction<SSLSocket, List<String>, String> getHandshakeApplicationProtocolSelector(SSLSocket socket) {
        if (SSLSOCKET_GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR != null) {
            try {
                return (BiFunction)SSLSOCKET_GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)socket, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException();
    }
}

