/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxySocketConnection;
import org.jivesoftware.smack.util.OutputStreamUtil;

public class Socks4ProxySocketConnection
implements ProxySocketConnection {
    private final ProxyInfo proxy;

    Socks4ProxySocketConnection(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    @Override
    public void connect(Socket socket, String host, int port2, int timeout) throws IOException {
        String proxy_host = this.proxy.getProxyAddress();
        int proxy_port = this.proxy.getProxyPort();
        String user = this.proxy.getProxyUsername();
        socket.connect(new InetSocketAddress(proxy_host, proxy_port), timeout);
        InputStream in = socket.getInputStream();
        DataInputStream dis = new DataInputStream(in);
        OutputStream out = socket.getOutputStream();
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        outBuf.write(4);
        outBuf.write(1);
        outBuf.write(port2 >>> 8);
        outBuf.write(port2 & 0xFF);
        InetAddress inetAddress = InetAddress.getByName(proxy_host);
        byte[] byteAddress = inetAddress.getAddress();
        outBuf.write(byteAddress);
        if (user != null) {
            byte[] userBytes = user.getBytes(StandardCharsets.UTF_8);
            outBuf.write(userBytes);
        }
        outBuf.write(0);
        OutputStreamUtil.writeResetAndFlush(outBuf, out);
        byte[] inBuf = new byte[6];
        dis.readFully(inBuf);
        if (inBuf[0] != 0) {
            throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, "server returns VN " + inBuf[0]);
        }
        if (inBuf[1] != 90) {
            String message = "ProxySOCKS4: server returns CD " + inBuf[1];
            throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, message);
        }
        inBuf = new byte[2];
        dis.readFully(inBuf);
    }
}

