/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxySocketConnection;
import org.jivesoftware.smack.util.stringencoder.Base64;

class HTTPProxySocketConnection
implements ProxySocketConnection {
    private final ProxyInfo proxy;
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\S+\\s(\\d+)\\s(.*)\\s*");

    HTTPProxySocketConnection(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    @Override
    public void connect(Socket socket, String host, int port2, int timeout) throws IOException {
        String proxyLine;
        String proxyhost = this.proxy.getProxyAddress();
        int proxyPort = this.proxy.getProxyPort();
        socket.connect(new InetSocketAddress(proxyhost, proxyPort));
        String hostport = "CONNECT " + host + ":" + port2;
        String username2 = this.proxy.getProxyUsername();
        if (username2 == null) {
            proxyLine = "";
        } else {
            String password = this.proxy.getProxyPassword();
            proxyLine = "\r\nProxy-Authorization: Basic " + Base64.encode(username2 + ":" + password);
        }
        socket.getOutputStream().write((hostport + " HTTP/1.1\r\nHost: " + host + ":" + port2 + proxyLine + "\r\n\r\n").getBytes("UTF-8"));
        InputStream in = socket.getInputStream();
        StringBuilder got = new StringBuilder(100);
        int nlchars = 0;
        do {
            int inByte;
            if ((inByte = in.read()) == -1) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP);
            }
            char c = (char)inByte;
            got.append(c);
            if (got.length() > 1024) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Received header of >1024 characters from " + proxyhost + ", cancelling connection");
            }
            if ((nlchars == 0 || nlchars == 2) && c == '\r') {
                ++nlchars;
                continue;
            }
            if ((nlchars == 1 || nlchars == 3) && c == '\n') {
                ++nlchars;
                continue;
            }
            nlchars = 0;
        } while (nlchars != 4);
        if (nlchars != 4) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Never received blank line from " + proxyhost + ", cancelling connection");
        }
        String gotstr = got.toString();
        BufferedReader br = new BufferedReader(new StringReader(gotstr));
        String response = br.readLine();
        if (response == null) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Empty proxy response from " + proxyhost + ", cancelling");
        }
        Matcher m = RESPONSE_PATTERN.matcher(response);
        if (!m.matches()) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Unexpected proxy response from " + proxyhost + ": " + response);
        }
        int code = Integer.parseInt(m.group(1));
        if (code != 200) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Error code in proxy response: " + code);
        }
    }
}

