/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.reflection.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;

public class MethodWrapperImpl
implements MethodWrapper {
    private final Method method;
    private final int hashCode;

    public MethodWrapperImpl(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.method = method;
        int hashCode2 = 0;
        hashCode2 ^= method.getName().hashCode();
        hashCode2 ^= method.getReturnType().hashCode();
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            hashCode2 ^= method.getDeclaringClass().hashCode();
        } else if (this.isPackagePrivate(modifiers)) {
            hashCode2 ^= method.getDeclaringClass().getPackage().hashCode();
        }
        for (Class<?> param : method.getParameterTypes()) {
            hashCode2 ^= param.hashCode();
        }
        this.hashCode = hashCode2;
    }

    private boolean isPackagePrivate(int modifiers) {
        return !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        Class<?>[] otherParams;
        if (o == null) {
            return false;
        }
        if (!(o instanceof MethodWrapperImpl)) {
            return false;
        }
        MethodWrapperImpl other = (MethodWrapperImpl)o;
        if (!this.method.getName().equals(other.method.getName())) {
            return false;
        }
        if (!this.method.getReturnType().equals(other.method.getReturnType())) {
            return false;
        }
        Class<?>[] myParams = this.method.getParameterTypes();
        if (myParams.length != (otherParams = other.method.getParameterTypes()).length) {
            return false;
        }
        if (ReflectionHelper.isPrivate(this.method) || ReflectionHelper.isPrivate(other.method)) {
            return false;
        }
        for (int lcv = 0; lcv < myParams.length; ++lcv) {
            if (myParams[lcv].equals(otherParams[lcv])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MethodWrapperImpl(" + Pretty.method(this.method) + "," + System.identityHashCode(this) + ")";
    }
}

