/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.SessionNotFoundException;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SQLIndex
extends SQLObject {
    private static final Logger logger = Logger.getLogger(SQLIndex.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(Column.class);
    public static final String INDEX_TYPE_DESCRIPTOR = SQLIndex.class.getName() + ".IndexType";
    private String type;
    public static final String RS_INDEX_TYPE_COL = "SPG_INDEX_TYPE";
    private boolean unique;
    private String qualifier;
    private String filterCondition;
    private boolean clustered;
    private SPListener removeColumnListener;
    private List<Column> columns = new ArrayList<Column>();

    @Constructor
    public SQLIndex(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="unique") boolean unique, @ConstructorParameter(propertyName="qualifier") String qualifier, @ConstructorParameter(propertyName="type") String type, @ConstructorParameter(propertyName="filterCondition") String filter) {
        this();
        this.setName(name);
        this.unique = unique;
        this.qualifier = qualifier;
        this.type = type;
        this.filterCondition = filter;
    }

    public SQLIndex() {
        this.setPopulated(true);
        this.removeColumnListener = new AbstractSPListener(){

            @Override
            public void childRemoved(SPChildEvent e) {
                if (e.getChildType() == SQLColumn.class) {
                    SQLIndex.this.removeColumnFromIndices(e);
                }
            }
        };
    }

    public SQLIndex(SQLIndex oldIndex) throws SQLObjectException {
        this();
        this.setParent(oldIndex.getParent());
        this.updateToMatch(oldIndex);
    }

    @Override
    public final void updateToMatch(SQLObject source) throws SQLObjectException {
        this.updateToMatch(source, true);
    }

    public final void updateToMatch(SQLObject source, boolean updateChildren) throws SQLObjectException {
        SQLIndex sourceIdx = (SQLIndex)source;
        try {
            this.begin("Updating SQLIndex to match source object.");
            this.setName(sourceIdx.getName());
            this.setUnique(sourceIdx.unique);
            this.populated = sourceIdx.populated;
            this.setType(sourceIdx.type);
            this.setFilterCondition(sourceIdx.filterCondition);
            this.setQualifier(sourceIdx.qualifier);
            this.setClustered(sourceIdx.clustered);
            this.setPhysicalName(sourceIdx.getPhysicalName());
            if (updateChildren) {
                this.makeColumnsLike(sourceIdx);
            }
            this.commit();
        }
        catch (IllegalArgumentException e) {
            this.rollback("Could not remove columns from SQLIndex: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            this.rollback("Could not remove columns from SQLIndex: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    @NonProperty
    public Column getChild(int index) throws SQLObjectException {
        return (Column)super.getChild(index);
    }

    @NonProperty
    public List<Column> getChildrenWithoutPopulating() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.columns));
    }

    @Override
    public SQLTable getParent() {
        return (SQLTable)super.getParent();
    }

    @Mutator
    public void setParent(SQLTable parent) {
        this.setParentHelper(parent);
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    protected void populateImpl() throws SQLObjectException {
    }

    @Override
    @Transient
    @Accessor
    public boolean isPopulated() {
        return true;
    }

    @Override
    @Mutator
    public void setParent(SPObject parent) {
        this.setParentHelper(parent);
    }

    private void setParentHelper(SPObject parent) {
        if (this.getParent() != null) {
            this.getParent().removeSPListener(this.removeColumnListener);
        }
        super.setParent(parent);
        if (this.getParent() != null) {
            this.getParent().addSPListener(this.removeColumnListener);
        }
    }

    private void removeColumnFromIndices(SPChildEvent e) {
        if (this.getParent() != null && this.getParent().isMagicEnabled()) {
            try {
                SQLTable parentTable = this.getParent();
                parentTable.begin("Removing column from indices");
                for (int j = this.getChildCount() - 1; j >= 0; --j) {
                    Column col = this.getChild(j);
                    if (col.getColumn() == null || !col.getColumn().equals(e.getChild())) continue;
                    this.removeChild(col);
                }
                this.cleanUpIfChildless();
                parentTable.commit();
            }
            catch (SQLObjectException e1) {
                this.rollback("Could not remove child: " + e1.getMessage());
                throw new SQLObjectRuntimeException(e1);
            }
            catch (IllegalArgumentException e1) {
                this.rollback("Could not remove child: " + e1.getMessage());
                throw new RuntimeException(e1);
            }
            catch (ObjectDependentException e1) {
                this.rollback("Could not remove child: " + e1.getMessage());
                throw new RuntimeException(e1);
            }
        }
    }

    public void cleanUpIfChildless() {
        if (this.isPrimaryKeyIndex()) {
            return;
        }
        try {
            if (this.getChildCount() == 0 && this.getParent() != null) {
                logger.debug((Object)("Removing " + this.getName() + " index from table " + this.getParent().getName()));
                this.getParent().removeSPListener(this.removeColumnListener);
                this.getParent().removeChild(this);
            }
        }
        catch (SQLObjectException e) {
            throw new SQLObjectRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof Column) {
            Column c = (Column)child;
            if (this.isPrimaryKeyIndex() && c.getColumn() == null) {
                throw new IllegalArgumentException("The primary key index must consist of real columns, not expressions");
            }
            this.addIndexColumn(c, index);
            if (c.getColumn() != null) {
                c.getColumn().addSPListener(c.targetColumnListener);
            }
        } else {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
    }

    @Accessor(isInteresting=true)
    public String getFilterCondition() {
        return this.filterCondition;
    }

    @Mutator
    public void setFilterCondition(String filterCondition) {
        String oldValue = this.filterCondition;
        this.filterCondition = filterCondition;
        this.firePropertyChange("filterCondition", oldValue, filterCondition);
    }

    @Accessor(isInteresting=true)
    public String getQualifier() {
        return this.qualifier;
    }

    @Mutator
    public void setQualifier(String qualifier) {
        String oldValue = this.qualifier;
        this.qualifier = qualifier;
        this.firePropertyChange("qualifier", oldValue, qualifier);
    }

    @Accessor(isInteresting=true)
    public String getType() {
        return this.type;
    }

    @Mutator
    public void setType(String type) {
        String oldValue = this.type;
        this.type = type;
        this.firePropertyChange("type", oldValue, type);
    }

    @Accessor(isInteresting=true)
    public boolean isUnique() {
        return this.unique;
    }

    @Accessor(isInteresting=true)
    public boolean isClustered() {
        return this.clustered;
    }

    @Mutator
    public void setUnique(boolean unique) {
        boolean oldValue = this.unique;
        this.unique = unique;
        this.firePropertyChange("unique", oldValue, unique);
    }

    @Mutator
    public void setClustered(boolean value) {
        boolean oldValue = this.clustered;
        this.clustered = value;
        this.firePropertyChange("clustered", oldValue, this.clustered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<SQLIndex> fetchIndicesForTableAndUpdatePK(DatabaseMetaData dbmd, final SQLTable targetTable) throws SQLException, SQLObjectException {
        ResultSet rs = null;
        String catalog = targetTable.getCatalogName();
        String schema = targetTable.getSchemaName();
        String tableName = targetTable.getName();
        ArrayList<SQLIndex> indexes = new ArrayList<SQLIndex>();
        try {
            String pkName = null;
            rs = dbmd.getPrimaryKeys(catalog, schema, tableName);
            final TreeMap<Integer, String> pkColPositionToName = new TreeMap<Integer, String>();
            while (rs.next()) {
                pkColPositionToName.put(rs.getInt(5) - 1, rs.getString(4));
                String pkNameCheck = rs.getString(6);
                if (pkName == null) {
                    pkName = pkNameCheck;
                    continue;
                }
                if (pkName.equals(pkNameCheck)) continue;
                throw new IllegalStateException("The PK name has changed from " + pkName + " to " + pkNameCheck + " while adding indices to table");
            }
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry namedPositions : pkColPositionToName.entrySet()) {
                        if (!targetTable.isColumnsPopulated()) {
                            throw new IllegalStateException("Table " + targetTable + " is missing columns, cannot populate primary key.");
                        }
                        try {
                            SQLColumn col = targetTable.getColumnByName((String)namedPositions.getValue(), false, true);
                            if (col != null) {
                                targetTable.changeColumnIndex(targetTable.getColumnsWithoutPopulating().indexOf(col), (Integer)namedPositions.getKey(), true);
                                continue;
                            }
                            logger.error((Object)("Column " + (String)namedPositions.getValue() + " not found in " + targetTable));
                            throw new RuntimeException("Column " + col.getName() + " not found in " + targetTable);
                        }
                        catch (SQLObjectException e) {
                            throw new SQLObjectRuntimeException(e);
                        }
                    }
                }
            };
            try {
                targetTable.getRunnableDispatcher().runInForeground(runner);
            }
            catch (SessionNotFoundException e) {
                runner.run();
            }
            rs.close();
            rs = null;
            logger.debug((Object)("SQLIndex.addIndicesToTable: catalog=" + catalog + "; schema=" + schema + "; tableName=" + tableName + "; primary key name=" + pkName));
            SQLIndex idx = null;
            rs = dbmd.getIndexInfo(catalog, schema, tableName, false, true);
            while (rs.next()) {
                boolean nonUnique = rs.getBoolean(4);
                boolean isClustered = rs.getShort(7) == 1;
                String qualifier = rs.getString(5);
                String name = rs.getString(6);
                String type = null;
                if (SQL.findColumnIndex(rs, RS_INDEX_TYPE_COL) > 0) {
                    type = rs.getString(RS_INDEX_TYPE_COL);
                }
                int pos = rs.getInt(8);
                final String colName = rs.getString(9);
                String ascDesc = rs.getString(10);
                final AscendDescend aOrD = ascDesc != null && ascDesc.equals("A") ? AscendDescend.ASCENDING : (ascDesc != null && ascDesc.equals("D") ? AscendDescend.DESCENDING : AscendDescend.UNSPECIFIED);
                String filter = rs.getString(13);
                if (pos == 0) continue;
                if (pos == 1) {
                    logger.debug((Object)("Found index " + name));
                    idx = new SQLIndex(name, !nonUnique, qualifier, type, filter);
                    idx.setClustered(isClustered);
                    if (name.equals(pkName)) {
                        final SQLIndex pkIndex = idx;
                        Runnable pkIndexUpdate = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    targetTable.getPrimaryKeyIndexWithoutPopulating().updateToMatch(pkIndex, false);
                                }
                                catch (SQLObjectException e) {
                                    throw new SQLObjectRuntimeException(e);
                                }
                            }
                        };
                        try {
                            targetTable.getRunnableDispatcher().runInForeground(pkIndexUpdate);
                        }
                        catch (SessionNotFoundException e) {
                            pkIndexUpdate.run();
                        }
                        idx = targetTable.getPrimaryKeyIndexWithoutPopulating();
                    } else {
                        indexes.add(idx);
                    }
                }
                if (idx.isPrimaryKeyIndex()) continue;
                logger.debug((Object)("Adding column " + colName + " to index " + idx.getName()));
                final SQLIndex nonPKIndex = idx;
                Runnable indexChildRunner = new Runnable(){

                    @Override
                    public void run() {
                        if (!targetTable.isColumnsPopulated()) {
                            throw new IllegalStateException("Table " + targetTable + " is missing columns, cannot populate indices.");
                        }
                        try {
                            SQLColumn tableCol = targetTable.getColumnByName(colName, false, true);
                            Column indexCol = tableCol != null ? new Column(tableCol, aOrD) : new Column(colName, aOrD);
                            nonPKIndex.addChild(indexCol);
                        }
                        catch (SQLObjectException e) {
                            throw new SQLObjectRuntimeException(e);
                        }
                    }
                };
                try {
                    targetTable.getRunnableDispatcher().runInForeground(indexChildRunner);
                }
                catch (SessionNotFoundException e) {
                    indexChildRunner.run();
                }
            }
            rs.close();
            rs = null;
            ArrayList<SQLIndex> arrayList = indexes;
            return arrayList;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close result set", (Throwable)ex);
            }
        }
    }

    @Transient
    @Accessor
    public boolean isPrimaryKeyIndex() {
        if (this.getParent() == null) {
            return false;
        }
        return this.getParent().isPrimaryKey(this);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void addIndexColumn(SQLColumn col) {
        this.addIndexColumn(col, AscendDescend.UNSPECIFIED);
    }

    public void addIndexColumn(SQLColumn col1, AscendDescend aOrD) {
        if (this.getParent() != null && !this.getParent().getColumnsWithoutPopulating().contains(col1)) {
            throw new IllegalArgumentException("Cannot add " + col1 + " to " + this + " because the column is not part of the table " + this.getParent());
        }
        if (this.indexOf(col1) != -1) {
            throw new IllegalArgumentException("Column " + col1 + " already exists in this index.");
        }
        Column col = new Column(col1, aOrD);
        this.addIndexColumn(col);
    }

    public void addIndexColumn(String colName, AscendDescend aOrD) throws SQLObjectException {
        Column col = new Column(colName, aOrD);
        this.addIndexColumn(col);
    }

    public void addIndexColumn(Column col) {
        this.addIndexColumn(col, this.columns.size());
    }

    public void addIndexColumn(Column col, int index) {
        if (col != null && this.indexOf(col.getColumn()) != -1) {
            throw new IllegalArgumentException("Column " + col + " already exists in this index.");
        }
        if (this.isPrimaryKeyIndex()) {
            index = this.getParent().getColumnsWithoutPopulating().indexOf(col.getColumn());
            col.getColumn().setNullable(0);
        }
        this.columns.add(index, col);
        col.setParent(this);
        this.fireChildAdded(Column.class, col, index);
        if (this.isPrimaryKeyIndex()) {
            this.getParent().updateRelationshipsForNewIndexColumn(col.getColumn());
        }
    }

    public static SQLIndex getDerivedInstance(SQLIndex source, SQLTable parentTable) throws SQLObjectException {
        SQLIndex index = new SQLIndex();
        index.setName(source.getName());
        index.setUnique(source.isUnique());
        index.setPopulated(source.isPopulated());
        index.setType(source.getType());
        index.setFilterCondition(source.getFilterCondition());
        index.setQualifier(source.getQualifier());
        index.setPhysicalName(source.getPhysicalName());
        index.setClustered(source.isClustered());
        for (Map.Entry<Class<? extends SQLObject>, Throwable> inaccessibleReason : source.getChildrenInaccessibleReasons().entrySet()) {
            index.setChildrenInaccessibleReason(inaccessibleReason.getValue(), inaccessibleReason.getKey(), false);
        }
        for (Column column : source.getChildren(Column.class)) {
            Column newColumn;
            if (column.getColumn() != null) {
                SQLColumn sqlColumn = SQLIndex.findEquivalentColumnNotIncluded(parentTable, index, column.getColumn());
                if (sqlColumn == null) {
                    throw new SQLObjectException("Can not derive instance, because coulmn " + column.getColumn().getName() + "is not found in parent table [" + parentTable.getName() + "]");
                }
                newColumn = new Column(sqlColumn, column.getAscendingOrDescending());
            } else {
                newColumn = new Column(column.getName(), column.getAscendingOrDescending());
            }
            index.addChild(newColumn);
        }
        return index;
    }

    private static SQLColumn findEquivalentColumnNotIncluded(SQLTable parentTable, SQLIndex index, SQLColumn column) {
        if (column.getParent().equals(parentTable)) {
            return column;
        }
        for (SQLColumn existingCol : parentTable.getColumnsWithoutPopulating()) {
            if (!existingCol.getName().equals(column.getName()) || index.indexOf(existingCol) != -1) continue;
            return existingCol;
        }
        return null;
    }

    public void makeColumnsLike(SQLIndex index) throws SQLObjectException, IllegalArgumentException, ObjectDependentException {
        this.makeColumnsLike(index.getChildrenWithoutPopulating(Column.class));
    }

    public void makeColumnsLike(List<Column> sourceCols) throws SQLObjectException {
        ArrayList<Column> originalCols = new ArrayList<Column>(this.columns);
        for (Column c : originalCols) {
            boolean remove = true;
            for (Column sourceCol : sourceCols) {
                if ((sourceCol.getColumn() != null || !sourceCol.getName().equals(c.getName())) && (sourceCol.getColumn() == null || !sourceCol.getColumn().equals(c.getColumn()))) continue;
                remove = false;
                c.updateToMatch(sourceCol);
                break;
            }
            if (!remove) continue;
            if (this.isPrimaryKeyIndex()) {
                this.getParent().moveAfterPK(c.getColumn());
                continue;
            }
            this.removeColumn(c);
        }
        int insertIndex = 0;
        for (Column c : sourceCols) {
            int currentIndex;
            if (c.getColumn() == null) {
                currentIndex = -1;
                for (int i = 0; i < originalCols.size(); ++i) {
                    Column t = (Column)originalCols.get(i);
                    if (!t.getName().equals(c.getName())) continue;
                    currentIndex = i;
                    break;
                }
            } else {
                currentIndex = this.indexOf(c.getColumn());
            }
            if (this.isPrimaryKeyIndex()) {
                if (currentIndex != -1 && currentIndex != insertIndex) {
                    this.getParent().changeColumnIndex(currentIndex, insertIndex, true);
                } else {
                    SQLColumn equivalentCol = SQLIndex.findEquivalentColumnNotIncluded(this.getParent(), this, c.getColumn());
                    this.getParent().changeColumnIndex(this.getParent().getColumnsWithoutPopulating().indexOf(equivalentCol), insertIndex, true);
                }
                this.getChild(insertIndex).setAscendingOrDescending(c.getAscendingOrDescending());
            } else if (currentIndex != -1 && currentIndex != insertIndex) {
                Column child = this.getChild(currentIndex);
                this.removeColumn(child);
                child.setAscendingOrDescending(c.getAscendingOrDescending());
                this.addIndexColumn(child, insertIndex);
            } else if (currentIndex == -1) {
                Column newCol = new Column(c.getName(), c.getAscendingOrDescending());
                newCol.setColumn(c.getColumn());
                this.addChild(newCol);
            }
            ++insertIndex;
        }
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof Column) {
            return this.removeColumn((Column)child);
        }
        throw new IllegalArgumentException("Cannot remove children of type " + child.getClass() + " from " + this.getName());
    }

    public boolean removeColumn(Column col) {
        int index = this.columns.indexOf(col);
        if (index != -1) {
            this.columns.remove(index);
            this.fireChildRemoved(Column.class, col, index);
            if (col.getColumn() != null) {
                col.getColumn().removeSPListener(col.targetColumnListener);
            }
            if (this.isPrimaryKeyIndex()) {
                this.getParent().updateRelationshipsForRemovedIndexColumns(col.getColumn());
            }
            col.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeColumn(SQLColumn col) {
        for (Column colWrapper : this.columns) {
            if (!colWrapper.getColumn().equals(col)) continue;
            return this.removeColumn(colWrapper);
        }
        return false;
    }

    @Override
    public int childPositionOffset(Class<? extends SPObject> childType) {
        if (childType == Column.class) {
            return 0;
        }
        throw new IllegalArgumentException("The type " + childType + " is not a valid child type of " + this.getName());
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
        for (SQLObject sQLObject : this.getChildren()) {
            sQLObject.removeDependency(dependency);
        }
    }

    @Override
    @NonProperty
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    public boolean containsColumn(SQLColumn column) {
        for (Column colWrapper : this.columns) {
            if (!colWrapper.getColumn().equals(column)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(SQLColumn col) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i).getColumn() == null || !this.columns.get(i).getColumn().equals(col)) continue;
            return i;
        }
        return -1;
    }

    @Transient
    @Accessor
    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public static class Column
    extends SQLObject {
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();
        private SQLColumn column;
        private AscendDescend ascendingOrDescending;
        private final TargetColumnListener targetColumnListener = new TargetColumnListener();

        public Column(SQLColumn col, AscendDescend ad) {
            this(col.getName(), ad);
            this.setColumn(col);
        }

        public Column(String name, AscendDescend ad) {
            this.setName(name);
            this.setPopulated(true);
            this.ascendingOrDescending = ad;
        }

        @Constructor
        public Column(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") SQLColumn col, @ConstructorParameter(propertyName="ascendingOrDescending") AscendDescend ad) {
            this(name, ad);
            this.setColumn(col);
        }

        public Column() {
            this((String)null, AscendDescend.UNSPECIFIED);
        }

        @Override
        @Accessor
        public SQLIndex getParent() {
            return (SQLIndex)super.getParent();
        }

        @Mutator
        public void setParent(SQLIndex parent) {
            super.setParent(parent);
        }

        @Override
        @Transient
        @Accessor
        public String getShortDisplayName() {
            return this.getName();
        }

        @Override
        protected void populateImpl() throws SQLObjectException {
        }

        @Override
        @Transient
        @Accessor
        public boolean isPopulated() {
            return true;
        }

        @Accessor
        public SQLColumn getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(SQLColumn column) {
            try {
                this.begin("Setting SQLIndex column");
                if (this.column != null) {
                    this.column.removeSPListener(this.targetColumnListener);
                }
                SQLColumn oldValue = this.column;
                this.column = column;
                if (this.column != null) {
                    this.column.addSPListener(this.targetColumnListener);
                }
                this.firePropertyChange("column", oldValue, column);
                if (this.column != null) {
                    this.setPhysicalName(column.getPhysicalName());
                }
                this.commit();
            }
            catch (RuntimeException e) {
                this.rollback(e.getMessage());
                throw e;
            }
        }

        @Accessor
        public AscendDescend getAscendingOrDescending() {
            return this.ascendingOrDescending;
        }

        @Mutator
        public void setAscendingOrDescending(AscendDescend ad) {
            AscendDescend oldValue = this.ascendingOrDescending;
            this.ascendingOrDescending = ad;
            this.firePropertyChange("ascendingOrDescending", (Object)oldValue, (Object)this.ascendingOrDescending);
        }

        @Mutator
        public void setAscending(boolean ascending) {
            AscendDescend oldValue = this.ascendingOrDescending;
            if (ascending) {
                this.ascendingOrDescending = AscendDescend.ASCENDING;
            }
            this.firePropertyChange("ascending", (Object)oldValue, (Object)this.ascendingOrDescending);
        }

        @Mutator
        public void setDescending(boolean descending) {
            AscendDescend oldValue = this.ascendingOrDescending;
            if (descending) {
                this.ascendingOrDescending = AscendDescend.DESCENDING;
            }
            this.firePropertyChange("descending", (Object)oldValue, (Object)descending);
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.ascendingOrDescending == AscendDescend.ASCENDING ? 1231 : 1237);
            result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
            result = 31 * result + (this.ascendingOrDescending == AscendDescend.DESCENDING ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Column other = (Column)obj;
            if (this.ascendingOrDescending != other.ascendingOrDescending) {
                return false;
            }
            return !(this.column == null ? other.column != null : !this.column.equals(other.column));
        }

        @Override
        public List<? extends SQLObject> getChildrenWithoutPopulating() {
            return Collections.emptyList();
        }

        @Override
        protected boolean removeChildImpl(SPObject child) {
            return false;
        }

        @Override
        public List<? extends SPObject> getDependencies() {
            return Collections.singletonList(this.column);
        }

        @Override
        public void removeDependency(SPObject dependency) {
            if (dependency == this.column) {
                this.getParent().removeColumn(this);
            }
        }

        @Override
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void updateToMatch(SQLObject source) throws SQLObjectException {
            Column sourceCol = (Column)source;
            this.setAscendingOrDescending(sourceCol.getAscendingOrDescending());
        }

        private class TargetColumnListener
        implements SPListener {
            private TargetColumnListener() {
            }

            @Override
            public void propertyChanged(PropertyChangeEvent e) {
                if ("name".equals(e.getPropertyName())) {
                    Column.this.setName((String)e.getNewValue());
                } else if ("physicalName".equals(e.getPropertyName())) {
                    Column.this.setPhysicalName((String)e.getNewValue());
                }
            }

            @Override
            public void childAdded(SPChildEvent e) {
            }

            @Override
            public void childRemoved(SPChildEvent e) {
            }

            @Override
            public void transactionStarted(TransactionEvent e) {
            }

            @Override
            public void transactionEnded(TransactionEvent e) {
            }

            @Override
            public void transactionRollback(TransactionEvent e) {
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append(Column.this.getParent().getName());
                buf.append(".");
                buf.append(Column.this.getName());
                buf.append(".");
                buf.append("TargetColumnListener");
                buf.append(" isPrimarykey?");
                buf.append(Column.this.getParent().isPrimaryKeyIndex());
                return buf.toString();
            }
        }
    }

    public static enum AscendDescend {
        ASCENDING,
        DESCENDING,
        UNSPECIFIED;

    }
}

