/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * **********************************************************/

/* Sets the proper defines and from the Linux header files */

#ifndef __VMX_CONFIG_H__
#define __VMX_CONFIG_H__

#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include <linux/autoconf.h>
#include "linux-version.h"

/* We rely on Kernel Module support.  Check here. */
#ifndef CONFIG_MODULES
#error "No Module support in this kernel.  Please configure with CONFIG_MODULES"
#endif

/* Are we SMP?  Linux 2.2.x has this in the autoconf file, but prior
 * versions need it hand coded. 
 */
#ifdef __SMP__
#undef __SMP__
#endif

#if defined(CONFIG_SMP) && !defined(SUPPORT_SMP)
#  error "SMP detected. Please uncomment SMP=1 in the Makefile."
#elif defined(KERNEL_2_1) && defined(SUPPORT_SMP)
#  define __SMP__ 1
#  define SMP_GLOBAL_VMLOCK
#endif

#if defined(CONFIG_MODVERSIONS) && defined(KERNEL_2_1)
#define MODVERSIONS
#include <linux/modversions.h>
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif

#endif
