/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: vm_basic_types.h,v 1.2 2003/02/16 01:29:51 bad Exp $
 * **********************************************************/

/*
 *
 * vm_basic_types.h -- 
 *
 *    basic data types.
 */

 
#ifndef _VM_BASIC_TYPES_H_
#define _VM_BASIC_TYPES_H_

typedef char           Bool;

#ifndef FALSE
#define FALSE          0
#endif

#ifndef TRUE
#define TRUE           1
#endif

#ifdef _MSC_VER
typedef unsigned __int64 uint64;
typedef signed __int64 int64;

#pragma warning (disable :4018) // signed/unsigned mismatch
#pragma warning (disable :4761) // integral size mismatch in argument; conversion supplied
#pragma warning (disable :4305) // truncation from 'const int' to 'short'
#pragma warning (disable :4244) // conversion from 'unsigned short' to 'unsigned char'
//#pragma warning (disable :4101) // unreferenced local variable
#pragma warning (disable :4133) // incompatible types - from 'struct VM *' to 'int *'
#pragma warning (disable :4047) // differs in levels of indirection
#pragma warning (disable :4146) // unary minus operator applied to unsigned type, result still unsigned
#pragma warning (disable :4142) // benign redefinition of type

#elif __GNUC__
typedef unsigned long long uint64;
typedef long long int64;
#else
#error - Need compiler define for int64/uint64
#endif

typedef unsigned int       uint32;
typedef unsigned short     uint16;
typedef unsigned char      uint8;

typedef int       int32;
typedef short     int16;
typedef char      int8;


/*
 * Printf format for 64-bit number.  Use it like this:
 *    printf("%"FMT64"d\n", big);
 */

#ifdef _MSC_VER
#define FMT64   "I64"
#elif __GNUC__
#define FMT64   "L"
#else
#error - Need compiler define for FMT64
#endif

#endif
