#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>

#include <err.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>

#define	PORT	12345

void
delay(int n)
{
	while (n-- > 0)
		/* nothing */;
}

void
usage(void)
{

	printf("usage: %s host loops delay\n", getprogname());
	exit(1);
}

int
main(int argc, char **argv)
{
	char buf[64];
	struct sockaddr_in addr;
	struct hostent *hp;
	char *name;
	int blen, delayloops, i, len, loops, num, s;

	if (argc != 4)
		usage();

	name = argv[1];
	hp = gethostbyname(name);
	if (hp == NULL)
		errx(1, "Cannot resolve \"%s\" (%s)", name, hstrerror(h_errno));
	memcpy(&addr.sin_addr, hp->h_addr, sizeof(addr.sin_addr));

	loops = atoi(argv[2]);
	if (loops < 1)
		usage();

	delayloops = atoi(argv[3]);
	if (delayloops < 1)
		usage();

	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		err(1, "socket");

	memset(buf, 0, sizeof(buf));
	strcpy(buf + 1, "Yo yo, batman!\n");

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(PORT);

	for (i = 0; i < loops; i++) {
		num = (arc4random() % 3) * 2 + 3;
		buf[0] = num;
		blen = arc4random() % 60 + 25;
		len = sendto(s, buf, blen, 0, (void *)&addr, sizeof(addr));
		if (len < 0)
			err(1, "sendto 1");

		len = recvfrom(s, buf, sizeof(buf), 0, NULL, NULL);
		if (len < 0)
			err(1, "recvfrom 1");

		delay(delayloops);
		if (i % 10000 == 9999)
			fprintf(stderr, "%8d\r", i + 1);
	}

	if (i > 9999)
		fprintf(stderr, "\n");
	exit(0);
}
