$NetBSD$
--- zaptel/zt_zone.c.orig	2007-09-12 12:07:38.000000000 +0100
+++ zaptel/zt_zone.c	2008-10-29 20:18:13.000000000 +0000
@@ -37,7 +37,11 @@
 #include <sys/systm.h>
 #include <sys/malloc.h>
 #include <sys/kernel.h>
+#ifdef __FreeBSD__
 #include <sys/selinfo.h>
+#elif defined(__NetBSD__)
+#include <sys/select.h>
+#endif
 
 #include "zaptel.h"
 #include "zaptel-compat.h"
@@ -131,7 +135,8 @@
 	z = tone_zones[num];
 	tone_zones[num] = NULL;
 	ZAP_UNLOCK(zone_lock);
-	free(z, M_ZAP_ZONE);
+	if (z)
+		free(z, M_ZAP_ZONE);
 	return 0;
 }
 
