$NetBSD$
--- zaptel/zt_timer.h.orig	2006-06-22 16:36:09.000000000 +0100
+++ zaptel/zt_timer.h	2008-10-29 20:18:13.000000000 +0000
@@ -49,11 +49,19 @@
 void zt_timers_start(void);
 void zt_timers_stop(void);
 
-int zt_timing_open(struct cdev * dev, int flag, struct thread * threadp);
+#ifdef __FreeBSD__
+int zt_timing_open(struct cdev * dev, int flag, zt_proc_t * threadp);
 void zt_timing_close(void);
 int zt_timer_close(struct cdev * dev);
-int zt_timer_poll(struct cdev * dev, int events, struct thread * t);
+int zt_timer_poll(struct cdev * dev, int events, zt_proc_t * t);
 int zt_timer_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, struct zt_timer * timer);
+#elif defined(__NetBSD__)
+int zt_timing_open(dev_t dev, int flag, zt_proc_t * threadp);
+void zt_timing_close(void);
+int zt_timer_close(struct file *);
+int zt_timer_poll(struct file *, int events, zt_proc_t * t);
+int zt_timer_ioctl(struct file *, u_long cmd, caddr_t arg, struct zt_timer * timer);
+#endif
 void process_timers(void);
 
 #endif /* _KERNEL */
