$NetBSD$
--- zaptel/zt_timer.c.orig	2006-06-25 19:21:49.000000000 +0100
+++ zaptel/zt_timer.c	2008-10-29 20:18:13.000000000 +0000
@@ -38,8 +38,12 @@
 #include <sys/systm.h>
 #include <sys/malloc.h>
 #include <sys/kernel.h>
-#include <sys/selinfo.h>
 #include <sys/ioccom.h>
+#ifdef __FreeBSD__
+#include <sys/selinfo.h>
+#elif defined(__NetBSD__)
+#include <sys/select.h>
+#endif
 
 #include "zaptel.h"
 #include "zaptel-compat.h"
@@ -53,7 +57,12 @@
 lock_t zaptimerlock;
 struct zt_timer *zaptimers = NULL;
 
-int zt_timing_open(struct cdev * dev, int flag, struct thread * threadp)
+
+#ifdef __FreeBSD__
+int zt_timing_open(struct cdev * dev, int flag, zt_proc_t * threadp)
+#elif defined(__NetBSD__)
+int zt_timing_open(dev_t dev, int flag, zt_proc_t * threadp)
+#endif
 {
 	struct zt_timer *t;
 
@@ -67,8 +76,8 @@
 	t->next = zaptimers;
 	zaptimers = t;
 	ZAP_UNLOCK(zaptimerlock);
-	dev->si_drv1 = t;
-	return 0;
+	printf("creating new timer %p\n", (void *) t);
+	return zt_clone(0, dev, flag, t, threadp);
 }
 
 void zt_timers_start()
@@ -82,11 +91,16 @@
 }
 
 
-int zt_timer_poll(struct cdev * dev, int events, struct thread * t)
+#ifdef __FreeBSD__
+int zt_timer_poll(struct cdev * dev, int events, zt_proc_t * t)
+#elif defined(__NetBSD__)
+int zt_timer_poll(struct file * dev, int events, zt_proc_t * t)
+#endif
 {
-	struct zt_timer * timer = (struct zt_timer *)dev->si_drv1;
+	struct zt_timer * timer;
 	int ret = 0;
 	int will_selrecord = 0;
+	timer = ZT_TIMER(dev);
 	if (timer) {
 		ZAP_LOCK(zaptimerlock);
 		if (timer->tripped || timer->ping) 
@@ -101,10 +115,14 @@
 	return ret;
 }
 
+#ifdef __FreeBSD__
 int zt_timer_close(struct cdev * dev)
+#elif defined(__NetBSD__)
+int zt_timer_close(struct file * dev)
+#endif
 {
 	struct zt_timer *t, *cur, *prev;
-	t = (struct zt_timer *)dev->si_drv1;
+	t = ZT_TIMER(dev);
 
 	if (t) {
 		ZAP_LOCK(zaptimerlock);
@@ -132,7 +150,11 @@
 	return 0;
 }
 
+#ifdef __FreeBSD__
 int zt_timer_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, struct zt_timer * timer)
+#elif defined(__NetBSD__)
+int zt_timer_ioctl(struct file * dev, u_long cmd, caddr_t arg, struct zt_timer * timer)
+#endif
 {
 	int j;
 	switch(cmd) {
@@ -167,7 +189,11 @@
 		ZAP_LOCK(zaptimerlock);
 		timer->ping = 1;		
 		/* wake_up_interruptible(&timer->sel); */
+#ifdef __FreeBSD__
 		_selwakeup(&timer->sel);
+#elif defined(__NetBSD__)
+		selwakeup(&timer->sel);
+#endif
 		ZAP_UNLOCK(zaptimerlock);
 		break;
 	case ZT_TIMERPONG:
@@ -192,7 +218,11 @@
 			if (cur->pos <= 0) {
 				cur->tripped++;
 				cur->pos = cur->ms;
+#ifdef __FreeBSD__
 				_selwakeup(&cur->sel);
+#elif defined(__NetBSD__)
+				selwakeup(&cur->sel);
+#endif
 			}
 		}
 		cur = cur->next;
