$NetBSD$
--- zaptel/zt_chan.c.orig	2007-06-27 17:27:27.000000000 +0100
+++ zaptel/zt_chan.c	2008-10-30 09:14:09.000000000 +0000
@@ -36,9 +36,13 @@
 #include <sys/conf.h>
 #include <sys/systm.h>
 #include <sys/malloc.h>
+#ifdef __FreeBSD__
 #include <sys/selinfo.h>
-#include <sys/kernel.h>
 #include <sys/module.h>
+#elif defined(__NetBSD__)
+#include <sys/select.h>
+#endif
+#include <sys/kernel.h>
 #include <sys/ioccom.h>
 #include <sys/fcntl.h>
 #include <sys/poll.h>
@@ -631,13 +635,13 @@
 {
 	bzero(chans, sizeof(chans));
 	bzero(spans, sizeof(spans));
-	mtx_init (&global_lock, "zaptel global lock", NULL, MTX_DEF);
+	ZAP_LOCK_INIT(global_lock, "zaptel global_lock");
 	fasthdlc_precalc();
 }
 
 void zt_channels_stop()
 {
-	mtx_destroy (&global_lock);
+	ZAP_LOCK_DESTROY(global_lock);
 }
 
 int initialize_channel(struct zt_chan *chan)
@@ -1096,7 +1100,7 @@
 		ifsppp->pp_flags = PP_KEEPALIVE;
 #endif
 
-		mtx_init (&chan->rqueue.ifq_mtx, "ztn_rqueue", NULL, MTX_DEF);
+		ZAP_LOCK_INIT (chan->rqueue.ifq_mtx, "ztn_rqueue");
 
 		ZAP_UNLOCK (chan->lock);
 		sppp_attach (ifp);
@@ -1155,7 +1159,7 @@
 		if(rqueue)
 		{
 			IF_DRAIN (rqueue);
-			mtx_destroy (&rqueue->ifq_mtx);
+			ZAP_LOCK_DESTROY(&rqueue->ifq_mtx);
 		}
 	}
 	zt_reallocbufs (chan, 0, 0);
@@ -1164,12 +1168,23 @@
 #endif /* CONFIG_ZAPATA_NET */
 
 
-int zt_chan_open(struct cdev * dev, int flag, struct thread * threadp)
-{
-	return 0;
-}
-
+#ifdef __FreeBSD__
+int zt_chan_open(struct cdev * dev, int flag, zt_proc_t * threadp)
+#elif defined(__NetBSD__)
+int zt_chan_open(dev_t dev, int flag, zt_proc_t * threadp)
+#endif
+  {
+#ifdef __NetBSD__
+	return zt_clone(0, dev, flag, 0, threadp);
+#endif
+  	return 0;
+  }
+  
+#ifdef __FreeBSD__
 int zt_chan_close(struct cdev * dev)
+#elif defined(__NetBSD__)
+int zt_chan_close(struct file * dev)
+#endif
 {
 	return 0;
 }
@@ -1179,7 +1194,7 @@
 	int x;
 	int res=0;
 	
-	mtx_lock(&global_lock);
+	ZAP_LOCK(global_lock);
 	for (x=1;x<ZT_MAX_CHANNELS;x++) {
 		if (!chans[x]) {
 			ZAP_LOCK_INIT(chan->lock, "Channel lock");
@@ -1202,7 +1217,7 @@
 			break;
 		}
 	}
-	mtx_unlock (&global_lock);
+	ZAP_UNLOCK (global_lock);
 	if (x >= ZT_MAX_CHANNELS)
 		printf("No more channels available\n");
 	return res;
@@ -1215,7 +1230,7 @@
 	struct ifnet *ifp = NULL;
 #endif
 
-	mtx_lock (&global_lock);
+	ZAP_LOCK (global_lock);
 	if (chan->flags & ZT_FLAG_REGISTERED) {
 		chans[chan->channo] = NULL;
 		chan->flags &= ~ZT_FLAG_REGISTERED;
@@ -1259,16 +1274,20 @@
 		}
 	chan->channo = -1;
 	ZAP_LOCK_DESTROY(chan->lock);
-	mtx_unlock (&global_lock);
+	ZAP_UNLOCK(global_lock);
 }
 
+#ifdef __FreeBSD__
 int zt_prechan_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit)
+#elif defined(__NetBSD__)
+int zt_prechan_ioctl(struct file * dev, u_long cmd, caddr_t arg, int unit)
+#endif
 {
 	struct zt_chan *chan;
 	int channo = 0;
 	int res;
 
-	chan = (struct zt_chan *) (dev->si_drv1);
+	chan = ZT_CHAN(dev);
 
 	if (chan) {
 		printf("Huh?  Prechan already has private data??\n");
@@ -1285,7 +1304,7 @@
 		if (!res) {
 			/* Setup the pointer for future stuff */
 			chan = chans[channo];
-			dev->si_drv1 = chan;
+			ZT_CHAN(dev) = chan;
 			/* Return success */
 			return 0;
 		}
@@ -1299,7 +1318,11 @@
 
 
 
+#ifdef __FreeBSD__
 int zt_chan_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit)
+#elif defined(__NetBSD__)
+int zt_chan_ioctl(struct file * dev, u_long cmd, caddr_t arg, int unit)
+#endif
 {
 	struct zt_chan *chan = chans[unit];
 	int j, rv;
@@ -1605,8 +1628,11 @@
 	return 0;
 }
 
-int zt_chan_poll(struct cdev * dev, int events, 
-			struct thread * t, int unit)
+#ifdef __FreeBSD__
+int zt_chan_poll(struct cdev * dev, int events, zt_proc_t * t, int unit)
+#elif defined(__NetBSD__)
+int zt_chan_poll(struct file * dev, int events, zt_proc_t * t, int unit)
+#endif
 {   
 	struct zt_chan *chan = chans[unit];
 	int	ret = 0;
@@ -1831,7 +1857,11 @@
 /* 
  * zt_specchan stuff
  */
+#ifdef __FreeBSD__
 int zt_specchan_open(struct cdev * dev, int unit, int inc)
+#elif defined(__NetBSD__)
+int zt_specchan_open(struct file *dev, int unit, int inc)
+#endif
 {
 	int res = 0;
 
@@ -1858,13 +1888,18 @@
 			} else {
 				close_channel(chans[unit]);
 			}
+			printf("res: %d\n", res);
 		}
 	} else
 		res = ENXIO;
 	return res;
 }
 
+#ifdef __FreeBSD__
 int zt_specchan_close(struct cdev * dev, int unit)
+#elif defined(__NetBSD__)
+int zt_specchan_close(struct file * dev, int unit)
+#endif
 {
 	int res=0;
 
@@ -1910,7 +1945,11 @@
 	}
 }
 
+#ifdef __FreeBSD__
 int zt_chanandpseudo_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit)
+#elif defined(__NetBSD__)
+int zt_chanandpseudo_ioctl(struct file * dev, u_long cmd, caddr_t arg, int unit)
+#endif
 {
 	struct zt_chan *chan = chans[unit];
 	union {
@@ -2024,7 +2063,11 @@
 			}
 			/* wake_up_interruptible waiting on read */
 			wakeup(&chan->readbufq);  
+#ifdef __FreeBSD__
 			_selwakeup(&chan->sel); /* wake_up_interruptible waiting on select */
+#elif defined(__NetBSD__)
+			selwakeup(&chan->sel); /* wake_up_interruptible waiting on select */
+#endif
 		   }
 		if (i & ZT_FLUSH_WRITE) /* if for write (output) */
 		   {
@@ -2037,7 +2080,11 @@
 				chan->writeidx[j] = 0;
 			}
 			wakeup(&chan->writebufq); 
+#ifdef __FreeBSD__
 			_selwakeup(&chan->sel);  /* wake_up_interruptible waiting on select */
+#elif defined(__NetBSD__)
+			selwakeup(&chan->sel);  /* wake_up_interruptible waiting on select */
+#endif
 			   /* if IO MUX wait on write empty, well, this
 				certainly *did* empty the write */
 			if (chan->iomask & ZT_IOMUX_WRITEEMPTY)
@@ -2866,7 +2913,7 @@
 	while (strlen(chan->txdialbuf)) {
 		c = chan->txdialbuf[0];
 		/* Skooch */
-		ovbcopy(chan->txdialbuf + 1, chan->txdialbuf, sizeof(chan->txdialbuf) - 1);
+		memmove(chan->txdialbuf, chan->txdialbuf + 1, sizeof(chan->txdialbuf) - 1);
 		switch(c) {
 		case 'T':
 		case 't':
@@ -3016,7 +3063,11 @@
 				if (!(ms->flags & (ZT_FLAG_NETDEV | ZT_FLAG_PPP))) {
 					/* TODO: interruptible */
 					wakeup(&ms->writebufq);
+#ifdef __FreeBSD__
 					_selwakeup(&ms->sel);
+#elif defined(__NetBSD__)
+					selwakeup(&ms->sel);
+#endif
 					if (ms->iomask & ZT_IOMUX_WRITE)
 						/* TODO: interruptible */
 						wakeup(&ms->eventbufq);
@@ -3292,7 +3343,11 @@
 #endif
 						/* TODO: interruptible */
 						wakeup(&ms->readbufq);
+#ifdef __FreeBSD__
 						_selwakeup(&ms->sel);
+#elif defined(__NetBSD__)
+						selwakeup(&ms->sel);
+#endif
 						if (ms->iomask & ZT_IOMUX_READ)
 							/* TODO: interruptible */
 							wakeup(&ms->eventbufq);
@@ -3779,6 +3834,7 @@
 	ZAP_UNLOCK(chan->lock);
 }
 
+#ifdef __FreeBSD__
 int zt_get_flags(struct cdev * dev)
 {
 	struct dev_info * info;
@@ -3804,7 +3860,17 @@
 	info->f_flags = flags;
 	
 }
+#elif defined(__NetBSD__)
+void zt_set_flags(struct file *dev, int flags)
+{
+	dev->f_flag = flags;
+}
 
+int zt_get_flags(struct file *dev)
+{
+	return dev->f_flag;
+}
+#endif
 char *zt_lboname(int x)
 {
 	if ((x < 0) || ( x > 7))
@@ -3812,7 +3878,11 @@
 	return zt_txlevelnames[x];
 }
 
+#ifdef __FreeBSD__
 int zt_common_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit)
+#elif defined(__NetBSD__)
+int zt_common_ioctl(struct file * dev, u_long cmd, caddr_t arg, int unit)
+#endif
 {
 	union {
 		struct zt_gains gain;
@@ -4366,7 +4436,11 @@
 	wakeup(&chan->readbufq);
 	/* TODO: interraptable */
 	wakeup(&chan->writebufq);
+#ifdef __FreeBSD__
 	_selwakeup(&chan->sel);
+#elif defined(__NetBSD__)
+	selwakeup(&chan->sel);
+#endif
 	return;
 }
 
