/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Manifest;
import org.codehaus.mojo.natives.linker.ManifestConfiguration;
import org.codehaus.mojo.natives.manager.ManifestManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;

@Mojo(name="manifest", defaultPhase=LifecyclePhase.PACKAGE)
public class NativeManifestMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="msvc", required=true)
    private String provider;
    @Parameter(defaultValue="manifest", required=true)
    private String manifestExtension;
    @Parameter(defaultValue="false")
    private boolean checkStaleLinkage;
    @Component
    private ManifestManager manager;

    public void execute() throws MojoExecutionException {
        File linkerOutputFile = (File)this.getPluginContext().get("NativeLinkerOutputPath");
        if (!linkerOutputFile.exists()) {
            return;
        }
        File linkerManifestFile = new File(linkerOutputFile.getAbsolutePath() + "." + this.manifestExtension);
        if (!linkerManifestFile.exists()) {
            return;
        }
        try {
            ManifestConfiguration config = new ManifestConfiguration();
            config.setEnvFactory(this.getEnvFactory());
            config.setWorkingDirectory(this.workingDirectory);
            config.setInputFile(linkerOutputFile);
            config.setManifestFile(linkerManifestFile);
            Manifest Manifest2 = this.getManifest();
            Manifest2.run(config);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException("Error executing Manifest.", (Exception)((Object)e));
        }
    }

    private Manifest getManifest() throws MojoExecutionException {
        Manifest Manifest2;
        try {
            Manifest2 = this.manager.getManifest(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return Manifest2;
    }
}

