/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Kevin Cornell (Rational Software Corporation)
 *******************************************************************************/

// This is a sample program to test the eclipse launcher.
// 
// If you are running this test program on Windows, the launcher
// should use java.exe and not javaw.exe. This can be done using
// either the -vm or -debug switch.
//
// To select a feature directory, use the option: -feature <directory>
// To perform a restart, you must run the launcher in an xterm
// (or use java.exe on Windows) and use the -debug switch.


package org.eclipse.core.launcher;


public class Main {

private static final String ENDSPLASH  = "-endsplash";
private static final String SHOWSPLASH = "-showsplash";
private static final String EXITDATA   = "-exitdata";
private static final String FEATURE    = "-feature";
private static final String DEBUG      = "-debug";
private static final String VM         = "-vm";
private static final String VMARGS     = "-vmargs";
private static String    showSplashCmd = null;
private static String    endSplashCmd  = null;
private static String    exitDataCmd  = null;
private static Process   splashProcess = null;
private static String    featureDir = null;
private static String    vm = null;
private static int vmargsIndex = 0;
private static boolean  debug = false;

private static String getSplashPath()
{
	return featureDir;
}

public static void endSplash()
{
	// If the new splash mechanism was used
	if (splashProcess != null)
	{
		// Terminate the splash screen process.
		splashProcess.destroy();
	}
	
	// else if the old splash mechanism was used
	else if (endSplashCmd != null)
	{
		// Bring down the splash screen nicely.
		try 
		{
			if (debug)
				System.out.println( "Eclipse: Executing '" + endSplashCmd + "'");
			Runtime.getRuntime().exec(endSplashCmd);
		} 
		catch (Exception e) { }
	}
	
	// else no splash screen was displayed.
}

private static void showSplash() 
{
	if (showSplashCmd == null)
		return; // running with original -endsplash

	// Parse the showsplash command into its separate arguments.
	// The command format is: 
	//     <executable> -showsplash <magicNum> [<featureDir>]
	// If either the <executable> or the <featureDir> arguments contain a
	// space, Runtime.getRuntime().exec( String ) will not work properly, even
	// if both arguments are enclosed in double-quotes. The solution is to
	// use the Runtime.getRuntime().exec( String[] ) method.
	String path  = getSplashPath();
	String[] cmd = new String[ (path != null ? 4 : 3) ];
	int sIndex = 0;
	int eIndex = showSplashCmd.indexOf( " -show" );
	cmd[0] = showSplashCmd.substring( sIndex, eIndex );
	sIndex = eIndex + 1;
	eIndex = showSplashCmd.indexOf( " ", sIndex );
	cmd[1] = showSplashCmd.substring( sIndex, eIndex );
	cmd[2] = showSplashCmd.substring( eIndex+1 );
	if (path != null)
		cmd[3] = path;
	try 
	{
		if (debug)
		{
			System.out.print( "Eclipse: Executing");
			for (int i = 0; i < cmd.length; i++)
			    System.out.print( " " + cmd[i] );
			System.out.println("");
		}
		splashProcess = Runtime.getRuntime().exec(cmd);
	} 
	catch (Exception e) 
	{
		if (debug)
			System.out.println("Eclipse: Exception in showSplash\n" + e);
	}
}

private static void setSharedData(String data, String[] args) 
{
	if (exitDataCmd == null)
		return; // running with original -endsplash

	// Parse the shared command into its separate arguments.
	// The command format is: 
	//     <executable> -shared <magicNum> [<data>]
	// If either the <executable> or the <data> arguments contain a
	// space, Runtime.getRuntime().exec( String ) will not work properly, even
	// if both arguments are enclosed in double-quotes. The solution is to
	// use the Runtime.getRuntime().exec( String[] ) method.
	if (data == null) {
		StringBuffer buf = new StringBuffer();
		buf.append(vm);
		buf.append('\n');
		for (int i = vmargsIndex; i < args.length; i++) {
			String string = args[i];
			buf.append(string);
			buf.append('\n');
		}
		String[] newArgs = new String[]{"-data", "/home/eclipse/newdata"};
		for (int i = 0; i < newArgs.length; i++) {
			String string = newArgs[i];
			buf.append(string);
			buf.append('\n');
		}		
		for (int i = 0; i < args.length; i++) {
			String string = args[i];
			buf.append(string);
			buf.append('\n');
		}
		data = buf.toString();
	}
	String[] cmd = new String[ (data != null ? 4 : 3) ];
	int sIndex = 0;
	int eIndex = exitDataCmd.indexOf( " -exitdata" );
	cmd[0] = exitDataCmd.substring( sIndex, eIndex );
	sIndex = eIndex + 1;
	eIndex = exitDataCmd.indexOf( " ", sIndex );
	cmd[1] = exitDataCmd.substring( sIndex, eIndex );
	cmd[2] = exitDataCmd.substring( eIndex+1 );
	if (data != null)
		cmd[3] = data;
	try 
	{
		if (debug)
		{
			System.out.print( "Eclipse: Executing");
			for (int i = 0; i < cmd.length; i++)
			    System.out.print( " " + cmd[i] );
			System.out.println("");
		}
		Process sharedProcess = Runtime.getRuntime().exec(cmd);
		sharedProcess.waitFor();
		if (debug) {
			System.out.println("done");
		}
	} 
	catch (Exception e) 
	{
		if (debug)
			System.out.println("Eclipse: Exception in showSplash\n" + e);
	}
}

public static void main( String args[] ) 
{
	byte[]  answer = new byte[ 500 ];
	int     nRead;
	boolean console = true;

    // Extract the commands to show and end the splash window. 
    for (int index = 0; index < args.length; index++)
    {
        if (args[ index ].equalsIgnoreCase( ENDSPLASH ) && (index+1) < args.length)
        {
            endSplashCmd = args[ index + 1 ];
        }

        else if (args[ index ].equalsIgnoreCase( SHOWSPLASH ) && (index+1) < args.length)
        {
            showSplashCmd = args[ index + 1 ];
        }

        else if (args[ index ].equalsIgnoreCase( EXITDATA ) && (index+1) < args.length)
        {
            exitDataCmd = args[ index + 1 ];
        }
 
        else if (args[ index ].equalsIgnoreCase( FEATURE ) && (index+1) < args.length)
        {
            featureDir = args[ index + 1 ];
        }

        else if (args[ index ].equalsIgnoreCase( VM ) && (index+1) < args.length)
        {
            vm = args[ index + 1 ];
        }

        else if (args[ index ].equalsIgnoreCase( VMARGS ) && (index+1) < args.length)
        {
        	vmargsIndex = index + 1;
            break;
        }

        else if (args[ index ].equalsIgnoreCase( DEBUG ))
        {
            debug = true;
        }
    }


    // Print the commands if debugging. 
    if (debug)
    {
    	System.out.println( "Eclipse: Program started." );
    	for (int index = 0; index < args.length; index++)
        	System.out.println( "    args[" + index + "] = '" + args[index] + "'" );
    }
    
    // Attempt to show the splash screen.
    showSplash();

	// Wait for the initialization to complete.
	if (debug)
	{
    	try
    	{
    		System.out.print("Eclipse: Hit return to end initialization. ");
    		nRead = System.in.read(answer);
    	}
    	catch (Exception e) {}
	}
	else
    {
    	// Quietly wait for 5 seconds
    	try 
    	{
        	Thread.sleep( 5000 );
    	}
    	catch (Exception e) {}
    }
	
    // Bring down the splash screen.
    endSplash();

    // Simulate the actual work of eclipse. (wait 1 seconds)
    try 
    {
        Thread.sleep( 1000 );
    }
    catch (Exception e) {}
    
    // Determine if a restart is required.
    if (debug)
    {
	    int exitCode = 0;
	    try
	    {
	    	System.out.println( "Eclipse special exit codes:\n" +
	    					    "  0  - normal exit\n" +
	    					    "  13 - problem during startup\n" +
	    					    "  14 - wrong JVM being used\n" +
	    					    "  15 - workbench already running\n" +
	    					    "  16 - display error message in shared data\n" +
	    					    "  23 - restart previous command\n" +
	    						"  24 - restart command shared data" );
	    	System.out.print("Eclipse: Enter the exit code: ");
	    	nRead = System.in.read(answer);
	    	String value = new String(answer).trim();
	    	if (value.length() > 0) {
	    		exitCode = Integer.parseInt(value);
	    		
	    		switch (exitCode) {
	    			case 13: setSharedData("Problem during startup.", null); exitCode = 16; break;
	    			case 14: setSharedData("Wrong VM version > 1.3.1.", null); exitCode = 16; break;
	    			case 15: setSharedData("Workspace already in use.", null); exitCode = 16; break;
	    			case 24: setSharedData(null, args); break;
	    		}
	    	}
	    }
	    catch (Exception e) {}
	    System.exit(exitCode);
	       
    }
}
}
