/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.useradmin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.useradmin.UserAdminPermissionCollection;

public final class UserAdminPermission
extends BasicPermission {
    public static final String ADMIN = "admin";
    public static final String CHANGE_PROPERTY = "changeProperty";
    private static final int ACTION_CHANGE_PROPERTY = 1;
    public static final String CHANGE_CREDENTIAL = "changeCredential";
    private static final int ACTION_CHANGE_CREDENTIAL = 2;
    public static final String GET_CREDENTIAL = "getCredential";
    private static final int ACTION_GET_CREDENTIAL = 4;
    private static final int ACTION_ALL = 7;
    static final int ACTION_NONE = 0;
    private String actions = null;
    private transient int action_mask = 0;
    private transient String description;

    public UserAdminPermission(String string, String string2) {
        this(string, UserAdminPermission.getMask(string2));
    }

    UserAdminPermission(String string, int n) {
        super(string);
        this.init(n);
    }

    private void init(int n) {
        if (this.getName().equals(ADMIN)) {
            if (n != 0) {
                throw new IllegalArgumentException("Actions specified for no-action UserAdminPermission");
            }
        } else if (n == 0 || (n & 7) != n) {
            throw new IllegalArgumentException("Invalid action string");
        }
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl37
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (var4_4 >= 12 && UserAdminPermission.match_get(var3_3, var4_4 - 10) && UserAdminPermission.match_credential(var3_3, var4_4)) {
                    var6_6 = 13;
                    var2_2 |= 4;
                } else if (var4_4 >= 13 && UserAdminPermission.match_change(var3_3, var4_4 - 8) && UserAdminPermission.match_property(var3_3, var4_4)) {
                    var6_6 = 14;
                    var2_2 |= 1;
                } else if (var4_4 >= 15 && UserAdminPermission.match_change(var3_3, var4_4 - 10) && UserAdminPermission.match_credential(var3_3, var4_4)) {
                    var6_6 = 16;
                    var2_2 |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl37:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    private static boolean match_change(char[] cArray, int n) {
        return !(cArray[n - 5] != 'c' && cArray[n - 5] != 'C' || cArray[n - 4] != 'h' && cArray[n - 4] != 'H' || cArray[n - 3] != 'a' && cArray[n - 3] != 'A' || cArray[n - 2] != 'n' && cArray[n - 2] != 'N' || cArray[n - 1] != 'g' && cArray[n - 1] != 'G' || cArray[n - 0] != 'e' && cArray[n - 0] != 'E');
    }

    private static boolean match_get(char[] cArray, int n) {
        return !(cArray[n - 2] != 'g' && cArray[n - 2] != 'G' || cArray[n - 1] != 'e' && cArray[n - 1] != 'E' || cArray[n - 0] != 't' && cArray[n - 0] != 'T');
    }

    private static boolean match_property(char[] cArray, int n) {
        return !(cArray[n - 7] != 'p' && cArray[n - 7] != 'P' || cArray[n - 6] != 'r' && cArray[n - 6] != 'R' || cArray[n - 5] != 'o' && cArray[n - 5] != 'O' || cArray[n - 4] != 'p' && cArray[n - 4] != 'P' || cArray[n - 3] != 'e' && cArray[n - 3] != 'E' || cArray[n - 2] != 'r' && cArray[n - 2] != 'R' || cArray[n - 1] != 't' && cArray[n - 1] != 'T' || cArray[n - 0] != 'y' && cArray[n - 0] != 'Y');
    }

    private static boolean match_credential(char[] cArray, int n) {
        return !(cArray[n - 9] != 'c' && cArray[n - 9] != 'C' || cArray[n - 8] != 'r' && cArray[n - 8] != 'R' || cArray[n - 7] != 'e' && cArray[n - 7] != 'E' || cArray[n - 6] != 'd' && cArray[n - 6] != 'D' || cArray[n - 5] != 'e' && cArray[n - 5] != 'E' || cArray[n - 4] != 'n' && cArray[n - 4] != 'N' || cArray[n - 3] != 't' && cArray[n - 3] != 'T' || cArray[n - 2] != 'i' && cArray[n - 2] != 'I' || cArray[n - 1] != 'a' && cArray[n - 1] != 'A' || cArray[n - 0] != 'l' && cArray[n - 0] != 'L');
    }

    public boolean implies(Permission permission) {
        if (permission instanceof UserAdminPermission) {
            UserAdminPermission userAdminPermission = (UserAdminPermission)permission;
            return (userAdminPermission.action_mask & this.action_mask) == userAdminPermission.action_mask && (userAdminPermission.action_mask != 0 || this.action_mask == 0) && super.implies(permission);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if ((this.action_mask & 2) == 2) {
                stringBuffer.append(CHANGE_CREDENTIAL);
                bl = true;
            }
            if ((this.action_mask & 1) == 1) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(CHANGE_PROPERTY);
                bl = true;
            }
            if ((this.action_mask & 4) == 4) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(GET_CREDENTIAL);
            }
            this.actions = stringBuffer.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new UserAdminPermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UserAdminPermission) {
            UserAdminPermission userAdminPermission = (UserAdminPermission)object;
            return this.action_mask == userAdminPermission.action_mask && this.getName().equals(userAdminPermission.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(UserAdminPermission.getMask(this.actions));
    }

    public String toString() {
        if (this.description == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(" \"");
            stringBuffer.append(this.getName());
            String string = this.getActions();
            if (string.length() > 0) {
                stringBuffer.append("\" \"");
                stringBuffer.append(string);
            }
            stringBuffer.append("\")");
            this.description = stringBuffer.toString();
        }
        return this.description;
    }
}

