/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.FeatureImportWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.WorkbenchHelp;

public class FeatureImportWizardDetailedPage
extends WizardPage {
    private FeatureImportWizardFirstPage fFirstPage;
    private IPath fDropLocation;
    private CheckboxTableViewer fFeatureViewer;
    private TablePart fTablePart;
    private IFeatureModel[] fModels;

    public FeatureImportWizardDetailedPage(FeatureImportWizardFirstPage firstPage) {
        super("FeatureImportWizardDetailedPage");
        this.setTitle(PDEPlugin.getResourceString("FeatureImportWizard.DetailedPage.title"));
        this.setDescription(PDEPlugin.getResourceString("FeatureImportWizard.DetailedPage.desc"));
        this.fFirstPage = firstPage;
        this.fDropLocation = null;
        this.fTablePart = new TablePart(PDEPlugin.getResourceString("FeatureImportWizard.DetailedPage.featureList"));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFields(IPath dropLocation) {
        if (!dropLocation.equals(this.fDropLocation)) {
            this.fDropLocation = dropLocation;
            this.fModels = null;
        }
        if (this.fModels == null) {
            this.getModels();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(PDEPlugin.getResourceString("FeatureImportWizard.messages.updating"), -1);
                    FeatureImportWizardDetailedPage.this.fFeatureViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            FeatureImportWizardDetailedPage.access$200(1.access$100(this.this$1)).setInput((Object)PDEPlugin.getDefault());
                            if (1.access$100(this.this$1).getModels() != null) {
                                FeatureImportWizardDetailedPage.access$200(1.access$100(this.this$1)).setCheckedElements((Object[])1.access$100(this.this$1).getModels());
                            }
                            FeatureImportWizardDetailedPage.access$300(1.access$100(this.this$1)).updateCounter(1.access$100(this.this$1).getModels().length);
                        }
                    });
                    monitor.done();
                }

                static /* synthetic */ FeatureImportWizardDetailedPage access$100(1 x0) {
                    return x0.FeatureImportWizardDetailedPage.this;
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            finally {
                this.dialogChanged();
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeFields(this.fFirstPage.getDropLocation());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.fTablePart.createControl(container);
        this.fFeatureViewer = this.fTablePart.getTableViewer();
        this.fFeatureViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fFeatureViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData gd = (GridData)this.fTablePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.setControl((Control)container);
        this.dialogChanged();
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.feature_import_second_page");
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public IFeatureModel[] getModels() {
        if (this.fModels != null) {
            return this.fModels;
        }
        final ArrayList result = new ArrayList();
        final IPath home = this.fDropLocation;
        if (home != null) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask(PDEPlugin.getResourceString("FeatureImportWizard.messages.loadingFile"), -1);
                    try {
                        MultiStatus errors = FeatureImportWizardDetailedPage.this.doLoadFeatures(result, FeatureImportWizardDetailedPage.this.createPath(home), monitor);
                        if (errors != null && errors.getChildren().length > 0) {
                            PDEPlugin.log((IStatus)errors);
                        }
                        FeatureImportWizardDetailedPage.access$602(FeatureImportWizardDetailedPage.this, result.toArray(new IFeatureModel[result.size()]));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
        }
        return this.fModels;
    }

    private File createPath(IPath dropLocation) {
        File featuresDir = new File(dropLocation.toFile(), "features");
        if (featuresDir.exists()) {
            return featuresDir;
        }
        return null;
    }

    private MultiStatus doLoadFeatures(ArrayList result, File path, IProgressMonitor monitor) throws CoreException {
        if (path == null) {
            return null;
        }
        File[] dirs = path.listFiles();
        if (dirs == null) {
            return null;
        }
        monitor.beginTask(PDEPlugin.getResourceString("FeatureImportWizard.DetailedPage.loading"), dirs.length);
        ArrayList<IStatus> resultStatus = new ArrayList<IStatus>();
        for (int i = 0; i < dirs.length; ++i) {
            IStatus status;
            File dir = dirs[i];
            if (!dir.isDirectory()) continue;
            File manifest = new File(dir, "feature.xml");
            if (manifest.exists() && (status = this.doLoadFeature(dir, manifest, result)) != null) {
                resultStatus.add(status);
            }
            monitor.worked(1);
        }
        if (resultStatus != null) {
            IStatus[] children = resultStatus.toArray(new IStatus[resultStatus.size()]);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.pde.ui", 0, children, PDEPlugin.getResourceString("FeatureImportWizard.DetailedPage.problemsLoading"), null);
            return multiStatus;
        }
        return null;
    }

    private IStatus doLoadFeature(File dir, File manifest, ArrayList result) {
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(dir.getAbsolutePath());
        Status status = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(manifest);
            model.load((InputStream)stream, false);
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.pde.ui", 0, e.getMessage(), (Throwable)e);
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (status == null) {
            result.add(model);
        }
        return status;
    }

    public IFeatureModel[] getSelectedModels() {
        Object[] selected = this.fFeatureViewer.getCheckedElements();
        IFeatureModel[] result = new IFeatureModel[selected.length];
        System.arraycopy(selected, 0, result, 0, selected.length);
        return result;
    }

    private void dialogChanged() {
        String message = null;
        if (this.fFeatureViewer != null && this.fFeatureViewer.getTable().getItemCount() == 0) {
            message = PDEPlugin.getResourceString("FeatureImportWizard.messages.noFeatures");
        }
        this.setMessage(message, 1);
        this.setPageComplete(this.fTablePart.getSelectionCount() > 0);
    }

    public boolean isPageComplete() {
        return this.fTablePart.getSelectionCount() > 0;
    }

    static /* synthetic */ TablePart access$300(FeatureImportWizardDetailedPage x0) {
        return x0.fTablePart;
    }

    static /* synthetic */ IFeatureModel[] access$602(FeatureImportWizardDetailedPage x0, IFeatureModel[] x1) {
        x0.fModels = x1;
        return x1;
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            FeatureImportWizardDetailedPage.this.dialogChanged();
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setSorter(ListUtil.FEATURE_SORTER);
            return viewer;
        }
    }

    public class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return FeatureImportWizardDetailedPage.this.getModels();
        }
    }
}

