/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class SchemaDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;
    protected static char[] fgBrackets = new char[]{'(', ')', '\"', '\"'};

    public void doubleClicked(ITextViewer part) {
        this.fPos = part.getSelectedRange().x;
        if (this.fPos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectComment()) {
            this.selectWord();
        }
    }

    protected boolean matchComment() {
        IDocument doc = this.fText.getDocument();
        try {
            int pos;
            char c = ' ';
            for (pos = this.fPos; pos >= 0 && !Character.isWhitespace(c = (char)doc.getChar(pos)) && c != '\"'; --pos) {
            }
            if (c != '\"') {
                return false;
            }
            this.fStartPos = pos;
            int length = doc.getLength();
            c = ' ';
            for (pos = this.fPos; pos < length && !Character.isWhitespace(c = (char)doc.getChar(pos)) && c != '\"'; ++pos) {
            }
            if (c != '\"') {
                return false;
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos;
            for (pos = this.fPos; pos >= 0 && Character.isJavaIdentifierPart(c = doc.getChar(pos)); --pos) {
            }
            this.fStartPos = pos;
            int length = doc.getLength();
            for (pos = this.fPos; pos < length && Character.isJavaIdentifierPart(c = doc.getChar(pos)); ++pos) {
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean selectComment() {
        if (this.matchComment()) {
            this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos);
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos);
        }
    }
}

